processWholeGenomeCovg <- function(res_list,
                          statfile = NA,         
                          reliable.idx,
                          png_filename, txt_filename,
                          odd.col='magenta', even.col='dodgerblue',plot.cex=0.6,
                          is.chr.labeled=TRUE, is.txt.output=TRUE, output.digit=3,
                          odd.y.pos=-10,even.y.pos=-38,label.cex=1)
  
{

  autosome.idx <- intersect(which(!is.element(res_list$chr,c('chrX','chrY','chrM') )),
                            reliable.idx)
  chr <- res_list$chr[reliable.idx]
  gc <- res_list$gc[reliable.idx]
  counts <- res_list$c.count[reliable.idx]
  
  crct.median <- median(res_list$c.count[autosome.idx],na.rm = TRUE) 
  if (crct.median == 0) {  # if low-pass, using mean instead of median to avoid dividing zero, plus a small offset
    
    crct.median <- mean(res_list$c.count[autosome.idx],na.rm = TRUE) + 1e-2 
    nmlz.cvg <- res_list$o.count/crct.median # low pass, avoid over-correction
    
  } else {
    
    nmlz.cvg <- res_list$c.count/crct.median
    
  }
  
  bin.sum.mtx <- data.frame(Chr= res_list$chr,Start.Pos=res_list$loc,
                            nmlz.cvg=round(nmlz.cvg, digits=output.digit),
                            corrected.count=res_list$o.count, # low pass, avoid over-correction
                            original.count=res_list$o.count,
                            gc.content=round(res_list$gc,digits=output.digit),
                            is.reliable.bin=as.numeric(is.element( seq(1, length(res_list$chr) ), reliable.idx)) )

  
  if(is.txt.output)
    {
     ####txt_filename 
     write.table(x=bin.sum.mtx,file=txt_filename,quote=FALSE,row.names=FALSE,sep='\t')
    }

  sel.sample.ID <- sapply(strsplit(sapply(strsplit(png_filename, split='/'), getElement, length(unlist(strsplit(png_filename, split='/')))), split='_'), getElement, 1)

  #raw_covg.png; corrected_CNV.png; corrected_smoothed.png 
  ## plot the raw coverage
  r1 <- as.data.frame(bin.sum.mtx)
  r1$original.count <- as.numeric(r1$original.count);
  r1$nmlz.cvg <- as.numeric(r1$nmlz.cvg)
  r1$is.reliable.bin <- as.numeric(r1$is.reliable.bin)
  r1$Start.Pos <- as.numeric(r1$Start.Pos)
  
  output.file <- gsub("_covg.png", "_raw_covg.png", png_filename)
  sel.idx <- which(r1$Chr != "chrM")
  chr.vec <- r1$Chr[sel.idx]
  x.vec   <- r1$original.count[sel.idx]
  
  WholeGenome.Plot(png_filename = output.file, chr = chr.vec, x = x.vec, 
                   sample.name = paste("of",sel.sample.ID," (raw)") )

  ## plot the corrected cvg if the reference file is not null
  ##
  if( !is.na(statfile) ) { 
    rbackground <- read.delim(statfile, sep = "\t")
    rbackground$median.vec <- as.numeric(rbackground$median)
    sel.idx2 <- which(r1$Chr != "chrM" & r1$is.reliable.bin==1)
    chr.vec2 <- r1$Chr[sel.idx2]
    pos.vec2 <- r1$Start.Pos[sel.idx2]
    x.vec2  <- log2(r1$nmlz.cvg[sel.idx2] / rbackground$median.vec[sel.idx2])
    x.vec2 <- 2*2^(x.vec2)
    
    output.file2 <- gsub("_covg.png", "_corrected_CNV.png", png_filename)
    WholeGenome.Plot(png_filename = output.file2, chr = chr.vec2, x = x.vec2,
                     sample.name = paste("of", sel.sample.ID, "(corrected)"), 
                     up.y = 4, lo.y = 0, ylab = "Copy number",
                     med.line.col = "grey",
                     odd.y.pos = 0.1, even.y.pos = 0.5)
    
    
    merg.windowsize <- 50e3
    x.vec3 <- x.vec2
    for( sel.chr in paste("chr",c(seq(1,22),"X","Y"),sep = "" )){
      cat(sel.chr,",")
      tmp.idx <- which(chr.vec2 == sel.chr)
      N.bin <- length(tmp.idx)
      for(k in 1 : N.bin){
        merg.idx <- which(abs(pos.vec2[tmp.idx[k]] - pos.vec2[tmp.idx])<=merg.windowsize)
        x.vec3[tmp.idx[k]] <- mean(x.vec2[tmp.idx[merg.idx]], na.rm = TRUE)
      }
    }
    
    output.file3 <- gsub("_covg.png", "_corrected_CNV_50k_smooth.png", png_filename)
    WholeGenome.Plot(png_filename = output.file3, chr = chr.vec2, x = x.vec3,
                     sample.name = paste("of", sel.sample.ID, "(corrected & smoothed)"), 
                     up.y = 4, lo.y = 0, ylab = "Copy number",
                     med.line.col = "darkgrey", plot.cex = 0.3, 
                     odd.y.pos = 0.1, even.y.pos = 0.5)
  }
  
  return(as.data.frame(bin.sum.mtx))
  
}
