WholeGenome.Plot <- function(png_filename, chr, x,
              sample.name="sample", ylab = "Coverage (reads)",
              up.y=NULL, lo.y = -50, plot.log = "",
              odd.col='magenta', even.col='dodgerblue',plot.cex=0.6, plot.pch = 1, plot.bg.color = "white",
              is.chr.labeled=TRUE, is.txt.output=TRUE, output.digit=3,
              odd.y.pos=-10,even.y.pos=-38,label.cex=1, med.line.col = "red")
{
  color_vec <- as.character(chr)
  odd.chr <- c(paste('chr', seq(1,22,2), sep=''), "chrX")
  even.chr <- c(paste('chr', seq(2,22,2), sep=''), "chrY")
  color_vec[which(is.element(color_vec,odd.chr))] <- odd.col
  color_vec[which(is.element(color_vec,even.chr))] <- even.col 
  
  
  png(png_filename,width=3.6e3,height=1.1e3,res=210)
  if(is.null(up.y)){up.y <- quantile(x,0.995,na.rm=TRUE)*2.5}
  
  plot(x,cex=plot.cex, pch = plot.pch, bg=plot.bg.color,
       col = color_vec, ylim = c(lo.y, up.y),
       xlab = 'Bin index',ylab = ylab,
       main=paste('profile of',sample.name), log = plot.log)
  #abline(h=res_list$median,lwd=3,col='red',lty=3)
  abline(h=median(x, na.rm = TRUE),lwd=3,col=med.line.col,lty=3)
  
  chr.Str <- c( seq(1,22), "X", "Y")
  if(is.chr.labeled)
  {
    for(chr.idx in 1:24)
    {
      tmp.chr <- paste('chr',chr.Str[chr.idx],sep='')
      sel.pos.idx <- which(chr==tmp.chr)
      median_pos <- median(sel.pos.idx)
      max_pos <- max(sel.pos.idx)
      if(is.element(tmp.chr,odd.chr) )
      { tmp.col <- odd.col 
      y.tmp.pos <- odd.y.pos
      } else {
        tmp.col <- even.col
        y.tmp.pos <- even.y.pos
      }
      text(x=median_pos,y=y.tmp.pos,labels=chr.Str[chr.idx],
           col=tmp.col,cex=label.cex)
      if(chr.idx!=24) # don't plot for chrY
      { abline( v =  max_pos, lwd = 3, lty = 2, col = "grey") }
    }
  }
  
  dev.off()
}
