#========== Oct. 1st, 2014

require(gplots)
require(DNAcopy)
require(impute)

options(stringsAsFactors = FALSE)

wandyCNV.install.DIR <- getwd()
wandyCNV.version <- "_wandy_ver0p98"

function_vec <- c(
		  
  "wandy.miscFunctions.R",
  "WholeGenome.Plot.R",
  "correctGCbias.R",
  "processWholeGenomeCovg.R",
  "getCNVseg.R",
  
  "wandy.analyzeSample.R",
  "wandy.analyzeRun.R"
            			)		 	

for (i in 1:length(function_vec))
{
  tmp_func <- paste(wandyCNV.install.DIR,'/functions/',function_vec[i],sep='')
  source(tmp_func)
}

cat('\n ========================================================= \n')
cat('\n R functions of whole-genome aneuploidy CNV (', gsub("_",".",wandyCNV.version), ') have been successfully loaded! \n')
cat('\n ========================================================= \n')
