

wandy.create.DIR <- function( DIR_name )
{
  if (!file.exists(DIR_name) ){
    #  cat('\"',DIR_name,'\" does not exist, creating directory...\n',sep='')
    dir.create(file.path(DIR_name),showWarnings=FALSE)
  }
}

Ascore.kernel <- function( x, sigma1, sigma2 = 1, alpha = 1, beta = 0 ){
  # sigma1 is a single value 
  # sigma2 could be a vector
  compound.sigma <- alpha * ( (1 - beta) * sigma1 + beta * sigma2 )
  return(  1 - exp( -(x)^2/ (alpha*compound.sigma)^2 ) )
}


myWeighted.Avg <- function(count.vec, val.vec){
  return(sum(count.vec*val.vec,na.rm = TRUE)/sum(count.vec,na.rm = TRUE))
}


Ascore.plotPolygon <- function( pos, x, lower.bd, upper.bd, sigma,
                                ylim=NULL, polygon.color="grey80",
                                sigma.color="skyblue",...){
  if(is.null(ylim)){
    ylim <- range( c(lower.bd, upper.bd), na.rm = TRUE)
  }
  plot( pos, x, type="l",  ylim=ylim, ... )
  polygon(c(rev(pos), pos), 
          c(rev(lower.bd), upper.bd), 
          col = polygon.color, border = TRUE)
  abline(h=c(-1*sigma, 1*sigma),lty=2, col=sigma.color, lwd=2)
}



side.plot <- function (...,
                       vpos = NULL, vcol = NULL, 
                       hpos = NULL, hcol = NULL, 
                       abline.lwd = 3, abline.lty = 3,
                       legend.text, legend.col, legend.pch,
                       legend.pos = "center", legend.cex = 0.7,
                       before.plot.mar = c( 4, 4, 1, 1), after.plot.mar = c( 5.1, 4.1, 4.1, 2.1) )
{
  nf <- layout(matrix(c(2,0,1,3),2,2,byrow=TRUE), widths=c(6,1), heights=c(1,6), TRUE)
  par(mar=before.plot.mar)  
  plot(...)  
  if(!is.null(vpos)) { abline(v = vpos, col = vcol, lwd = abline.lwd, lty = abline.lty) }
  if(!is.null(hpos)) { abline(h = hpos, col = hcol, lwd = abline.lwd, lty = abline.lty) }
  box("figure", col = "white")  
  
  
  # Second plot, top left  
  par(mar=c(1,1,1,1))  
  plot(0:10, 0:10, type="n", xlab="X", ylab="Y", axes=FALSE)  
  box("figure", col = "white")  
  #text(5,5,"Plot 2", col="red", cex=2)  
  
  # Third plot, bottom right.  
  par(mar=c(1,1,1,1))  
  plot(0:10, 0:10, type="n", xlab="X", ylab="Y", axes=FALSE, col="green")  
  box("figure", col="white")  
  legend(legend.pos,legend.text, col=legend.col, pch=legend.pch, cex = legend.cex)
  par(mar=after.plot.mar)  
}
