getCNVseg <- function(x, chr, pos, complete.chr, complete.pos){
  require(DNAcopy)
  y <- rep(NA, length(complete.pos))
  cna.res_My0 <- CNA(genomdat=x, chrom=chr, maploc=pos, data.type=c("logratio"))
  seg.res <- segment( cna.res_My0, verbose=0, min.width = 5)
  seg.out <- seg.res$output
  
 
  
  for(smpl.k in 1:nrow(seg.out))
  {
    tmp.chr <- seg.out[smpl.k,2]
    tmp.start <- seg.out[smpl.k,3]
    tmp.stop <- seg.out[smpl.k,4]
    tmp.range.idx <- which( complete.chr == tmp.chr & 
                              complete.pos >= tmp.start &
                              complete.pos <= tmp.stop )
    y[tmp.range.idx] <- seg.out[smpl.k, 6]
  }
  return(y)
}
