/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Doubles {
    private Doubles() {
    }

    public static int hashCode(double value) {
        return Double.valueOf(value).hashCode();
    }

    public static int compare(double a, double b) {
        return Double.compare(a, b);
    }

    public static boolean contains(double[] array, double target) {
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            if (value == target) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int indexOf(double[] array, double target) {
        return Doubles.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(double[] array, double target, int start, int end) {
        int i = start;
        while (i < end) {
            if (array[i] == target) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        int i = 0;
        while (i < array.length - target.length + 1) {
            block4: {
                int j = 0;
                while (j < target.length) {
                    if (array[i + j] == target[j]) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double target) {
        return Doubles.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(double[] array, double target, int start, int end) {
        int i = end - 1;
        while (i >= start) {
            if (array[i] == target) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static double min(double ... array) {
        Preconditions.checkArgument(array.length > 0);
        double min = array[0];
        int i = 1;
        while (i < array.length) {
            min = Math.min(min, array[i]);
            ++i;
        }
        return min;
    }

    public static double max(double ... array) {
        Preconditions.checkArgument(array.length > 0);
        double max = array[0];
        int i = 1;
        while (i < array.length) {
            max = Math.max(max, array[i]);
            ++i;
        }
        return max;
    }

    public static double[] concat(double[] ... arrays) {
        int length = 0;
        double[][] dArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            double[] array = dArray[n2];
            length += array.length;
            ++n2;
        }
        double[] result = new double[length];
        int pos = 0;
        double[][] dArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            double[] array = dArray2[n4];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
            ++n4;
        }
        return result;
    }

    public static double[] ensureCapacity(double[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength ? Doubles.copyOf(array, minLength + padding) : array;
    }

    private static double[] copyOf(double[] original, int length) {
        double[] copy = new double[length];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, length));
        return copy;
    }

    public static String join(String separator, double ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 12);
        builder.append(array[0]);
        int i = 1;
        while (i < array.length) {
            builder.append(separator).append(array[i]);
            ++i;
        }
        return builder.toString();
    }

    public static Comparator<double[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static double[] toArray(Collection<Double> collection) {
        if (collection instanceof DoubleArrayAsList) {
            return ((DoubleArrayAsList)collection).toDoubleArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        double[] array = new double[len];
        int i = 0;
        while (i < len) {
            array[i] = (Double)boxedArray[i];
            ++i;
        }
        return array;
    }

    public static List<Double> asList(double ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new DoubleArrayAsList(backingArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtCompatible
    private static class DoubleArrayAsList
    extends AbstractList<Double>
    implements RandomAccess,
    Serializable {
        final double[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        DoubleArrayAsList(double[] array) {
            this(array, 0, array.length);
        }

        DoubleArrayAsList(double[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Double get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Double && Doubles.indexOf(this.array, (Double)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Double && (i = Doubles.indexOf(this.array, (Double)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Double && (i = Doubles.lastIndexOf(this.array, (Double)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public Double set(int index, Double element) {
            Preconditions.checkElementIndex(index, this.size());
            double oldValue = this.array[this.start + index];
            this.array[this.start + index] = element;
            return oldValue;
        }

        @Override
        public List<Double> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new DoubleArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DoubleArrayAsList) {
                DoubleArrayAsList that = (DoubleArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                int i = 0;
                while (i < size) {
                    if (this.array[this.start + i] != that.array[that.start + i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result = 1;
            int i = this.start;
            while (i < this.end) {
                result = 31 * result + Doubles.hashCode(this.array[i]);
                ++i;
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 12);
            builder.append('[').append(this.array[this.start]);
            int i = this.start + 1;
            while (i < this.end) {
                builder.append(", ").append(this.array[i]);
                ++i;
            }
            return builder.append(']').toString();
        }

        double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            System.arraycopy(this.array, this.start, result, 0, size);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LexicographicalComparator implements Comparator<double[]>
    {
        INSTANCE;


        @Override
        public int compare(double[] left, double[] right) {
            int minLength = Math.min(left.length, right.length);
            int i = 0;
            while (i < minLength) {
                int result = Doubles.compare(left[i], right[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return left.length - right.length;
        }
    }
}

