/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.AbstractMapEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

final class CustomConcurrentHashMap {
    private CustomConcurrentHashMap() {
    }

    private static int rehash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Builder {
        private static final int DEFAULT_INITIAL_CAPACITY = 16;
        private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        private static final int UNSET_INITIAL_CAPACITY = -1;
        private static final int UNSET_CONCURRENCY_LEVEL = -1;
        int initialCapacity = -1;
        int concurrencyLevel = -1;

        Builder() {
        }

        public Builder initialCapacity(int initialCapacity) {
            if (this.initialCapacity != -1) {
                throw new IllegalStateException("initial capacity was already set to " + this.initialCapacity);
            }
            if (initialCapacity < 0) {
                throw new IllegalArgumentException();
            }
            this.initialCapacity = initialCapacity;
            return this;
        }

        public Builder concurrencyLevel(int concurrencyLevel) {
            if (this.concurrencyLevel != -1) {
                throw new IllegalStateException("concurrency level was already set to " + this.concurrencyLevel);
            }
            if (concurrencyLevel <= 0) {
                throw new IllegalArgumentException();
            }
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public <K, V, E> ConcurrentMap<K, V> buildMap(Strategy<K, V, E> strategy) {
            if (strategy == null) {
                throw new NullPointerException("strategy");
            }
            return new Impl<K, V, E>(strategy, this);
        }

        public <K, V, E> ConcurrentMap<K, V> buildComputingMap(ComputingStrategy<K, V, E> strategy, Function<? super K, ? extends V> computer) {
            if (strategy == null) {
                throw new NullPointerException("strategy");
            }
            if (computer == null) {
                throw new NullPointerException("computer");
            }
            return new ComputingImpl<K, V, E>(strategy, this, computer);
        }

        int getInitialCapacity() {
            return this.initialCapacity == -1 ? 16 : this.initialCapacity;
        }

        int getConcurrencyLevel() {
            return this.concurrencyLevel == -1 ? 16 : this.concurrencyLevel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComputingImpl<K, V, E>
    extends Impl<K, V, E> {
        static final long serialVersionUID = 0L;
        final ComputingStrategy<K, V, E> computingStrategy;
        final Function<? super K, ? extends V> computer;

        ComputingImpl(ComputingStrategy<K, V, E> strategy, Builder builder, Function<? super K, ? extends V> computer) {
            super(strategy, builder);
            this.computingStrategy = strategy;
            this.computer = computer;
        }

        @Override
        public V get(Object k) {
            Object key = k;
            if (key == null) {
                throw new NullPointerException("key");
            }
            int hash = this.hash(key);
            Impl.Segment segment = this.segmentFor(hash);
            block12: while (true) {
                Object entry;
                if ((entry = segment.getEntry(key, hash)) == null) {
                    boolean created = false;
                    segment.lock();
                    try {
                        entry = segment.getEntry(key, hash);
                        if (entry == null) {
                            created = true;
                            int count = segment.count;
                            if (count++ > segment.threshold) {
                                segment.expand();
                            }
                            AtomicReferenceArray table = segment.table;
                            int index = hash & table.length() - 1;
                            Object first = table.get(index);
                            ++segment.modCount;
                            entry = this.computingStrategy.newEntry(key, hash, first);
                            table.set(index, entry);
                            segment.count = count;
                        }
                    }
                    finally {
                        segment.unlock();
                    }
                    if (created) {
                        boolean success = false;
                        try {
                            V value = this.computingStrategy.compute((K)key, entry, this.computer);
                            if (value == null) {
                                throw new NullPointerException("compute() returned null unexpectedly");
                            }
                            success = true;
                            V v = value;
                            return v;
                        }
                        finally {
                            if (!success) {
                                segment.removeEntry(entry, hash);
                            }
                        }
                    }
                }
                boolean interrupted = false;
                while (true) {
                    try {
                        V value = this.computingStrategy.waitForValue(entry);
                        if (value == null) {
                            segment.removeEntry(entry, hash);
                            continue block12;
                        }
                        V v = value;
                        return v;
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ComputingStrategy<K, V, E>
    extends Strategy<K, V, E> {
        public V compute(K var1, E var2, Function<? super K, ? extends V> var3);

        public V waitForValue(E var1) throws InterruptedException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Impl<K, V, E>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V>,
    Serializable {
        static final int MAXIMUM_CAPACITY = 0x40000000;
        static final int MAX_SEGMENTS = 65536;
        static final int RETRIES_BEFORE_LOCK = 2;
        final Strategy<K, V, E> strategy;
        final int segmentMask;
        final int segmentShift;
        final Segment[] segments;
        Set<K> keySet;
        Collection<V> values;
        Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = 1L;

        Impl(Strategy<K, V, E> strategy, Builder builder) {
            int segmentCapacity;
            int concurrencyLevel = builder.getConcurrencyLevel();
            int initialCapacity = builder.getInitialCapacity();
            if (concurrencyLevel > 65536) {
                concurrencyLevel = 65536;
            }
            int segmentShift = 0;
            int segmentCount = 1;
            while (segmentCount < concurrencyLevel) {
                ++segmentShift;
                segmentCount <<= 1;
            }
            this.segmentShift = 32 - segmentShift;
            this.segmentMask = segmentCount - 1;
            this.segments = this.newSegmentArray(segmentCount);
            if (initialCapacity > 0x40000000) {
                initialCapacity = 0x40000000;
            }
            if ((segmentCapacity = initialCapacity / segmentCount) * segmentCount < initialCapacity) {
                ++segmentCapacity;
            }
            int segmentSize = 1;
            while (segmentSize < segmentCapacity) {
                segmentSize <<= 1;
            }
            int i = 0;
            while (i < this.segments.length) {
                this.segments[i] = new Segment(segmentSize);
                ++i;
            }
            this.strategy = strategy;
            strategy.setInternals(new InternalsImpl());
        }

        int hash(Object key) {
            int h = this.strategy.hashKey(key);
            return CustomConcurrentHashMap.rehash(h);
        }

        Segment[] newSegmentArray(int ssize) {
            return (Segment[])Array.newInstance(Segment.class, ssize);
        }

        Segment segmentFor(int hash) {
            return this.segments[hash >>> this.segmentShift & this.segmentMask];
        }

        @Override
        public boolean isEmpty() {
            Segment[] segments = this.segments;
            int[] mc = new int[segments.length];
            int mcsum = 0;
            int i = 0;
            while (i < segments.length) {
                if (segments[i].count != 0) {
                    return false;
                }
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                ++i;
            }
            if (mcsum != 0) {
                i = 0;
                while (i < segments.length) {
                    if (segments[i].count != 0 || mc[i] != segments[i].modCount) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        @Override
        public int size() {
            Segment[] segments = this.segments;
            long sum = 0L;
            long check = 0L;
            int[] mc = new int[segments.length];
            int k = 0;
            while (k < 2) {
                check = 0L;
                sum = 0L;
                int mcsum = 0;
                int i = 0;
                while (i < segments.length) {
                    sum += (long)segments[i].count;
                    mc[i] = segments[i].modCount;
                    mcsum += mc[i];
                    ++i;
                }
                if (mcsum != 0) {
                    i = 0;
                    while (i < segments.length) {
                        check += (long)segments[i].count;
                        if (mc[i] != segments[i].modCount) {
                            check = -1L;
                            break;
                        }
                        ++i;
                    }
                }
                if (check == sum) break;
                ++k;
            }
            if (check != sum) {
                sum = 0L;
                Segment[] segmentArray = segments;
                int n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    Segment segment = segmentArray[n2];
                    segment.lock();
                    ++n2;
                }
                segmentArray = segments;
                n = segments.length;
                n2 = 0;
                while (n2 < n) {
                    Segment segment = segmentArray[n2];
                    sum += (long)segment.count;
                    ++n2;
                }
                segmentArray = segments;
                n = segments.length;
                n2 = 0;
                while (n2 < n) {
                    Segment segment = segmentArray[n2];
                    segment.unlock();
                    ++n2;
                }
            }
            if (sum > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)sum;
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            int hash = this.hash(key);
            return this.segmentFor(hash).get(key, hash);
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            int hash = this.hash(key);
            return this.segmentFor(hash).containsKey(key, hash);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            segments = this.segments;
            mc = new int[segments.length];
            k = 0;
            while (k < 2) {
                mcsum = 0;
                i = 0;
                while (i < segments.length) {
                    segments[i].count;
                    mc[i] = segments[i].modCount;
                    mcsum += mc[i];
                    if (segments[i].containsValue(value)) {
                        return true;
                    }
                    ++i;
                }
                cleanSweep = true;
                if (mcsum != 0) {
                    i = 0;
                    while (i < segments.length) {
                        segments[i].count;
                        if (mc[i] != segments[i].modCount) {
                            cleanSweep = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (cleanSweep) {
                    return false;
                }
                ++k;
            }
            var7_12 = segments;
            var6_10 = segments.length;
            mcsum = 0;
            while (mcsum < var6_10) {
                segment = var7_12[mcsum];
                segment.lock();
                ++mcsum;
            }
            found = false;
            try {
                var8_14 = segments;
                var7_13 = segments.length;
                var6_10 = 0;
                while (var6_10 < var7_13) {
                    segment = var8_14[var6_10];
                    if (segment.containsValue(value)) {
                        found = true;
                    }
                    ++var6_10;
                }
            }
            finally {
                var13_17 = segments;
                var12_19 = segments.length;
                var11_21 = 0;
                ** while (var11_21 < var12_19)
            }
lbl-1000:
            // 1 sources

            {
                segment = var13_17[var11_21];
                segment.unlock();
                ++var11_21;
                continue;
            }
lbl63:
            // 1 sources

            return found;
        }

        @Override
        public V put(K key, V value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            int hash = this.hash(key);
            return this.segmentFor(hash).put(key, hash, value, false);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            int hash = this.hash(key);
            return this.segmentFor(hash).put(key, hash, value, true);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public V remove(Object key) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            int hash = this.hash(key);
            return this.segmentFor(hash).remove(key, hash);
        }

        @Override
        public boolean remove(Object key, Object value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            int hash = this.hash(key);
            return this.segmentFor(hash).remove(key, hash, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (oldValue == null) {
                throw new NullPointerException("oldValue");
            }
            if (newValue == null) {
                throw new NullPointerException("newValue");
            }
            int hash = this.hash(key);
            return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            int hash = this.hash(key);
            return this.segmentFor(hash).replace(key, hash, value);
        }

        @Override
        public void clear() {
            Segment[] segmentArray = this.segments;
            int n = this.segments.length;
            int n2 = 0;
            while (n2 < n) {
                Segment segment = segmentArray[n2];
                segment.clear();
                ++n2;
            }
        }

        @Override
        public Set<K> keySet() {
            KeySet ks = this.keySet;
            return ks != null ? ks : (this.keySet = new KeySet());
        }

        @Override
        public Collection<V> values() {
            Values vs = this.values;
            return vs != null ? vs : (this.values = new Values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            EntrySet es = this.entrySet;
            return es != null ? es : (this.entrySet = new EntrySet());
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(this.size());
            out.writeInt(this.segments.length);
            out.writeObject(this.strategy);
            for (Map.Entry<K, V> entry : this.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
            out.writeObject(null);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                Object key;
                int segmentCapacity;
                int initialCapacity = in.readInt();
                int concurrencyLevel = in.readInt();
                Strategy strategy = (Strategy)in.readObject();
                if (concurrencyLevel > 65536) {
                    concurrencyLevel = 65536;
                }
                int segmentShift = 0;
                int segmentCount = 1;
                while (segmentCount < concurrencyLevel) {
                    ++segmentShift;
                    segmentCount <<= 1;
                }
                Fields.segmentShift.set(this, 32 - segmentShift);
                Fields.segmentMask.set(this, segmentCount - 1);
                Fields.segments.set(this, this.newSegmentArray(segmentCount));
                if (initialCapacity > 0x40000000) {
                    initialCapacity = 0x40000000;
                }
                if ((segmentCapacity = initialCapacity / segmentCount) * segmentCount < initialCapacity) {
                    ++segmentCapacity;
                }
                int segmentSize = 1;
                while (segmentSize < segmentCapacity) {
                    segmentSize <<= 1;
                }
                int i = 0;
                while (i < this.segments.length) {
                    this.segments[i] = new Segment(segmentSize);
                    ++i;
                }
                Fields.strategy.set(this, strategy);
                while ((key = in.readObject()) != null) {
                    Object value = in.readObject();
                    this.put(key, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class EntryIterator
        extends HashIterator
        implements Iterator<Map.Entry<K, V>> {
            EntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                if (key == null) {
                    return false;
                }
                Object v = Impl.this.get(key);
                return v != null && Impl.this.strategy.equalValues(v, e.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                return key != null && Impl.this.remove(key, e.getValue());
            }

            @Override
            public int size() {
                return Impl.this.size();
            }

            @Override
            public boolean isEmpty() {
                return Impl.this.isEmpty();
            }

            @Override
            public void clear() {
                Impl.this.clear();
            }
        }

        static class Fields {
            static final Field segmentShift = Fields.findField("segmentShift");
            static final Field segmentMask = Fields.findField("segmentMask");
            static final Field segments = Fields.findField("segments");
            static final Field strategy = Fields.findField("strategy");

            Fields() {
            }

            static Field findField(String name) {
                try {
                    Field f = Impl.class.getDeclaredField(name);
                    f.setAccessible(true);
                    return f;
                }
                catch (NoSuchFieldException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        abstract class HashIterator {
            int nextSegmentIndex;
            int nextTableIndex;
            AtomicReferenceArray<E> currentTable;
            E nextEntry;
            WriteThroughEntry nextExternal;
            WriteThroughEntry lastReturned;

            HashIterator() {
                this.nextSegmentIndex = Impl.this.segments.length - 1;
                this.nextTableIndex = -1;
                this.advance();
            }

            public boolean hasMoreElements() {
                return this.hasNext();
            }

            /*
             * Unable to fully structure code
             */
            final void advance() {
                this.nextExternal = null;
                if (this.nextInChain()) {
                    return;
                }
                if (!this.nextInTable()) ** GOTO lbl12
                return;
lbl-1000:
                // 1 sources

                {
                    seg = Impl.this.segments[this.nextSegmentIndex--];
                    if (seg.count == 0) continue;
                    this.currentTable = seg.table;
                    this.nextTableIndex = this.currentTable.length() - 1;
                    if (!this.nextInTable()) continue;
                    return;
lbl12:
                    // 3 sources

                    ** while (this.nextSegmentIndex >= 0)
                }
lbl13:
                // 1 sources

            }

            boolean nextInChain() {
                Strategy s = Impl.this.strategy;
                if (this.nextEntry != null) {
                    this.nextEntry = s.getNext(this.nextEntry);
                    while (this.nextEntry != null) {
                        if (this.advanceTo(this.nextEntry)) {
                            return true;
                        }
                        this.nextEntry = s.getNext(this.nextEntry);
                    }
                }
                return false;
            }

            boolean nextInTable() {
                while (this.nextTableIndex >= 0) {
                    if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                    return true;
                }
                return false;
            }

            boolean advanceTo(E entry) {
                Strategy s = Impl.this.strategy;
                Object key = s.getKey(entry);
                Object value = s.getValue(entry);
                if (key != null && value != null) {
                    this.nextExternal = new WriteThroughEntry(key, value);
                    return true;
                }
                return false;
            }

            public boolean hasNext() {
                return this.nextExternal != null;
            }

            WriteThroughEntry nextEntry() {
                if (this.nextExternal == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextExternal;
                this.advance();
                return this.lastReturned;
            }

            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                Impl.this.remove(this.lastReturned.getKey());
                this.lastReturned = null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternalsImpl
        implements Internals<K, V, E>,
        Serializable {
            static final long serialVersionUID = 0L;

            InternalsImpl() {
            }

            @Override
            public E getEntry(K key) {
                if (key == null) {
                    throw new NullPointerException("key");
                }
                int hash = Impl.this.hash(key);
                return Impl.this.segmentFor(hash).getEntry(key, hash);
            }

            @Override
            public boolean removeEntry(E entry, V value) {
                if (entry == null) {
                    throw new NullPointerException("entry");
                }
                int hash = Impl.this.strategy.getHash(entry);
                return Impl.this.segmentFor(hash).removeEntry(entry, hash, value);
            }

            @Override
            public boolean removeEntry(E entry) {
                if (entry == null) {
                    throw new NullPointerException("entry");
                }
                int hash = Impl.this.strategy.getHash(entry);
                return Impl.this.segmentFor(hash).removeEntry(entry, hash);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class KeyIterator
        extends HashIterator
        implements Iterator<K> {
            KeyIterator() {
            }

            @Override
            public K next() {
                return super.nextEntry().getKey();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class KeySet
        extends AbstractSet<K> {
            KeySet() {
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return Impl.this.size();
            }

            @Override
            public boolean isEmpty() {
                return Impl.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return Impl.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                return Impl.this.remove(o) != null;
            }

            @Override
            public void clear() {
                Impl.this.clear();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Segment
        extends ReentrantLock {
            volatile int count;
            int modCount;
            int threshold;
            volatile AtomicReferenceArray<E> table;

            Segment(int initialCapacity) {
                this.setTable(this.newEntryArray(initialCapacity));
            }

            AtomicReferenceArray<E> newEntryArray(int size) {
                return new AtomicReferenceArray(size);
            }

            void setTable(AtomicReferenceArray<E> newTable) {
                this.threshold = newTable.length() * 3 / 4;
                this.table = newTable;
            }

            E getFirst(int hash) {
                AtomicReferenceArray table = this.table;
                return table.get(hash & table.length() - 1);
            }

            public E getEntry(Object key, int hash) {
                Strategy s = Impl.this.strategy;
                if (this.count != 0) {
                    Object e = this.getFirst(hash);
                    while (e != null) {
                        Object entryKey;
                        if (s.getHash(e) == hash && (entryKey = s.getKey(e)) != null && s.equalKeys(entryKey, key)) {
                            return e;
                        }
                        e = s.getNext(e);
                    }
                }
                return null;
            }

            V get(Object key, int hash) {
                Object entry = this.getEntry(key, hash);
                if (entry == null) {
                    return null;
                }
                return Impl.this.strategy.getValue(entry);
            }

            boolean containsKey(Object key, int hash) {
                Strategy s = Impl.this.strategy;
                if (this.count != 0) {
                    Object e = this.getFirst(hash);
                    while (e != null) {
                        Object entryKey;
                        if (s.getHash(e) == hash && (entryKey = s.getKey(e)) != null && s.equalKeys(entryKey, key)) {
                            return s.getValue(e) != null;
                        }
                        e = s.getNext(e);
                    }
                }
                return false;
            }

            boolean containsValue(Object value) {
                Strategy s = Impl.this.strategy;
                if (this.count != 0) {
                    AtomicReferenceArray table = this.table;
                    int length = table.length();
                    int i = 0;
                    while (i < length) {
                        Object e = table.get(i);
                        while (e != null) {
                            Object entryValue = s.getValue(e);
                            if (entryValue != null && s.equalValues(entryValue, value)) {
                                return true;
                            }
                            e = s.getNext(e);
                        }
                        ++i;
                    }
                }
                return false;
            }

            boolean replace(K key, int hash, V oldValue, V newValue) {
                Strategy s = Impl.this.strategy;
                this.lock();
                try {
                    Object e = this.getFirst(hash);
                    while (e != null) {
                        Object entryKey = s.getKey(e);
                        if (s.getHash(e) == hash && entryKey != null && s.equalKeys(key, entryKey)) {
                            Object entryValue = s.getValue(e);
                            if (entryValue == null) {
                                return false;
                            }
                            if (s.equalValues(entryValue, oldValue)) {
                                s.setValue(e, newValue);
                                return true;
                            }
                        }
                        e = s.getNext(e);
                    }
                    return false;
                }
                finally {
                    this.unlock();
                }
            }

            V replace(K key, int hash, V newValue) {
                Strategy s = Impl.this.strategy;
                this.lock();
                try {
                    Object e = this.getFirst(hash);
                    while (e != null) {
                        Object entryKey = s.getKey(e);
                        if (s.getHash(e) == hash && entryKey != null && s.equalKeys(key, entryKey)) {
                            Object entryValue = s.getValue(e);
                            if (entryValue == null) {
                                return null;
                            }
                            s.setValue(e, newValue);
                            Object v = entryValue;
                            return v;
                        }
                        e = s.getNext(e);
                    }
                    return null;
                }
                finally {
                    this.unlock();
                }
            }

            V put(K key, int hash, V value, boolean onlyIfAbsent) {
                Strategy s = Impl.this.strategy;
                this.lock();
                try {
                    Object first;
                    int count = this.count;
                    if (count++ > this.threshold) {
                        this.expand();
                    }
                    AtomicReferenceArray table = this.table;
                    int index = hash & table.length() - 1;
                    Object e = first = table.get(index);
                    while (e != null) {
                        Object entryKey = s.getKey(e);
                        if (s.getHash(e) == hash && entryKey != null && s.equalKeys(key, entryKey)) {
                            Object entryValue = s.getValue(e);
                            if (onlyIfAbsent && entryValue != null) {
                                Object v = entryValue;
                                return v;
                            }
                            s.setValue(e, value);
                            Object v = entryValue;
                            return v;
                        }
                        e = s.getNext(e);
                    }
                    ++this.modCount;
                    Object newEntry = s.newEntry(key, hash, first);
                    s.setValue(newEntry, value);
                    table.set(index, newEntry);
                    this.count = count;
                    return null;
                }
                finally {
                    this.unlock();
                }
            }

            void expand() {
                AtomicReferenceArray oldTable = this.table;
                int oldCapacity = oldTable.length();
                if (oldCapacity >= 0x40000000) {
                    return;
                }
                Strategy s = Impl.this.strategy;
                AtomicReferenceArray newTable = this.newEntryArray(oldCapacity << 1);
                this.threshold = newTable.length() * 3 / 4;
                int newMask = newTable.length() - 1;
                int oldIndex = 0;
                while (oldIndex < oldCapacity) {
                    Object head = oldTable.get(oldIndex);
                    if (head != null) {
                        Object next = s.getNext(head);
                        int headIndex = s.getHash(head) & newMask;
                        if (next == null) {
                            newTable.set(headIndex, head);
                        } else {
                            Object tail = head;
                            int tailIndex = headIndex;
                            Object last = next;
                            while (last != null) {
                                int newIndex = s.getHash(last) & newMask;
                                if (newIndex != tailIndex) {
                                    tailIndex = newIndex;
                                    tail = last;
                                }
                                last = s.getNext(last);
                            }
                            newTable.set(tailIndex, tail);
                            Object e = head;
                            while (e != tail) {
                                Object key = s.getKey(e);
                                if (key != null) {
                                    int newIndex = s.getHash(e) & newMask;
                                    Object newNext = newTable.get(newIndex);
                                    newTable.set(newIndex, s.copyEntry(key, e, newNext));
                                }
                                e = s.getNext(e);
                            }
                        }
                    }
                    ++oldIndex;
                }
                this.table = newTable;
            }

            V remove(Object key, int hash) {
                Strategy s = Impl.this.strategy;
                this.lock();
                try {
                    Object first;
                    int count = this.count - 1;
                    AtomicReferenceArray table = this.table;
                    int index = hash & table.length() - 1;
                    Object e = first = table.get(index);
                    while (e != null) {
                        Object entryKey = s.getKey(e);
                        if (s.getHash(e) == hash && entryKey != null && s.equalKeys(entryKey, key)) {
                            Object entryValue = Impl.this.strategy.getValue(e);
                            ++this.modCount;
                            Object newFirst = s.getNext(e);
                            Object p = first;
                            while (p != e) {
                                Object pKey = s.getKey(p);
                                if (pKey != null) {
                                    newFirst = s.copyEntry(pKey, p, newFirst);
                                }
                                p = s.getNext(p);
                            }
                            table.set(index, newFirst);
                            this.count = count;
                            Object v = entryValue;
                            return v;
                        }
                        e = s.getNext(e);
                    }
                    return null;
                }
                finally {
                    this.unlock();
                }
            }

            boolean remove(Object key, int hash, Object value) {
                Strategy s = Impl.this.strategy;
                this.lock();
                try {
                    Object first;
                    int count = this.count - 1;
                    AtomicReferenceArray table = this.table;
                    int index = hash & table.length() - 1;
                    Object e = first = table.get(index);
                    while (e != null) {
                        Object entryKey = s.getKey(e);
                        if (s.getHash(e) == hash && entryKey != null && s.equalKeys(entryKey, key)) {
                            Object entryValue = Impl.this.strategy.getValue(e);
                            if (value == entryValue || value != null && entryValue != null && s.equalValues(entryValue, value)) {
                                ++this.modCount;
                                Object newFirst = s.getNext(e);
                                Object p = first;
                                while (p != e) {
                                    Object pKey = s.getKey(p);
                                    if (pKey != null) {
                                        newFirst = s.copyEntry(pKey, p, newFirst);
                                    }
                                    p = s.getNext(p);
                                }
                                table.set(index, newFirst);
                                this.count = count;
                                return true;
                            }
                            return false;
                        }
                        e = s.getNext(e);
                    }
                    return false;
                }
                finally {
                    this.unlock();
                }
            }

            public boolean removeEntry(E entry, int hash, V value) {
                Strategy s = Impl.this.strategy;
                this.lock();
                try {
                    Object first;
                    int count = this.count - 1;
                    AtomicReferenceArray table = this.table;
                    int index = hash & table.length() - 1;
                    Object e = first = table.get(index);
                    while (e != null) {
                        if (s.getHash(e) == hash && entry.equals(e)) {
                            Object entryValue = s.getValue(e);
                            if (entryValue == value || value != null && s.equalValues(entryValue, value)) {
                                ++this.modCount;
                                Object newFirst = s.getNext(e);
                                Object p = first;
                                while (p != e) {
                                    Object pKey = s.getKey(p);
                                    if (pKey != null) {
                                        newFirst = s.copyEntry(pKey, p, newFirst);
                                    }
                                    p = s.getNext(p);
                                }
                                table.set(index, newFirst);
                                this.count = count;
                                return true;
                            }
                            return false;
                        }
                        e = s.getNext(e);
                    }
                    return false;
                }
                finally {
                    this.unlock();
                }
            }

            public boolean removeEntry(E entry, int hash) {
                Strategy s = Impl.this.strategy;
                this.lock();
                try {
                    Object first;
                    int count = this.count - 1;
                    AtomicReferenceArray table = this.table;
                    int index = hash & table.length() - 1;
                    Object e = first = table.get(index);
                    while (e != null) {
                        if (s.getHash(e) == hash && entry.equals(e)) {
                            ++this.modCount;
                            Object newFirst = s.getNext(e);
                            Object p = first;
                            while (p != e) {
                                Object pKey = s.getKey(p);
                                if (pKey != null) {
                                    newFirst = s.copyEntry(pKey, p, newFirst);
                                }
                                p = s.getNext(p);
                            }
                            table.set(index, newFirst);
                            this.count = count;
                            return true;
                        }
                        e = s.getNext(e);
                    }
                    return false;
                }
                finally {
                    this.unlock();
                }
            }

            void clear() {
                if (this.count != 0) {
                    this.lock();
                    try {
                        AtomicReferenceArray table = this.table;
                        int i = 0;
                        while (i < table.length()) {
                            table.set(i, null);
                            ++i;
                        }
                        ++this.modCount;
                        this.count = 0;
                    }
                    finally {
                        this.unlock();
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class ValueIterator
        extends HashIterator
        implements Iterator<V> {
            ValueIterator() {
            }

            @Override
            public V next() {
                return super.nextEntry().getValue();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Values
        extends AbstractCollection<V> {
            Values() {
            }

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return Impl.this.size();
            }

            @Override
            public boolean isEmpty() {
                return Impl.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return Impl.this.containsValue(o);
            }

            @Override
            public void clear() {
                Impl.this.clear();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class WriteThroughEntry
        extends AbstractMapEntry<K, V> {
            final K key;
            V value;

            WriteThroughEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Object oldValue = Impl.this.put(this.getKey(), value);
                this.value = value;
                return oldValue;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Internals<K, V, E> {
        public E getEntry(K var1);

        public boolean removeEntry(E var1, @Nullable V var2);

        public boolean removeEntry(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleInternalEntry<K, V> {
        final K key;
        final int hash;
        final SimpleInternalEntry<K, V> next;
        volatile V value;

        SimpleInternalEntry(K key, int hash, @Nullable V value, SimpleInternalEntry<K, V> next) {
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.next = next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleStrategy<K, V>
    implements Strategy<K, V, SimpleInternalEntry<K, V>> {
        SimpleStrategy() {
        }

        @Override
        public SimpleInternalEntry<K, V> newEntry(K key, int hash, SimpleInternalEntry<K, V> next) {
            return new SimpleInternalEntry<K, Object>(key, hash, null, next);
        }

        @Override
        public SimpleInternalEntry<K, V> copyEntry(K key, SimpleInternalEntry<K, V> original, SimpleInternalEntry<K, V> next) {
            return new SimpleInternalEntry(key, original.hash, original.value, next);
        }

        @Override
        public void setValue(SimpleInternalEntry<K, V> entry, V value) {
            entry.value = value;
        }

        @Override
        public V getValue(SimpleInternalEntry<K, V> entry) {
            return entry.value;
        }

        @Override
        public boolean equalKeys(K a, Object b) {
            return a.equals(b);
        }

        @Override
        public boolean equalValues(V a, Object b) {
            return a.equals(b);
        }

        @Override
        public int hashKey(Object key) {
            return key.hashCode();
        }

        @Override
        public K getKey(SimpleInternalEntry<K, V> entry) {
            return entry.key;
        }

        @Override
        public SimpleInternalEntry<K, V> getNext(SimpleInternalEntry<K, V> entry) {
            return entry.next;
        }

        @Override
        public int getHash(SimpleInternalEntry<K, V> entry) {
            return entry.hash;
        }

        @Override
        public void setInternals(Internals<K, V, SimpleInternalEntry<K, V>> internals) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Strategy<K, V, E> {
        public E newEntry(K var1, int var2, E var3);

        public E copyEntry(K var1, E var2, E var3);

        public void setValue(E var1, V var2);

        public V getValue(E var1);

        public boolean equalKeys(K var1, Object var2);

        public boolean equalValues(V var1, Object var2);

        public int hashKey(Object var1);

        public K getKey(E var1);

        public E getNext(E var1);

        public int getHash(E var1);

        public void setInternals(Internals<K, V, E> var1);
    }
}

