/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToStringHelper {
        private final List<String> fieldString = new ArrayList<String>();
        private final Object instance;
        private static final Joiner JOINER = Joiner.on(", ");

        private ToStringHelper(Object instance) {
            this.instance = Preconditions.checkNotNull(instance);
        }

        public ToStringHelper add(String name, @Nullable Object value) {
            return this.addValue(String.valueOf(Preconditions.checkNotNull(name)) + "=" + value);
        }

        public ToStringHelper addValue(@Nullable Object value) {
            this.fieldString.add(String.valueOf(value));
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(100).append(ToStringHelper.simpleName(this.instance.getClass())).append('{');
            return JOINER.appendTo(builder, (Iterable<?>)this.fieldString).append('}').toString();
        }

        @VisibleForTesting
        static String simpleName(Class<?> clazz) {
            String name = clazz.getName();
            int start = name.lastIndexOf(36);
            if (start == -1) {
                start = name.lastIndexOf(46);
            }
            return name.substring(start + 1);
        }
    }
}

