/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public abstract class CharMatcher
implements Predicate<Character> {
    private static final String BREAKING_WHITESPACE_CHARS = "\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000";
    private static final String NON_BREAKING_WHITESPACE_CHARS = "\u00a0\u180e\u202f";
    public static final CharMatcher WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000\u00a0\u180e\u202f").or(CharMatcher.inRange('\u2000', '\u200a'));
    public static final CharMatcher BREAKING_WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000").or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200a'));
    public static final CharMatcher ASCII = CharMatcher.inRange('\u0000', '\u007f');
    public static final CharMatcher DIGIT;
    public static final CharMatcher JAVA_WHITESPACE;
    public static final CharMatcher JAVA_DIGIT;
    public static final CharMatcher JAVA_LETTER;
    public static final CharMatcher JAVA_LETTER_OR_DIGIT;
    public static final CharMatcher JAVA_UPPER_CASE;
    public static final CharMatcher JAVA_LOWER_CASE;
    public static final CharMatcher JAVA_ISO_CONTROL;
    public static final CharMatcher INVISIBLE;
    public static final CharMatcher SINGLE_WIDTH;
    public static final CharMatcher ANY;
    public static final CharMatcher NONE;

    static {
        CharMatcher digit = CharMatcher.inRange('0', '9');
        String zeroes = "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
        char[] cArray = zeroes.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char base = cArray[n2];
            digit = digit.or(CharMatcher.inRange(base, (char)(base + 9)));
            ++n2;
        }
        DIGIT = digit;
        JAVA_WHITESPACE = CharMatcher.inRange('\t', '\r').or(CharMatcher.inRange('\u001c', ' ')).or(CharMatcher.is('\u1680')).or(CharMatcher.is('\u180e')).or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200b')).or(CharMatcher.inRange('\u2028', '\u2029')).or(CharMatcher.is('\u205f')).or(CharMatcher.is('\u3000'));
        JAVA_DIGIT = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isDigit(c);
            }
        };
        JAVA_LETTER = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isLetter(c);
            }
        };
        JAVA_LETTER_OR_DIGIT = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isLetterOrDigit(c);
            }
        };
        JAVA_UPPER_CASE = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isUpperCase(c);
            }
        };
        JAVA_LOWER_CASE = new CharMatcher(){

            public boolean matches(char c) {
                return Character.isLowerCase(c);
            }
        };
        JAVA_ISO_CONTROL = CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f'));
        INVISIBLE = CharMatcher.inRange('\u0000', ' ').or(CharMatcher.inRange('\u007f', '\u00a0')).or(CharMatcher.is('\u00ad')).or(CharMatcher.inRange('\u0600', '\u0603')).or(CharMatcher.anyOf("\u06dd\u070f\u1680\u17b4\u17b5\u180e")).or(CharMatcher.inRange('\u2000', '\u200f')).or(CharMatcher.inRange('\u2028', '\u202f')).or(CharMatcher.inRange('\u205f', '\u2064')).or(CharMatcher.inRange('\u206a', '\u206f')).or(CharMatcher.is('\u3000')).or(CharMatcher.inRange('\ud800', '\uf8ff')).or(CharMatcher.anyOf("\ufeff\ufff9\ufffa\ufffb"));
        SINGLE_WIDTH = CharMatcher.inRange('\u0000', '\u04f9').or(CharMatcher.is('\u05be')).or(CharMatcher.inRange('\u05d0', '\u05ea')).or(CharMatcher.is('\u05f3')).or(CharMatcher.is('\u05f4')).or(CharMatcher.inRange('\u0600', '\u06ff')).or(CharMatcher.inRange('\u0750', '\u077f')).or(CharMatcher.inRange('\u0e00', '\u0e7f')).or(CharMatcher.inRange('\u1e00', '\u20af')).or(CharMatcher.inRange('\u2100', '\u213a')).or(CharMatcher.inRange('\ufb50', '\ufdff')).or(CharMatcher.inRange('\ufe70', '\ufeff')).or(CharMatcher.inRange('\uff61', '\uffdc'));
        ANY = new CharMatcher(){

            public boolean matches(char c) {
                return true;
            }

            public int indexIn(CharSequence sequence) {
                return sequence.length() == 0 ? -1 : 0;
            }

            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                return start == length ? -1 : start;
            }

            public int lastIndexIn(CharSequence sequence) {
                return sequence.length() - 1;
            }

            public boolean matchesAllOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            public boolean matchesNoneOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            public String removeFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            public String replaceFrom(CharSequence sequence, char replacement) {
                char[] array = new char[sequence.length()];
                Arrays.fill(array, replacement);
                return new String(array);
            }

            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                StringBuilder retval = new StringBuilder(sequence.length() * replacement.length());
                int i = 0;
                while (i < sequence.length()) {
                    retval.append(replacement);
                    ++i;
                }
                return retval.toString();
            }

            public String collapseFrom(CharSequence sequence, char replacement) {
                return sequence.length() == 0 ? "" : String.valueOf(replacement);
            }

            public String trimFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            public int countIn(CharSequence sequence) {
                return sequence.length();
            }

            public CharMatcher and(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            public CharMatcher or(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            public CharMatcher negate() {
                return NONE;
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
        NONE = new CharMatcher(){

            public boolean matches(char c) {
                return false;
            }

            public int indexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                return -1;
            }

            public int lastIndexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            public boolean matchesAllOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            public boolean matchesNoneOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            public String removeFrom(CharSequence sequence) {
                return sequence.toString();
            }

            public String replaceFrom(CharSequence sequence, char replacement) {
                return sequence.toString();
            }

            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                Preconditions.checkNotNull(replacement);
                return sequence.toString();
            }

            public String collapseFrom(CharSequence sequence, char replacement) {
                return sequence.toString();
            }

            public String trimFrom(CharSequence sequence) {
                return sequence.toString();
            }

            public int countIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return 0;
            }

            public CharMatcher and(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            public CharMatcher or(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            public CharMatcher negate() {
                return ANY;
            }

            protected void setBits(LookupTable table) {
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher is(final char match) {
        return new CharMatcher(){

            public boolean matches(char c) {
                return c == match;
            }

            public String replaceFrom(CharSequence sequence, char replacement) {
                return sequence.toString().replace(match, replacement);
            }

            public CharMatcher and(CharMatcher other) {
                return other.matches(match) ? this : NONE;
            }

            public CharMatcher or(CharMatcher other) {
                return other.matches(match) ? other : super.or(other);
            }

            public CharMatcher negate() {
                return 8.isNot(match);
            }

            protected void setBits(LookupTable table) {
                table.set(match);
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher isNot(final char match) {
        return new CharMatcher(){

            public boolean matches(char c) {
                return c != match;
            }

            public CharMatcher and(CharMatcher other) {
                return other.matches(match) ? super.and(other) : other;
            }

            public CharMatcher or(CharMatcher other) {
                return other.matches(match) ? ANY : this;
            }

            public CharMatcher negate() {
                return 9.is(match);
            }
        };
    }

    public static CharMatcher anyOf(CharSequence sequence) {
        switch (sequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is(sequence.charAt(0));
            }
            case 2: {
                final char match1 = sequence.charAt(0);
                final char match2 = sequence.charAt(1);
                return new CharMatcher(){

                    public boolean matches(char c) {
                        return c == match1 || c == match2;
                    }

                    protected void setBits(LookupTable table) {
                        table.set(match1);
                        table.set(match2);
                    }

                    public CharMatcher precomputed() {
                        return this;
                    }
                };
            }
        }
        final char[] chars = sequence.toString().toCharArray();
        Arrays.sort(chars);
        return new CharMatcher(){

            public boolean matches(char c) {
                return Arrays.binarySearch(chars, c) >= 0;
            }

            protected void setBits(LookupTable table) {
                char[] cArray = chars;
                int n = chars.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    table.set(c);
                    ++n2;
                }
            }
        };
    }

    public static CharMatcher noneOf(CharSequence sequence) {
        return CharMatcher.anyOf(sequence).negate();
    }

    public static CharMatcher inRange(final char startInclusive, final char endInclusive) {
        Preconditions.checkArgument(endInclusive >= startInclusive);
        return new CharMatcher(){

            public boolean matches(char c) {
                return startInclusive <= c && c <= endInclusive;
            }

            protected void setBits(LookupTable table) {
                char c;
                char c2 = startInclusive;
                do {
                    table.set(c2);
                    c = c2;
                    c2 = (char)(c + '\u0001');
                } while (c != endInclusive);
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher forPredicate(final Predicate<? super Character> predicate) {
        Preconditions.checkNotNull(predicate);
        if (predicate instanceof CharMatcher) {
            return (CharMatcher)predicate;
        }
        return new CharMatcher(){

            public boolean matches(char c) {
                return predicate.apply(Character.valueOf(c));
            }

            public boolean apply(Character character) {
                return predicate.apply(Preconditions.checkNotNull(character));
            }
        };
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        final CharMatcher original = this;
        return new CharMatcher(){

            public boolean matches(char c) {
                return !original.matches(c);
            }

            public boolean matchesAllOf(CharSequence sequence) {
                return original.matchesNoneOf(sequence);
            }

            public boolean matchesNoneOf(CharSequence sequence) {
                return original.matchesAllOf(sequence);
            }

            public int countIn(CharSequence sequence) {
                return sequence.length() - original.countIn(sequence);
            }

            public CharMatcher negate() {
                return original;
            }
        };
    }

    public CharMatcher and(CharMatcher other) {
        return new And(Arrays.asList(this, Preconditions.checkNotNull(other)));
    }

    public CharMatcher or(CharMatcher other) {
        return new Or(Arrays.asList(this, Preconditions.checkNotNull(other)));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    CharMatcher precomputedInternal() {
        final LookupTable table = new LookupTable();
        this.setBits(table);
        return new CharMatcher(){

            public boolean matches(char c) {
                return table.get(c);
            }

            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    protected void setBits(LookupTable table) {
        char c;
        char c2 = '\u0000';
        do {
            if (this.matches(c2)) {
                table.set(c2);
            }
            c = c2;
            c2 = (char)(c + '\u0001');
        } while (c != 65535);
    }

    public boolean matchesAllOf(CharSequence sequence) {
        int i = sequence.length() - 1;
        while (i >= 0) {
            if (!this.matches(sequence.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence sequence) {
        return this.indexIn(sequence) == -1;
    }

    public int indexIn(CharSequence sequence) {
        int length = sequence.length();
        int i = 0;
        while (i < length) {
            if (this.matches(sequence.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexIn(CharSequence sequence, int start) {
        int length = sequence.length();
        Preconditions.checkPositionIndex(start, length);
        int i = start;
        while (i < length) {
            if (this.matches(sequence.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence sequence) {
        int i = sequence.length() - 1;
        while (i >= 0) {
            if (this.matches(sequence.charAt(i))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int countIn(CharSequence sequence) {
        int count = 0;
        int i = 0;
        while (i < sequence.length()) {
            if (this.matches(sequence.charAt(i))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String removeFrom(CharSequence sequence) {
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        int spread = 1;
        block0: while (true) {
            ++pos;
            while (pos != chars.length) {
                if (!this.matches(chars[pos])) {
                    chars[pos - spread] = chars[pos];
                    ++pos;
                    continue;
                }
                ++spread;
                continue block0;
            }
            break;
        }
        return new String(chars, 0, pos - spread);
    }

    public String retainFrom(CharSequence sequence) {
        return this.negate().removeFrom(sequence);
    }

    public String replaceFrom(CharSequence sequence, char replacement) {
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[pos] = replacement;
        int i = pos + 1;
        while (i < chars.length) {
            if (this.matches(chars[i])) {
                chars[i] = replacement;
            }
            ++i;
        }
        return new String(chars);
    }

    public String replaceFrom(CharSequence sequence, CharSequence replacement) {
        int replacementLen = replacement.length();
        if (replacementLen == 0) {
            return this.removeFrom(sequence);
        }
        if (replacementLen == 1) {
            return this.replaceFrom(sequence, replacement.charAt(0));
        }
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        int len = string.length();
        StringBuilder buf = new StringBuilder((int)((double)len * 1.5) + 16);
        int oldpos = 0;
        do {
            buf.append(string, oldpos, pos);
            buf.append(replacement);
        } while ((pos = this.indexIn(string, oldpos = pos + 1)) != -1);
        buf.append(string, oldpos, len);
        return buf.toString();
    }

    public String trimFrom(CharSequence sequence) {
        int len = sequence.length();
        int first = 0;
        while (first < len) {
            if (!this.matches(sequence.charAt(first))) break;
            ++first;
        }
        int last = len - 1;
        while (last > first) {
            if (!this.matches(sequence.charAt(last))) break;
            --last;
        }
        return sequence.subSequence(first, last + 1).toString();
    }

    public String trimLeadingFrom(CharSequence sequence) {
        int len = sequence.length();
        int first = 0;
        while (first < len) {
            if (!this.matches(sequence.charAt(first))) break;
            ++first;
        }
        return sequence.subSequence(first, len).toString();
    }

    public String trimTrailingFrom(CharSequence sequence) {
        int len = sequence.length();
        int last = len - 1;
        while (last >= 0) {
            if (!this.matches(sequence.charAt(last))) break;
            --last;
        }
        return sequence.subSequence(0, last + 1).toString();
    }

    public String collapseFrom(CharSequence sequence, char replacement) {
        int first = this.indexIn(sequence);
        if (first == -1) {
            return sequence.toString();
        }
        StringBuilder builder = new StringBuilder(sequence.length()).append(sequence.subSequence(0, first)).append(replacement);
        boolean in = true;
        int i = first + 1;
        while (i < sequence.length()) {
            char c = sequence.charAt(i);
            if (this.apply(Character.valueOf(c))) {
                if (!in) {
                    builder.append(replacement);
                    in = true;
                }
            } else {
                builder.append(c);
                in = false;
            }
            ++i;
        }
        return builder.toString();
    }

    public String trimAndCollapseFrom(CharSequence sequence, char replacement) {
        int first = this.negate().indexIn(sequence);
        if (first == -1) {
            return "";
        }
        StringBuilder builder = new StringBuilder(sequence.length());
        boolean inMatchingGroup = false;
        int i = first;
        while (i < sequence.length()) {
            char c = sequence.charAt(i);
            if (this.apply(Character.valueOf(c))) {
                inMatchingGroup = true;
            } else {
                if (inMatchingGroup) {
                    builder.append(replacement);
                    inMatchingGroup = false;
                }
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class And
    extends CharMatcher {
        List<CharMatcher> components;

        And(List<CharMatcher> components) {
            this.components = components;
        }

        @Override
        public boolean matches(char c) {
            for (CharMatcher matcher : this.components) {
                if (matcher.matches(c)) continue;
                return false;
            }
            return true;
        }

        @Override
        public CharMatcher and(CharMatcher other) {
            ArrayList<CharMatcher> newComponents = new ArrayList<CharMatcher>(this.components);
            newComponents.add(Preconditions.checkNotNull(other));
            return new And(newComponents);
        }
    }

    protected static class LookupTable {
        int[] data = new int[2048];

        protected LookupTable() {
        }

        void set(char index) {
            int n = index >> 5;
            this.data[n] = this.data[n] | '\u0001' << index;
        }

        boolean get(char index) {
            return (this.data[index >> 5] & '\u0001' << index) != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Or
    extends CharMatcher {
        List<CharMatcher> components;

        Or(List<CharMatcher> components) {
            this.components = components;
        }

        @Override
        public boolean matches(char c) {
            for (CharMatcher matcher : this.components) {
                if (!matcher.matches(c)) continue;
                return true;
            }
            return false;
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            ArrayList<CharMatcher> newComponents = new ArrayList<CharMatcher>(this.components);
            newComponents.add(Preconditions.checkNotNull(other));
            return new Or(newComponents);
        }

        @Override
        protected void setBits(LookupTable table) {
            for (CharMatcher matcher : this.components) {
                matcher.setBits(table);
            }
        }
    }
}

