/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CaseFormat {
    LOWER_HYPHEN(Pattern.compile("[-]"), "-"),
    LOWER_UNDERSCORE(Pattern.compile("[_]"), "_"),
    LOWER_CAMEL(Pattern.compile("[A-Z]"), ""),
    UPPER_CAMEL(Pattern.compile("[A-Z]"), ""),
    UPPER_UNDERSCORE(Pattern.compile("[_]"), "_");

    private final Pattern wordBoundary;
    private final String wordSeparator;

    private CaseFormat(Pattern wordBoundary, String wordSeparator) {
        this.wordBoundary = wordBoundary;
        this.wordSeparator = wordSeparator;
    }

    public String to(CaseFormat format, String s) {
        if (format == null) {
            throw new NullPointerException();
        }
        if (s == null) {
            throw new NullPointerException();
        }
        if (format == this) {
            return s;
        }
        switch (this) {
            case LOWER_HYPHEN: {
                switch (format) {
                    case LOWER_UNDERSCORE: {
                        return s.replace("-", "_");
                    }
                    case UPPER_UNDERSCORE: {
                        return s.replace("-", "_").toUpperCase(Locale.US);
                    }
                }
                break;
            }
            case LOWER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return s.replace("_", "-");
                    }
                    case UPPER_UNDERSCORE: {
                        return s.toUpperCase(Locale.US);
                    }
                }
                break;
            }
            case UPPER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return s.replace("_", "-").toLowerCase(Locale.US);
                    }
                    case LOWER_UNDERSCORE: {
                        return s.toLowerCase(Locale.US);
                    }
                }
            }
        }
        StringBuilder out = null;
        int i = 0;
        Matcher matcher = this.wordBoundary.matcher(s);
        while (matcher.find()) {
            int j = matcher.start();
            if (i == 0) {
                out = new StringBuilder(s.length() + 4 * this.wordSeparator.length());
                out.append(format.normalizeFirstWord(s.substring(i, j)));
            } else {
                out.append(format.normalizeWord(s.substring(i, j)));
            }
            out.append(format.wordSeparator);
            i = j + this.wordSeparator.length();
        }
        if (i == 0) {
            return format.normalizeFirstWord(s);
        }
        out.append(format.normalizeWord(s.substring(i)));
        return out.toString();
    }

    private String normalizeFirstWord(String word) {
        switch (this) {
            case LOWER_CAMEL: {
                return word.toLowerCase(Locale.US);
            }
        }
        return this.normalizeWord(word);
    }

    private String normalizeWord(String word) {
        switch (this) {
            case LOWER_HYPHEN: {
                return word.toLowerCase(Locale.US);
            }
            case LOWER_UNDERSCORE: {
                return word.toLowerCase(Locale.US);
            }
            case LOWER_CAMEL: {
                return CaseFormat.toTitleCase(word);
            }
            case UPPER_CAMEL: {
                return CaseFormat.toTitleCase(word);
            }
            case UPPER_UNDERSCORE: {
                return word.toUpperCase(Locale.US);
            }
        }
        throw new RuntimeException("unknown case: " + (Object)((Object)this));
    }

    private static String toTitleCase(String word) {
        return word.length() < 2 ? word.toUpperCase(Locale.US) : String.valueOf(Character.toTitleCase(word.charAt(0))) + word.substring(1).toLowerCase(Locale.US);
    }
}

