/*
 * Decompiled with CFR 0.152.
 */
package biotools;

import biotools.ChromosomePosition;
import biotools.Ciagr;
import biotools.SAMRecordFlag;

public class SAMRecord {
    private String QNAME;
    private SAMRecordFlag Flag;
    private String RNAME;
    private ChromosomePosition POS;
    private int MAPQ;
    private Ciagr CIAGR;
    private String MRNM;
    private int MPOS;
    private int TLEN;
    private String SEQ;
    private String QUAL;
    private int NM;
    private String THISLINE;

    public SAMRecord(String recordline) {
        this.THISLINE = recordline;
        String[] SAMInfo = recordline.split("\t");
        this.QNAME = SAMInfo[0];
        try {
            Integer.parseInt(SAMInfo[1]);
        }
        catch (NumberFormatException e) {
            System.err.println(recordline);
            e.printStackTrace();
            System.exit(-1);
        }
        int flag = Integer.parseInt(SAMInfo[1]);
        this.Flag = new SAMRecordFlag(flag);
        String RNAME = SAMInfo[2];
        if (RNAME.length() < 4 && RNAME.compareTo("*") != 0) {
            RNAME = RNAME.compareTo("MT") == 0 ? "chrM" : "chr" + RNAME;
        }
        int pos = Integer.parseInt(SAMInfo[3]);
        this.POS = new ChromosomePosition(RNAME, pos);
        this.MAPQ = Integer.parseInt(SAMInfo[4]);
        String cigar = SAMInfo[5];
        this.CIAGR = new Ciagr(cigar);
        this.MRNM = SAMInfo[6];
        this.MPOS = Integer.parseInt(SAMInfo[7]);
        this.TLEN = Integer.parseInt(SAMInfo[8]);
        this.SEQ = SAMInfo[9];
        this.QUAL = SAMInfo[10];
        this.NM = 0;
        String[] stringArray = SAMInfo;
        int n = SAMInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            if (info.matches("MN:i:[0-9]+")) {
                this.NM = Integer.parseInt(info.split(":")[2]);
            }
            ++n2;
        }
    }

    public String getQNAME() {
        return this.QNAME;
    }

    public SAMRecordFlag getFlag() {
        return this.Flag;
    }

    public String getRNAME() {
        return this.RNAME;
    }

    public int getPOS() {
        return this.POS.getPosition();
    }

    public ChromosomePosition getGenomePOS() {
        return this.POS;
    }

    public int getMAPQ() {
        return this.MAPQ;
    }

    public Ciagr getCIAGR() {
        return this.CIAGR;
    }

    public String getMRNM() {
        return this.MRNM;
    }

    public int getMPOS() {
        return this.MPOS;
    }

    public int getTLEN() {
        return this.TLEN;
    }

    public String getSEQ() {
        return this.SEQ;
    }

    public String getQUAL() {
        return this.QUAL;
    }

    public boolean hasSoftclip() {
        return this.CIAGR.getTotalS() > 0;
    }

    public boolean hasClip() {
        return this.CIAGR.getTotalS() > 0 || this.CIAGR.getTotalH() > 0;
    }

    public int getEditDistance() {
        return this.NM;
    }

    public String getThisLine() {
        return this.THISLINE;
    }
}

