/*
 * Decompiled with CFR 0.152.
 */
package biotools;

import biotools.BEDRecord;
import biotools.ChromosomeName;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class BEDReader {
    private ArrayList<BEDRecord> GenomeBED;
    private HashMap<ChromosomeName, ArrayList<BEDRecord>> ChromosomeBED = new HashMap();

    public static void main(String[] args) {
        BEDReader bedreader = new BEDReader("/data2/bsi/RandD/s115463.Aneuploidy/reference/HG19_bin500.bed");
        for (ChromosomeName chr : bedreader.ChromosomeBED.keySet()) {
            for (BEDRecord bedrec : bedreader.ChromosomeBED.get(chr)) {
                System.err.println(String.valueOf(bedrec.getChrName().getName()) + "-" + bedrec.getStart() + "-" + bedrec.getEnd());
            }
        }
    }

    public BEDReader(String BEDfile) {
        this.GenomeBED = new ArrayList();
        ArrayList<Object> bedlist = null;
        try {
            String line;
            FileReader fr = new FileReader(BEDfile);
            BufferedReader bf = new BufferedReader(fr);
            while ((line = bf.readLine()) != null) {
                String[] contents;
                if (line.trim().length() == 0 || (contents = line.split("\t"))[0].compareToIgnoreCase("chr") == 0) continue;
                ChromosomeName ChrName = new ChromosomeName(contents[0]);
                if (this.ChromosomeBED.containsKey(ChrName)) {
                    bedlist = this.ChromosomeBED.get(ChrName);
                } else {
                    bedlist = new ArrayList();
                    this.ChromosomeBED.put(ChrName, bedlist);
                }
                int Start2 = Integer.parseInt(contents[1].trim());
                int End2 = Integer.parseInt(contents[2].trim());
                BEDRecord bedrec = new BEDRecord(ChrName, Start2, End2);
                bedlist.add(bedrec);
                this.GenomeBED.add(bedrec);
            }
            bf.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<BEDRecord> getBED() {
        return this.GenomeBED;
    }

    public ArrayList<BEDRecord> getBED(String chr) {
        return this.ChromosomeBED.get(new ChromosomeName(chr));
    }

    public void sortBEDByStart() {
        for (ChromosomeName chr : this.ChromosomeBED.keySet()) {
            Collections.sort((List)this.ChromosomeBED.get(chr));
        }
    }
}

