/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.AbstractListenableFuture;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.Executors;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UninterruptibleFuture;
import com.google.common.util.concurrent.ValueFuture;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Futures {
    private Futures() {
    }

    public static <V> UninterruptibleFuture<V> makeUninterruptible(final Future<V> future) {
        Preconditions.checkNotNull(future);
        if (future instanceof UninterruptibleFuture) {
            return (UninterruptibleFuture)future;
        }
        return new UninterruptibleFuture<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public V get(long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, ExecutionException {
                boolean interrupted = false;
                try {
                    long timeoutNanos = timeoutUnit.toNanos(timeoutDuration);
                    long end = System.nanoTime() + timeoutNanos;
                    long remaining = timeoutNanos;
                    while (remaining > 0L) {
                        Object v;
                        try {
                            v = future.get(remaining, TimeUnit.NANOSECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            try {
                                interrupted = true;
                                remaining = end - System.nanoTime();
                                continue;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                                throw new TimeoutException();
                            }
                        }
                        return v;
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }

            @Override
            public V get() throws ExecutionException {
                boolean interrupted = false;
                while (true) {
                    try {
                        Object v = future.get();
                        return v;
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }

    public static <T> ListenableFuture<T> makeListenable(Future<T> future) {
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<T>(future);
    }

    public static <T, E extends Exception> CheckedFuture<T, E> makeChecked(Future<T> future, Function<Exception, E> mapper) {
        return new MappingCheckedFuture<T, E>(Futures.makeListenable(future), mapper);
    }

    public static <T> ListenableFuture<T> immediateFuture(@Nullable T value) {
        ValueFuture future = ValueFuture.create();
        future.set(value);
        return future;
    }

    public static <T, E extends Exception> CheckedFuture<T, E> immediateCheckedFuture(@Nullable T value) {
        ValueFuture future = ValueFuture.create();
        future.set(value);
        return Futures.makeChecked(future, new Function<Exception, E>(){

            @Override
            public E apply(Exception e) {
                throw new AssertionError((Object)"impossible");
            }
        });
    }

    public static <T> ListenableFuture<T> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        ValueFuture future = ValueFuture.create();
        future.setException(throwable);
        return future;
    }

    public static <T, E extends Exception> CheckedFuture<T, E> immediateFailedCheckedFuture(final E exception) {
        Preconditions.checkNotNull(exception);
        return Futures.makeChecked(Futures.immediateFailedFuture(exception), new Function<Exception, E>(){

            @Override
            public E apply(Exception e) {
                return exception;
            }
        });
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> input, Function<? super I, ? extends ListenableFuture<? extends O>> function) {
        return Futures.chain(input, function, Executors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> input, Function<? super I, ? extends ListenableFuture<? extends O>> function, Executor exec) {
        ChainingListenableFuture chain = new ChainingListenableFuture(function, input);
        input.addListener(chain, exec);
        return chain;
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> future, Function<? super I, ? extends O> function) {
        return Futures.compose(future, function, Executors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> future, final Function<? super I, ? extends O> function, Executor exec) {
        Function wrapperFunction = new Function<I, ListenableFuture<O>>(){

            @Override
            public ListenableFuture<O> apply(I input) {
                Object output = function.apply(input);
                return Futures.immediateFuture(output);
            }
        };
        return Futures.chain(future, wrapperFunction, exec);
    }

    public static <I, O> Future<O> compose(final Future<I> future, final Function<? super I, ? extends O> function) {
        return new Future<O>(){
            private final Object lock = new Object();
            private boolean set = false;
            private O value = null;

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.apply(future.get());
            }

            @Override
            public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.apply(future.get(timeout, unit));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private O apply(I raw) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.set) {
                        this.value = function.apply(raw);
                        this.set = true;
                    }
                    return this.value;
                }
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainingListenableFuture<I, O>
    extends AbstractListenableFuture<O>
    implements Runnable {
        private final Function<? super I, ? extends ListenableFuture<? extends O>> function;
        private final UninterruptibleFuture<? extends I> inputFuture;

        private ChainingListenableFuture(Function<? super I, ? extends ListenableFuture<? extends O>> function, ListenableFuture<? extends I> inputFuture) {
            this.function = function;
            this.inputFuture = Futures.makeUninterruptible(inputFuture);
        }

        @Override
        public void run() {
            try {
                I sourceResult;
                try {
                    sourceResult = this.inputFuture.get();
                }
                catch (CancellationException cancellationException) {
                    this.cancel();
                    return;
                }
                catch (ExecutionException e) {
                    this.setException(e.getCause());
                    return;
                }
                final ListenableFuture<O> outputFuture = this.function.apply(sourceResult);
                outputFuture.addListener(new Runnable(){

                    public void run() {
                        try {
                            ChainingListenableFuture.this.set(Futures.makeUninterruptible(outputFuture).get());
                        }
                        catch (ExecutionException e) {
                            ChainingListenableFuture.this.setException(e.getCause());
                        }
                    }
                }, Executors.sameThreadExecutor());
            }
            catch (UndeclaredThrowableException e) {
                this.setException(e.getCause());
            }
            catch (RuntimeException e) {
                this.setException(e);
            }
            catch (Error e) {
                this.setException(e);
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenableFutureAdapter<T>
    extends ForwardingFuture<T>
    implements ListenableFuture<T> {
        private static final Executor adapterExecutor = java.util.concurrent.Executors.newCachedThreadPool();
        private final ExecutionList executionList = new ExecutionList();
        private final AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final Future<T> delegate;

        ListenableFutureAdapter(Future<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected Future<T> delegate() {
            return this.delegate;
        }

        @Override
        public void addListener(Runnable listener, Executor exec) {
            if (!this.hasListeners.get() && this.hasListeners.compareAndSet(false, true)) {
                adapterExecutor.execute(new Runnable(){

                    public void run() {
                        try {
                            ListenableFutureAdapter.this.delegate.get();
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (InterruptedException e) {
                            throw new IllegalStateException("Adapter thread interrupted!", e);
                        }
                        catch (ExecutionException executionException) {}
                        ListenableFutureAdapter.this.executionList.run();
                    }
                });
            }
            this.executionList.add(listener, exec);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingCheckedFuture<T, E extends Exception>
    extends AbstractCheckedFuture<T, E> {
        final Function<Exception, E> mapper;

        MappingCheckedFuture(ListenableFuture<T> delegate, Function<Exception, E> mapper) {
            super(delegate);
            this.mapper = mapper;
        }

        @Override
        protected E mapException(Exception e) {
            return (E)((Exception)this.mapper.apply(e));
        }
    }
}

