/*
 * Decompiled with CFR 0.152.
 */
package biotools;

import biotools.SAMRecord;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public class SAMReaderStream {
    private InputStreamReader isr;
    private BufferedReader br;

    public static void main(String[] args) {
        SAMRecord samrec;
        SAMReaderStream samreader = null;
        HashMap<String, Integer> test1 = new HashMap<String, Integer>();
        HashMap<String, Integer> test2 = new HashMap<String, Integer>();
        if (args.length == 5) {
            samreader = new SAMReaderStream("samtools", args[0], args[2], Integer.parseInt(args[3]), Integer.parseInt(args[4]));
        } else if (args.length == 3) {
            samreader = new SAMReaderStream(args[0], args[2]);
        } else if (args.length == 2) {
            samreader = new SAMReaderStream("samtools", args[0]);
        } else {
            System.err.println("Xianfeng Chen (Jeff), chen.xianfeng@mayo.edu, June-20-2013\nget read insertion size from a bam file (only R2F1 and F2R1 are selected.)\ncolumns are: <read chromosome> <read start position> <insertation size>\ninput arguements:\n1) bam mapq\n2) bam mapq chr\n3) bam mapq chr start end\n");
            System.exit(-1);
        }
        int a01 = 0;
        int a11 = 0;
        int a21 = 0;
        int a02 = 0;
        int a12 = 0;
        int a22 = 0;
        int b01 = 0;
        int b11 = 0;
        int b21 = 0;
        int b02 = 0;
        int b12 = 0;
        int b22 = 0;
        while ((samrec = samreader.getSAMStreamRecord()) != null) {
            if (samrec.getMAPQ() < Integer.parseInt(args[1]) || samrec.getMRNM().compareTo("=") != 0) continue;
            if (samrec.getFlag().isReverseStrand() && !samrec.getFlag().isReverseMateStrand()) {
                if (samrec.getTLEN() > 0) {
                    if (samrec.getFlag().isFirstRead()) {
                        ++a11;
                        continue;
                    }
                    if (samrec.getFlag().isSecondRead()) {
                        ++a12;
                        continue;
                    }
                    System.err.println("what pair I am a1?");
                    System.exit(-1);
                    continue;
                }
                if (samrec.getTLEN() < 0) {
                    if (samrec.getFlag().isFirstRead()) {
                        samrec.getTLEN();
                        test1.put(samrec.getQNAME(), samrec.getPOS());
                        ++a21;
                        continue;
                    }
                    if (samrec.getFlag().isSecondRead()) {
                        samrec.getTLEN();
                        ++a22;
                        continue;
                    }
                    System.err.println("what pair I am a2?");
                    System.exit(-1);
                    continue;
                }
                if (samrec.getFlag().isFirstRead()) {
                    ++a01;
                    continue;
                }
                if (samrec.getFlag().isSecondRead()) {
                    ++a02;
                    continue;
                }
                System.err.println("what pair I am a0?");
                System.exit(-1);
                continue;
            }
            if (samrec.getFlag().isReverseStrand() || !samrec.getFlag().isReverseMateStrand()) continue;
            if (samrec.getTLEN() > 0) {
                if (samrec.getFlag().isFirstRead()) {
                    samrec.getTLEN();
                    ++b11;
                    continue;
                }
                if (samrec.getFlag().isSecondRead()) {
                    samrec.getTLEN();
                    test2.put(samrec.getQNAME(), samrec.getPOS());
                    ++b12;
                    continue;
                }
                System.err.println("what pair I am b1?");
                System.exit(-1);
                continue;
            }
            if (samrec.getTLEN() < 0) {
                if (samrec.getFlag().isFirstRead()) {
                    ++b21;
                    continue;
                }
                if (samrec.getFlag().isSecondRead()) {
                    ++b22;
                    continue;
                }
                System.err.println("what pair I am b2?");
                System.exit(-1);
                continue;
            }
            if (samrec.getFlag().isFirstRead()) {
                ++b01;
                continue;
            }
            if (samrec.getFlag().isSecondRead()) {
                ++b02;
                continue;
            }
            System.err.println("what pair I am b0?");
            System.exit(-1);
        }
        samreader.close();
        System.out.println("a01=" + a01 + ",a02=" + a02 + ",a11=" + a11 + ",a12=" + a12 + ",a21=" + a21 + ",a22=" + a22 + ",b01=" + b01 + ",b02=" + b02 + ",b11=" + b11 + ",b12=" + b12 + ",b21=" + b21 + ",b22=" + b22);
        Sets.SetView difference1 = Sets.difference(test1.keySet(), test2.keySet());
        Sets.SetView difference2 = Sets.difference(test2.keySet(), test1.keySet());
        System.out.println("difference1#=" + difference1.size() + "\tdifference2#=" + difference2.size());
    }

    public SAMReaderStream() {
        this.open("cmd", "/dev/stdin");
    }

    public SAMReaderStream(String Samtools, String SAMFile) {
        String cmd = String.valueOf(Samtools) + " view " + SAMFile;
        this.open(cmd, SAMFile);
    }

    public SAMReaderStream(String Samtools, String SAMFile, String Chromosome) {
        Chromosome = this.CalibrateChromosomeSyntex(Samtools, SAMFile, Chromosome);
        String cmd = String.valueOf(Samtools) + " view " + SAMFile + " " + Chromosome;
        this.open(cmd, SAMFile);
    }

    public SAMReaderStream(String Samtools, String SAMFile, String Chromosome, int start, int end) {
        Chromosome = this.CalibrateChromosomeSyntex(Samtools, SAMFile, Chromosome);
        String cmd = String.valueOf(Samtools) + " view " + SAMFile + " " + Chromosome + ":" + start + "-" + end;
        this.open(cmd, SAMFile);
    }

    private String CalibrateChromosomeSyntex(String Samtools, String SAMFile, String Chromosome) {
        String cmd = String.valueOf(Samtools) + " view " + SAMFile;
        System.err.println("Samtools=" + Samtools);
        boolean IsSTDChromosomeName = true;
        this.open(cmd, SAMFile);
        try {
            String line = this.br.readLine();
            String[] SAMInfo = line.split("\t");
            String RNAME = SAMInfo[2];
            IsSTDChromosomeName = RNAME.length() >= 4;
            this.br.readLine();
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (IsSTDChromosomeName) {
            return Chromosome;
        }
        if (Chromosome.compareTo("chrM") == 0) {
            return "MT";
        }
        return Chromosome.substring(3);
    }

    private void open(String cmd, String SAMFile) {
        try {
            if (SAMFile.compareTo("/dev/stdin") == 0) {
                this.isr = new InputStreamReader(System.in);
                System.err.println("System.in is used.");
            } else {
                Runtime rt = Runtime.getRuntime();
                System.err.println(cmd);
                Process proc = rt.exec(cmd);
                this.isr = new InputStreamReader(proc.getInputStream());
            }
            this.br = new BufferedReader(this.isr, 1024);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.br.close();
            this.isr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SAMRecord getSAMStreamRecord() {
        String line;
        block3: {
            try {
                line = this.br.readLine();
                if (line != null) break block3;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(-1);
                return null;
            }
        }
        SAMRecord srec = new SAMRecord(line);
        return srec;
    }
}

