/*
 * Decompiled with CFR 0.152.
 */
package biotools;

import java.util.ArrayList;
import java.util.Arrays;

public class ChromosomeName
implements Comparable {
    private String OriginalName;
    private String StandardName;
    private static ArrayList<String> StandardNameList = new ArrayList<String>(Arrays.asList("chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY", "chrM"));

    public ChromosomeName(String chr) {
        String chrstr;
        String indexstr = this.OriginalName = chr;
        if (this.OriginalName.length() > "chr".length() && (chrstr = this.OriginalName.substring(0, 3)).compareToIgnoreCase("chr") == 0) {
            indexstr = this.OriginalName.substring(3);
        }
        this.StandardName = "chr" + indexstr.toUpperCase();
        if (this.StandardName.compareTo("chrMT") == 0) {
            this.StandardName = "chrM";
        }
    }

    public String getName() {
        return this.StandardName;
    }

    public String getOriginalName() {
        return this.OriginalName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.StandardName.compareTo(new ChromosomeName((String)obj).getName()) == 0;
        }
        if (obj instanceof ChromosomeName) {
            return this.StandardName.compareTo(((ChromosomeName)obj).getName()) == 0;
        }
        System.err.println("warning! check chromosome name.");
        return false;
    }

    public int hashCode() {
        return this.StandardName.hashCode();
    }

    public int compareTo(Object obj) {
        String anotherstdname = null;
        if (obj instanceof String) {
            anotherstdname = new ChromosomeName((String)obj).getName();
        } else if (obj instanceof ChromosomeName) {
            anotherstdname = ((ChromosomeName)obj).getName();
        } else {
            System.err.println(obj.getClass().getName());
        }
        if (this.StandardName == null && anotherstdname == null) {
            return 0;
        }
        if (this.StandardName == null) {
            return -1;
        }
        if (anotherstdname == null) {
            return 1;
        }
        if (ChromosomeName.getChromosomeIndex(this.StandardName) > ChromosomeName.getChromosomeIndex(anotherstdname)) {
            return 1;
        }
        if (ChromosomeName.getChromosomeIndex(this.StandardName) < ChromosomeName.getChromosomeIndex(anotherstdname)) {
            return -1;
        }
        return 0;
    }

    public static int getChromosomeIndex(String stdChr) {
        String indexstr;
        if (!StandardNameList.contains(stdChr) && stdChr.indexOf("chrGL000") != 0 && stdChr.indexOf("_GL000") < 0) {
            System.err.println(String.valueOf(stdChr) + " is not a standard chromosome name.");
            System.exit(-1);
        }
        if ((indexstr = stdChr.substring(3)).compareTo("X") == 0) {
            return 23;
        }
        if (indexstr.compareTo("Y") == 0) {
            return 24;
        }
        if (indexstr.compareTo("M") == 0) {
            return 25;
        }
        if (indexstr.indexOf("GL000") == 0) {
            indexstr = indexstr.substring(2, indexstr.indexOf("."));
        } else if (indexstr.indexOf("_GL0") >= 0) {
            String[] chrinfo = indexstr.split("_");
            indexstr = chrinfo[1].substring(2);
        }
        return Integer.parseInt(indexstr);
    }
}

