/*
 * Decompiled with CFR 0.152.
 */
package biotools;

import biotools.ChromosomeName;
import biotools.ChromosomePosition;
import java.util.Comparator;

public class BEDRecord
extends ChromosomePosition {
    protected int End;
    protected Object UserInfo;
    private String SiteName;

    public BEDRecord(String ChrName, int Start2, int End2) {
        super(ChrName, Start2);
        this.End = End2;
    }

    public BEDRecord(String ChrName, int Start2, int End2, String SiteName) {
        super(ChrName, Start2);
        this.End = End2;
        this.SiteName = SiteName;
    }

    public BEDRecord(ChromosomeName ChrName, int Start2, int End2) {
        this.ChrName = ChrName;
        this.Start = Start2;
        this.End = End2;
    }

    public int getStart() {
        return this.Start;
    }

    public ChromosomePosition getGenomeStart() {
        return this;
    }

    public int getEnd() {
        return this.End;
    }

    public String getSiteName() {
        return this.SiteName;
    }

    public ChromosomePosition getGenomeEnd() {
        return new ChromosomePosition(this.ChrName.getName(), this.End);
    }

    public Object getUserInfo() {
        return this.UserInfo;
    }

    public void setUserInfo(Object UserInfo2) {
        this.UserInfo = UserInfo2;
    }

    public void setStart(int start) {
        this.Start = start;
    }

    public void setEnd(int end) {
        this.End = end;
    }

    public static class EndPositionComparator
    implements Comparator<BEDRecord> {
        @Override
        public int compare(BEDRecord record1, BEDRecord record2) {
            if (record1.getChrName().compareTo(record2.getChrName()) > 0) {
                return 1;
            }
            if (record1.getChrName().compareTo(record2.getChrName()) < 0) {
                return -1;
            }
            if (record1.getEnd() > record2.getEnd()) {
                return 1;
            }
            if (record1.getEnd() < record2.getEnd()) {
                return -1;
            }
            return 0;
        }
    }

    public static class StartPositionComparator
    implements Comparator<BEDRecord> {
        @Override
        public int compare(BEDRecord record1, BEDRecord record2) {
            if (record1.getChrName().compareTo(record2.getChrName()) > 0) {
                return 1;
            }
            if (record1.getChrName().compareTo(record2.getChrName()) < 0) {
                return -1;
            }
            if (record1.getStart() > record2.getStart()) {
                return 1;
            }
            if (record1.getStart() < record2.getStart()) {
                return -1;
            }
            return 0;
        }
    }
}

