/*
 * Decompiled with CFR 0.152.
 */
package aneuploidy;

import biotools.BEDReader;
import biotools.BEDRecord;
import biotools.MemoryInfo;
import biotools.SAMReaderStream;
import biotools.SAMRecord;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class HumanGenomeReadInfoWithBedNipt {
    private static String Samtools;
    private static String BAMDir;
    private static int MappingQuality;
    private static String Filter;
    private static String BED;
    private static int MaxInsertionSize;
    private static int BinSize;
    private static int BinNumber;
    private static String ChromosomeList;
    private static int ReadLength;
    private static int MaxCNVLength;
    private static boolean isSingleEnd;
    private static boolean Debug;
    private static boolean IsFirstError;
    private static HashMap<String, Integer> MedianHash;

    static {
        Debug = false;
        IsFirstError = true;
    }

    public static void setParameters(String[] args) {
        JSAP jsap = new JSAP();
        try {
            jsap.registerParameter(new Switch("help", 'h', "help", "Print help message"));
            FlaggedOption opt1 = new FlaggedOption("a bam directory or a bam file").setStringParser(JSAP.STRING_PARSER).setDefault("/data2/external_data/Klee_Eric_mrl2075/s117291.sequenome_analysis/Sequenome_Sep_2014_novoalign_bam/flow_cell1_RDFC011340/RDSR126309_CGGCATTA_L001_R1_001.bam").setRequired(true).setShortFlag('i').setLongFlag(JSAP.NO_LONGFLAG);
            opt1.setHelp("set a bam directory or a sorted bam file.");
            jsap.registerParameter(opt1);
            FlaggedOption opt2 = new FlaggedOption("BED file").setStringParser(JSAP.STRING_PARSER).setDefault("/data2/bsi/RandD/s115463.Aneuploidy/Wandy/reference/summary_bin_info_Sep30_2014.txt").setRequired(true).setShortFlag('b').setLongFlag(JSAP.NO_LONGFLAG);
            opt2.setHelp("set a BED file.");
            jsap.registerParameter(opt2);
            FlaggedOption opt3 = new FlaggedOption("mapping quality").setStringParser(JSAP.INTEGER_PARSER).setRequired(true).setDefault("20").setShortFlag('q').setLongFlag(JSAP.NO_LONGFLAG);
            opt3.setHelp("set read mapping quality.");
            jsap.registerParameter(opt3);
            FlaggedOption opt4 = new FlaggedOption("filter").setStringParser(JSAP.STRING_PARSER).setDefault("*.bam").setRequired(true).setShortFlag('f').setLongFlag(JSAP.NO_LONGFLAG);
            opt4.setHelp("set bam file filter.");
            jsap.registerParameter(opt4);
            FlaggedOption opt5 = new FlaggedOption("chromosome list separated by comma").setStringParser(JSAP.STRING_PARSER).setRequired(true).setDefault("chr1,chr2,chr3,chr4,chr5,chr6,chr7,chr8,chr9,chr10,chr11,chr12,chr13,chr14,chr15,chr16,chr17,chr18,chr19,chr20,chr21,chr22,chrX,chrY,chrM").setShortFlag('c').setLongFlag(JSAP.NO_LONGFLAG);
            opt5.setHelp("set chromosomes to be processed.");
            jsap.registerParameter(opt5);
            FlaggedOption opt6 = new FlaggedOption("insertion bin size used").setStringParser(JSAP.INTEGER_PARSER).setRequired(true).setDefault("50").setShortFlag('n').setLongFlag(JSAP.NO_LONGFLAG);
            opt6.setHelp("set an insertion bin size used for read frequency histogram.");
            jsap.registerParameter(opt6);
            FlaggedOption opt7 = new FlaggedOption("maximum insertion size allowed").setStringParser(JSAP.INTEGER_PARSER).setRequired(true).setDefault("2000").setShortFlag('m').setLongFlag(JSAP.NO_LONGFLAG);
            opt7.setHelp("set a maximum insertion size allowed.");
            jsap.registerParameter(opt7);
            FlaggedOption opt12 = new FlaggedOption("read length").setStringParser(JSAP.INTEGER_PARSER).setRequired(true).setDefault("50").setShortFlag('l').setLongFlag(JSAP.NO_LONGFLAG);
            opt12.setHelp("set read length.");
            jsap.registerParameter(opt12);
            FlaggedOption opt13 = new FlaggedOption("single or paired end").setStringParser(JSAP.INTEGER_PARSER).setRequired(true).setDefault("2").setShortFlag('e').setLongFlag(JSAP.NO_LONGFLAG);
            opt13.setHelp("set 1 (single) or 2 (paired) end.");
            jsap.registerParameter(opt13);
            FlaggedOption opt14 = new FlaggedOption("maximum CNV length").setStringParser(JSAP.INTEGER_PARSER).setRequired(true).setDefault("-1").setShortFlag('y').setLongFlag(JSAP.NO_LONGFLAG);
            opt14.setHelp("set maximum CNV length for deletion/inversion/CNV repeats.");
            jsap.registerParameter(opt14);
            FlaggedOption opt15 = new FlaggedOption("samtools with path").setStringParser(JSAP.STRING_PARSER).setRequired(true).setDefault("samtools").setShortFlag('s').setLongFlag(JSAP.NO_LONGFLAG);
            opt15.setHelp("set samtools with absolute path.");
            jsap.registerParameter(opt15);
            FlaggedOption opt16 = new FlaggedOption("debug mode").setStringParser(JSAP.BOOLEAN_PARSER).setRequired(false).setDefault("false").setShortFlag('x').setLongFlag("Debug");
            opt16.setHelp("set debug mode true/false.");
            jsap.registerParameter(opt16);
            JSAPResult config = jsap.parse(args);
            boolean isPrintHelp = config.getBoolean("help");
            if (isPrintHelp) {
                System.out.println("get read coverage and insertion size distribution within a bed file.");
                System.err.println(jsap.getHelp());
                System.err.println("Usage: input check " + jsap.getUsage());
                System.exit(3);
            }
            if (!config.success()) {
                System.err.println();
                System.err.println("Usage: input check " + jsap.getUsage());
                System.err.println();
                Iterator errs = config.getErrorMessageIterator();
                while (errs.hasNext()) {
                    System.err.println("Error: " + errs.next());
                }
                System.exit(3);
            }
            BAMDir = config.getString("a bam directory or a bam file");
            MappingQuality = config.getInt("mapping quality");
            BED = config.getString("BED file");
            Filter = config.getString("filter");
            ChromosomeList = config.getString("chromosome list separated by comma");
            BinSize = config.getInt("insertion bin size used");
            MaxInsertionSize = config.getInt("maximum insertion size allowed");
            BinNumber = MaxInsertionSize / BinSize;
            ReadLength = config.getInt("read length");
            MaxCNVLength = config.getInt("maximum CNV length");
            Samtools = config.getString("samtools with path");
            isSingleEnd = config.getInt("single or paired end") == 1;
            Debug = config.getBoolean("debug mode");
            System.err.println("Input parameters are listed below:");
            System.err.println("A BAM file or directory: " + BAMDir);
            System.err.println("Mapping quality: " + MappingQuality);
            System.err.println("BED file: " + BED);
            System.err.println("File filter: " + Filter);
            System.err.println("Chromosome list: " + ChromosomeList);
            System.err.println("Bin size for insertion size: " + BinSize);
            System.err.println("Maximum insertation size for bin: " + MaxInsertionSize);
            System.err.println("Number of bin for insertion size: " + BinNumber);
            System.err.println("Read length: " + ReadLength);
            System.err.println("Debug=" + Debug);
            System.err.println();
            System.err.println("Samtools=" + Samtools);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        HumanGenomeReadInfoWithBedNipt.setParameters(args);
        ArrayList<String> SAMFileNames = new ArrayList<String>();
        if (new File(BAMDir).isFile()) {
            SAMFileNames.add(BAMDir);
        } else {
            String[] cmd = new String[]{"sh", "-c", "ls " + BAMDir + File.separatorChar + Filter};
            try {
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(cmd);
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()), 1024);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.err.println(line);
                    SAMFileNames.add(line);
                }
                br.close();
                proc.getInputStream().close();
                proc.getErrorStream().close();
                proc.getOutputStream().close();
                proc.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String[] Chromosome = ChromosomeList.split(",");
        new HumanGenomeReadInfoWithBedNipt(SAMFileNames.toArray(new String[SAMFileNames.size()]), MappingQuality, Chromosome, BED);
        new MemoryInfo(Runtime.getRuntime());
    }

    public HumanGenomeReadInfoWithBedNipt(String[] SAMFileNames, int MappingQuality, String[] Chromosome, String BED) {
        if (!isSingleEnd) {
            this.firstReadSAM(SAMFileNames, MappingQuality, Chromosome);
        }
        this.secondReadSAM(SAMFileNames, MappingQuality, Chromosome, BED);
    }

    private void firstReadSAM(String[] SAMFileNames, int MappingQuality, String[] Chromosome) {
        MedianHash = new HashMap();
        int i = 0;
        while (i < SAMFileNames.length) {
            int[] bins = new int[MaxInsertionSize + 1];
            String[] stringArray = Chromosome;
            int n = Chromosome.length;
            int n2 = 0;
            while (n2 < n) {
                SAMRecord samrec;
                String chr = stringArray[n2];
                SAMReaderStream samreader = new SAMReaderStream(Samtools, SAMFileNames[i], chr);
                while ((samrec = samreader.getSAMStreamRecord()) != null) {
                    if (samrec.getMAPQ() < MappingQuality || samrec.getMRNM().compareTo("=") != 0 || MaxCNVLength >= 0 && Math.abs(samrec.getPOS() - samrec.getMPOS()) >= MaxCNVLength || (!samrec.getFlag().isReverseStrand() || samrec.getFlag().isReverseMateStrand()) && (samrec.getFlag().isReverseStrand() || !samrec.getFlag().isReverseMateStrand())) continue;
                    int insertsize = Math.abs(samrec.getTLEN());
                    if (insertsize > MaxInsertionSize) {
                        insertsize = MaxInsertionSize;
                    }
                    int n3 = insertsize;
                    bins[n3] = bins[n3] + 1;
                }
                samreader.close();
                ++n2;
            }
            MedianHash.put(SAMFileNames[i], this.findMedian(bins));
            ++i;
        }
    }

    private int findMedian(int[] HistogramArray) {
        int total = 0;
        int half = 0;
        int i = 0;
        while (i < HistogramArray.length) {
            total += HistogramArray[i];
            ++i;
        }
        i = 0;
        while (i < HistogramArray.length) {
            if ((float)(half += HistogramArray[i]) * 1.0f / (float)total >= 0.5f) {
                return i;
            }
            ++i;
        }
        System.err.println("Could not find a median value in findMedian(int []), HistogramArraySize=" + HistogramArray.length + ", total=" + total);
        System.err.println("check if bam file sorted, indexed or single-end reads.");
        System.exit(-1);
        return -1;
    }

    private void secondReadSAM(String[] SAMFileNames, int MappingQuality, String[] Chromosome, String BED) {
        String BinString = "";
        int i = 0;
        while (i < BinNumber) {
            BinString = String.valueOf(BinString) + "\t" + i * BinSize + "-" + ((i + 1) * BinSize - 1);
            ++i;
        }
        System.out.println("FileName\tChromosome\tStart\tEnd\tBND_Number\tNonDB_SNP_Number\tCNV_Number(del:dup)\tHigh_Quality_Read\tNormal_Pair_EditDistance_Count\tNormal_Pair_Softclip\tMate_Wrong_Direction\tMate_Wrong_Location\tSame_Chr_Translocation\tMate_No_Map\tMate_Map_Other_Chr\tLow_Quality_Read" + BinString + "\t>" + MaxInsertionSize);
        i = 0;
        while (i < SAMFileNames.length) {
            BEDReader bedreader = new BEDReader(BED);
            String filepathname = SAMFileNames[i];
            String filename = filepathname.substring(filepathname.lastIndexOf("/") + 1);
            String[] stringArray = Chromosome;
            int n = Chromosome.length;
            int n2 = 0;
            while (n2 < n) {
                String chr = stringArray[n2];
                System.gc();
                ArrayList<BEDRecord> bedrecordchr = bedreader.getBED(chr);
                if (bedrecordchr != null) {
                    SAMRecord samrec;
                    Iterator<BEDRecord> itr = bedrecordchr.iterator();
                    BEDRecord currentbin = null;
                    if (itr.hasNext()) {
                        currentbin = itr.next();
                    } else {
                        System.err.println("itr has no next, BED file may be empty!");
                    }
                    SAMReaderStream samreader = new SAMReaderStream(Samtools, SAMFileNames[i], chr);
                    while ((samrec = samreader.getSAMStreamRecord()) != null) {
                        if ((currentbin = this.countReadInBin(samrec, MappingQuality, currentbin, itr, filepathname)) == null) break;
                    }
                    samreader.close();
                    for (BEDRecord bedrecord : bedreader.getBED(chr)) {
                        int highqualityreadcount = 0;
                        int bndcount = 0;
                        int snpcount = 0;
                        int cnvdelcount = 0;
                        int cnvdupcount = 0;
                        int softclipcount = 0;
                        int editdistancecount = 0;
                        int matewrongdirection = 0;
                        int matewronglocation = 0;
                        int samechrtranslocation = 0;
                        int matenomap = 0;
                        int mateotherchrmap = 0;
                        int lowqualityreadcount = 0;
                        int[] insertionsizecount = new int[BinNumber + 1];
                        if (bedrecord.getUserInfo() != null) {
                            highqualityreadcount = ((UserInfo)bedrecord.getUserInfo()).HighQualityReadCount;
                            editdistancecount = ((UserInfo)bedrecord.getUserInfo()).EditDistanceCount;
                            softclipcount = ((UserInfo)bedrecord.getUserInfo()).ClipCount;
                            matewrongdirection = ((UserInfo)bedrecord.getUserInfo()).MateWrongDirection;
                            matewronglocation = ((UserInfo)bedrecord.getUserInfo()).MateWrongLocation;
                            samechrtranslocation = ((UserInfo)bedrecord.getUserInfo()).SameChrTranslocation;
                            matenomap = ((UserInfo)bedrecord.getUserInfo()).MateNoMap;
                            mateotherchrmap = ((UserInfo)bedrecord.getUserInfo()).MateOtherChrMap;
                            lowqualityreadcount = ((UserInfo)bedrecord.getUserInfo()).LowQualityReadCount;
                            bndcount = ((UserInfo)bedrecord.getUserInfo()).BNDCount;
                            snpcount = ((UserInfo)bedrecord.getUserInfo()).SNPCount;
                            cnvdelcount = ((UserInfo)bedrecord.getUserInfo()).CNVDelCount;
                            cnvdupcount = ((UserInfo)bedrecord.getUserInfo()).CNVDupCount;
                            insertionsizecount = ((UserInfo)bedrecord.getUserInfo()).InsertionSizeCount;
                        }
                        System.out.print(String.valueOf(filename) + "\t" + bedrecord.getChrName().getName() + "\t" + bedrecord.getStart() + "\t" + bedrecord.getEnd() + "\t" + bndcount + "\t" + snpcount + "\t" + cnvdelcount + ":" + cnvdupcount + "\t" + highqualityreadcount + "\t" + editdistancecount + "\t" + softclipcount + "\t" + matewrongdirection + "\t" + matewronglocation + "\t" + samechrtranslocation + "\t" + matenomap + "\t" + mateotherchrmap + "\t" + lowqualityreadcount);
                        int[] nArray = insertionsizecount;
                        int n3 = insertionsizecount.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int count = nArray[n4];
                            System.out.print("\t" + count);
                            ++n4;
                        }
                        System.out.println();
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    private UserInfo initiateUserInfo(BEDRecord currentbin) {
        UserInfo userinfo = new UserInfo();
        userinfo.InsertionSizeCount = new int[BinNumber + 1];
        return userinfo;
    }

    private BEDRecord countReadInBin(SAMRecord samrec, int MappingQuality, BEDRecord currentbin, Iterator<BEDRecord> itr, String filepathname) {
        int i;
        for (i = 0; i < 249250621; ++i) {
            if (samrec.getPOS() >= currentbin.getStart() && samrec.getPOS() <= currentbin.getEnd()) {
                UserInfo userinfo = currentbin.getUserInfo() == null ? this.initiateUserInfo(currentbin) : (UserInfo)currentbin.getUserInfo();
                if (samrec.getMAPQ() >= MappingQuality) {
                    ++userinfo.HighQualityReadCount;
                    if (isSingleEnd) {
                        if (samrec.hasClip()) {
                            ++userinfo.ClipCount;
                        } else if (samrec.getEditDistance() > 0) {
                            ++userinfo.EditDistanceCount;
                        }
                    } else if (samrec.getMRNM().compareTo("=") == 0) {
                        if (MaxCNVLength < 0 || Math.abs(samrec.getPOS() - samrec.getMPOS()) < MaxCNVLength) {
                            if (samrec.getFlag().isReverseStrand() && !samrec.getFlag().isReverseMateStrand()) {
                                if (samrec.getTLEN() > 0) {
                                    if (samrec.getFlag().isFirstRead()) {
                                        ++userinfo.MateWrongLocation;
                                    } else if (samrec.getFlag().isSecondRead()) {
                                        ++userinfo.MateWrongLocation;
                                    } else {
                                        System.err.println("what pair I am a1?");
                                        System.exit(-1);
                                    }
                                } else if (samrec.getTLEN() < 0) {
                                    if (samrec.getFlag().isFirstRead()) {
                                        if (samrec.getTLEN() <= -ReadLength) {
                                            int insertionsize = Math.abs(samrec.getTLEN());
                                            if (insertionsize >= MaxInsertionSize) {
                                                insertionsize = MaxInsertionSize;
                                            }
                                            int n = insertionsize / BinSize;
                                            userinfo.InsertionSizeCount[n] = userinfo.InsertionSizeCount[n] + 1;
                                            if (samrec.hasClip()) {
                                                ++userinfo.ClipCount;
                                            } else if (samrec.getEditDistance() > 0) {
                                                ++userinfo.EditDistanceCount;
                                            }
                                        } else {
                                            ++userinfo.MateWrongLocation;
                                        }
                                    } else if (samrec.getFlag().isSecondRead()) {
                                        if (samrec.getTLEN() <= -ReadLength) {
                                            int insertionsize = Math.abs(samrec.getTLEN());
                                            if (insertionsize >= MaxInsertionSize) {
                                                insertionsize = MaxInsertionSize;
                                            }
                                            int n = insertionsize / BinSize;
                                            userinfo.InsertionSizeCount[n] = userinfo.InsertionSizeCount[n] + 1;
                                            if (samrec.hasClip()) {
                                                ++userinfo.ClipCount;
                                            } else if (samrec.getEditDistance() > 0) {
                                                ++userinfo.EditDistanceCount;
                                            }
                                        } else {
                                            ++userinfo.MateWrongLocation;
                                        }
                                    } else {
                                        System.err.println("what pair I am a2?");
                                        System.exit(-1);
                                    }
                                } else if (samrec.getFlag().isFirstRead()) {
                                    ++userinfo.MateWrongLocation;
                                } else if (samrec.getFlag().isSecondRead()) {
                                    ++userinfo.MateWrongLocation;
                                } else {
                                    System.err.println("what pair I am a0?");
                                    System.exit(-1);
                                }
                            } else if (!samrec.getFlag().isReverseStrand() && samrec.getFlag().isReverseMateStrand()) {
                                if (samrec.getTLEN() > 0) {
                                    if (samrec.getFlag().isFirstRead()) {
                                        if (samrec.getTLEN() >= ReadLength) {
                                            int insertionsize = Math.abs(samrec.getTLEN());
                                            if (insertionsize >= MaxInsertionSize) {
                                                insertionsize = MaxInsertionSize;
                                            }
                                            int n = insertionsize / BinSize;
                                            userinfo.InsertionSizeCount[n] = userinfo.InsertionSizeCount[n] + 1;
                                            if (samrec.hasClip()) {
                                                ++userinfo.ClipCount;
                                            }
                                        } else {
                                            ++userinfo.MateWrongLocation;
                                        }
                                    } else if (samrec.getFlag().isSecondRead()) {
                                        if (samrec.getTLEN() >= ReadLength) {
                                            int insertionsize = Math.abs(samrec.getTLEN());
                                            if (insertionsize >= MaxInsertionSize) {
                                                insertionsize = MaxInsertionSize;
                                            }
                                            int n = insertionsize / BinSize;
                                            userinfo.InsertionSizeCount[n] = userinfo.InsertionSizeCount[n] + 1;
                                            if (samrec.hasClip()) {
                                                ++userinfo.ClipCount;
                                            }
                                        } else {
                                            ++userinfo.MateWrongLocation;
                                        }
                                    } else {
                                        System.err.println("what pair I am b1?");
                                        System.exit(-1);
                                    }
                                } else if (samrec.getTLEN() < 0) {
                                    if (samrec.getFlag().isFirstRead()) {
                                        ++userinfo.MateWrongLocation;
                                    } else if (samrec.getFlag().isSecondRead()) {
                                        ++userinfo.MateWrongLocation;
                                    } else {
                                        System.err.println("what pair I am b2?");
                                        System.exit(-1);
                                    }
                                } else if (samrec.getFlag().isFirstRead()) {
                                    ++userinfo.MateWrongLocation;
                                } else if (samrec.getFlag().isSecondRead()) {
                                    ++userinfo.MateWrongLocation;
                                } else {
                                    System.err.println("what pair I am b0?");
                                    System.exit(-1);
                                }
                            } else {
                                ++userinfo.MateWrongDirection;
                            }
                        } else {
                            ++userinfo.SameChrTranslocation;
                        }
                    } else if (samrec.getMRNM().compareTo("*") == 0) {
                        ++userinfo.MateNoMap;
                    } else {
                        ++userinfo.MateOtherChrMap;
                    }
                    currentbin.setUserInfo(userinfo);
                } else {
                    ++userinfo.LowQualityReadCount;
                }
            } else {
                if (samrec.getPOS() > currentbin.getEnd()) {
                    if (itr.hasNext()) {
                        currentbin = itr.next();
                        continue;
                    }
                    return null;
                }
                if (IsFirstError) {
                    System.err.print("bam record position less than current bed start position indicating non-consecutive bins or incorrect BED format: ");
                    System.err.println("readchr=" + samrec.getRNAME() + " readpos=" + samrec.getPOS() + " binchr=" + currentbin.getChrName().getName() + " binstart=" + currentbin.getStart() + " binend=" + currentbin.getEnd());
                    if (!Debug) {
                        System.err.println("there are more, please use option '-x true' to show all.");
                        IsFirstError = false;
                    }
                }
            }
            return currentbin;
        }
        System.err.println("Error: run out of loops:" + i);
        System.exit(-1);
        return null;
    }

    private class UserInfo {
        int HighQualityReadCount;
        int EditDistanceCount;
        int ClipCount;
        int MateWrongDirection;
        int MateWrongLocation;
        int SameChrTranslocation;
        int MateNoMap;
        int MateOtherChrMap;
        int LowQualityReadCount;
        int[] InsertionSizeCount;
        int BNDCount;
        int SNPCount;
        int CNVDelCount;
        int CNVDupCount;

        private UserInfo() {
        }
    }
}

