/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.methyl.rrbs.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rbio.util.FastaIO;
import org.rbio.util.GStringUtil;

public class Fragment {
    public static final String MSP1_MOTIF = "CCGG";
    public static final int ERR_NO = 2;
    public static final int ERR_YES = 1;
    private String ref;
    private String frag;
    private char strand;
    private int start;
    private List<Integer> C_pos_lst;

    private Fragment(String ref, char strand, int start, String frag) {
        this.ref = ref;
        this.strand = strand;
        this.start = start;
        this.frag = frag;
        this.C_pos_lst = new ArrayList<Integer>();
        int i = 0;
        while (i < frag.length() - 1) {
            if (frag.charAt(i) == 'C') {
                this.C_pos_lst.add(i);
            }
            ++i;
        }
    }

    public String getRef() {
        return this.ref;
    }

    public String getFragString() {
        return this.frag;
    }

    public char getStrand() {
        return this.strand;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        int res = this.start + this.frag.length() - 1;
        if (this.strand == '-') {
            res = this.start - (this.frag.length() - 1);
        }
        return res;
    }

    public int length() {
        return this.frag.length();
    }

    public List<Integer> getCList() {
        return this.C_pos_lst;
    }

    public int genomicPosByIndex(int c_idx) {
        int frag_C_pos = this.C_pos_lst.get(c_idx);
        return this.genomicPos(frag_C_pos);
    }

    public int genomicPos(int frag_C_pos) {
        int res = this.start + frag_C_pos;
        if (this.strand == '-') {
            res = this.start - frag_C_pos;
        }
        return res;
    }

    public int adapterLength(int read_len) {
        int res = read_len - this.length();
        if (res < 0) {
            res = 0;
        }
        return res;
    }

    public String context(int cpg_pos) {
        String res = "CXX";
        if (cpg_pos + 3 <= this.length()) {
            res = this.frag.substring(cpg_pos, cpg_pos + 3);
        }
        if (cpg_pos == this.length() - 2) {
            res = "CGZ";
        }
        return res;
    }

    public String getHeader() {
        return String.valueOf(this.ref) + "|" + this.strand + "|" + this.start;
    }

    public static Map<String, Fragment> build(String ref_fa, int min_frag_len, int max_frag_len) throws Exception {
        Map<String, StringBuilder> fa_tab = FastaIO.read(ref_fa, 100000000);
        Pattern pattern = Pattern.compile(MSP1_MOTIF, 2);
        LinkedHashMap<String, Fragment> frag_tab = new LinkedHashMap<String, Fragment>();
        int cur_start = -1;
        for (String ref : fa_tab.keySet()) {
            StringBuilder ref_str = fa_tab.get(ref);
            Matcher matcher = pattern.matcher(ref_str);
            while (matcher.find()) {
                int frag_len;
                if (cur_start != -1 && (frag_len = matcher.start() + 2 - (cur_start + 1) + 1) >= min_frag_len && frag_len <= max_frag_len) {
                    int pos_start = cur_start + 1;
                    String pos_frag_str = ref_str.substring(pos_start, matcher.start() + 3).toUpperCase();
                    Fragment pos_frag = new Fragment(ref, '+', pos_start, pos_frag_str);
                    frag_tab.put(pos_frag.getHeader(), pos_frag);
                    int neg_start = matcher.start() + 2;
                    String neg_frag_str = GStringUtil.reverseComplement(pos_frag_str);
                    Fragment neg_frag = new Fragment(ref, '-', neg_start, neg_frag_str);
                    frag_tab.put(neg_frag.getHeader(), neg_frag);
                }
                cur_start = matcher.start();
            }
        }
        return frag_tab;
    }

    public static void write(Map<String, Fragment> frag_tab, String prefix, int read_len, String adapter_3, String adapter_5) throws Exception {
        BufferedWriter obuf = new BufferedWriter(new FileWriter(String.valueOf(prefix) + ".rrbs.frag.fa"));
        BufferedWriter ombuf = new BufferedWriter(new FileWriter(String.valueOf(prefix) + ".rrbs.frag.meth.fa"));
        for (String header : frag_tab.keySet()) {
            String frag_str;
            Fragment frag = frag_tab.get(header);
            String frag_meth_str = frag_str = frag.getFragString();
            int adapter_len = frag.adapterLength(read_len);
            if (adapter_len > 0) {
                String adapt3 = adapter_3.substring(0, adapter_len);
                String adapt5 = GStringUtil.reverseComplement(adapter_5.substring(0, adapter_len));
                frag_meth_str = String.valueOf(adapt5) + frag_meth_str + adapt3;
            }
            FastaIO.writeRecord(obuf, header, new StringBuilder(frag_str), 100);
            FastaIO.writeRecord(ombuf, header, new StringBuilder(frag_meth_str.replace('C', 'T')), 100);
        }
        ombuf.close();
        obuf.close();
    }

    public static Map<String, Fragment> read(String fname) throws Exception {
        Map<String, StringBuilder> fa_tab = FastaIO.read(fname, 1000);
        LinkedHashMap<String, Fragment> frag_tab = new LinkedHashMap<String, Fragment>();
        for (String header : fa_tab.keySet()) {
            String[] arr = header.split("\\|");
            String ref = arr[0];
            char strand = arr[1].charAt(0);
            int start = Integer.parseInt(arr[2]);
            StringBuilder frag_str = fa_tab.get(header);
            Fragment frag = new Fragment(ref, strand, start, frag_str.toString());
            frag_tab.put(frag.getHeader(), frag);
        }
        return frag_tab;
    }
}

