/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.activeregion;

import java.util.ArrayList;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.HasGenomeLocation;
import org.broadinstitute.sting.utils.clipping.ReadClipper;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ActiveRegion
implements HasGenomeLocation,
Comparable<ActiveRegion> {
    private final ArrayList<GATKSAMRecord> reads = new ArrayList();
    private final GenomeLoc activeRegionLoc;
    private final GenomeLoc extendedLoc;
    private final int extension;
    private GenomeLoc fullExtentReferenceLoc = null;
    private final GenomeLocParser genomeLocParser;
    public final boolean isActive;

    public ActiveRegion(GenomeLoc activeRegionLoc, boolean isActive, GenomeLocParser genomeLocParser, int extension) {
        this.activeRegionLoc = activeRegionLoc;
        this.isActive = isActive;
        this.genomeLocParser = genomeLocParser;
        this.extension = extension;
        this.fullExtentReferenceLoc = this.extendedLoc = genomeLocParser.createGenomeLoc(activeRegionLoc.getContig(), activeRegionLoc.getStart() - extension, activeRegionLoc.getStop() + extension);
    }

    public String toString() {
        return "ActiveRegion " + this.activeRegionLoc.toString();
    }

    public void add(GATKSAMRecord read) {
        this.fullExtentReferenceLoc = this.fullExtentReferenceLoc.union(this.genomeLocParser.createGenomeLoc(read));
        this.reads.add(read);
    }

    public void hardClipToActiveRegion() {
        ArrayList<GATKSAMRecord> clippedReads = ReadClipper.hardClipToRegion(this.reads, this.activeRegionLoc.getStart(), this.activeRegionLoc.getStop());
        this.reads.clear();
        this.reads.addAll(clippedReads);
    }

    public ArrayList<GATKSAMRecord> getReads() {
        return this.reads;
    }

    public byte[] getActiveRegionReference(IndexedFastaSequenceFile referenceReader) {
        return this.getActiveRegionReference(referenceReader, 0);
    }

    public byte[] getActiveRegionReference(IndexedFastaSequenceFile referenceReader, int padding) {
        return referenceReader.getSubsequenceAt(this.activeRegionLoc.getContig(), Math.max(1, this.activeRegionLoc.getStart() - padding), Math.min(referenceReader.getSequenceDictionary().getSequence(this.activeRegionLoc.getContig()).getSequenceLength(), this.activeRegionLoc.getStop() + padding)).getBases();
    }

    public byte[] getFullReference(IndexedFastaSequenceFile referenceReader) {
        return this.getFullReference(referenceReader, 0);
    }

    public byte[] getFullReference(IndexedFastaSequenceFile referenceReader, int padding) {
        return referenceReader.getSubsequenceAt(this.fullExtentReferenceLoc.getContig(), Math.max(1, this.fullExtentReferenceLoc.getStart() - padding), Math.min(referenceReader.getSequenceDictionary().getSequence(this.fullExtentReferenceLoc.getContig()).getSequenceLength(), this.fullExtentReferenceLoc.getStop() + padding)).getBases();
    }

    @Override
    public int compareTo(ActiveRegion other) {
        return this.getLocation().compareTo(other.getLocation());
    }

    @Override
    public GenomeLoc getLocation() {
        return this.activeRegionLoc;
    }

    public GenomeLoc getExtendedLoc() {
        return this.extendedLoc;
    }

    public GenomeLoc getReferenceLoc() {
        return this.fullExtentReferenceLoc;
    }

    public int getExtension() {
        return this.extension;
    }

    public int size() {
        return this.reads.size();
    }

    public void clearReads() {
        this.reads.clear();
    }

    public void remove(GATKSAMRecord read) {
        this.reads.remove(read);
    }

    public void removeAll(ArrayList<GATKSAMRecord> readsToRemove) {
        this.reads.removeAll(readsToRemove);
    }

    public boolean equalExceptReads(ActiveRegion other) {
        if (!this.activeRegionLoc.equals(other.activeRegionLoc)) {
            return false;
        }
        if (this.isActive != other.isActive) {
            return false;
        }
        if (this.genomeLocParser != other.genomeLocParser) {
            return false;
        }
        if (this.extension != other.extension) {
            return false;
        }
        return this.extendedLoc.equals(other.extendedLoc);
    }
}

