/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import org.broadinstitute.sting.utils.QualityUtils;

public class Datum {
    long numObservations;
    long numMismatches;
    private static final int SMOOTHING_CONSTANT = 1;

    public Datum() {
        this.numObservations = 0L;
        this.numMismatches = 0L;
    }

    public Datum(long numObservations, long numMismatches) {
        this.numObservations = numObservations;
        this.numMismatches = numMismatches;
    }

    synchronized void increment(long incObservations, long incMismatches) {
        this.numObservations += incObservations;
        this.numMismatches += incMismatches;
    }

    double empiricalQualDouble() {
        double doubleMismatches = this.numMismatches + 1L;
        double doubleObservations = this.numObservations + 1L;
        double empiricalQual = -10.0 * Math.log10(doubleMismatches / doubleObservations);
        return Math.min(empiricalQual, 93.0);
    }

    byte empiricalQualByte() {
        double doubleMismatches = this.numMismatches;
        double doubleObservations = this.numObservations;
        return QualityUtils.probToQual(1.0 - doubleMismatches / doubleObservations);
    }

    public String toString() {
        return String.format("%d,%d,%d", this.numObservations, this.numMismatches, (int)this.empiricalQualByte());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Datum)) {
            return false;
        }
        Datum other = (Datum)o;
        return this.numMismatches == other.numMismatches && this.numObservations == other.numObservations;
    }
}

