/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class DepthPerAlleleBySample
extends GenotypeAnnotation
implements StandardAnnotation {
    private static final String REF_ALLELE = "REF";
    private static final String DEL = "DEL";

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, AlignmentContext stratifiedContext, VariantContext vc, Genotype g) {
        if (g == null || !g.isCalled()) {
            return null;
        }
        if (vc.isSNP()) {
            return this.annotateSNP(stratifiedContext, vc);
        }
        if (vc.isIndel()) {
            return this.annotateIndel(stratifiedContext, vc);
        }
        return null;
    }

    private Map<String, Object> annotateSNP(AlignmentContext stratifiedContext, VariantContext vc) {
        if (!stratifiedContext.hasBasePileup()) {
            return null;
        }
        HashMap<Byte, Integer> alleleCounts = new HashMap<Byte, Integer>();
        for (Allele allele : vc.getAlleles()) {
            alleleCounts.put(allele.getBases()[0], 0);
        }
        ReadBackedPileup pileup = stratifiedContext.getBasePileup();
        for (PileupElement p : pileup) {
            if (!alleleCounts.containsKey(p.getBase())) continue;
            alleleCounts.put(p.getBase(), (Integer)alleleCounts.get(p.getBase()) + 1);
        }
        Integer[] counts = new Integer[alleleCounts.size()];
        counts[0] = (Integer)alleleCounts.get(vc.getReference().getBases()[0]);
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            counts[i + 1] = (Integer)alleleCounts.get(vc.getAlternateAllele(i).getBases()[0]);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), counts);
        return map;
    }

    private Map<String, Object> annotateIndel(AlignmentContext stratifiedContext, VariantContext vc) {
        if (!stratifiedContext.hasBasePileup()) {
            return null;
        }
        ReadBackedPileup pileup = stratifiedContext.getBasePileup();
        if (pileup == null) {
            return null;
        }
        HashMap<String, Integer> alleleCounts = new HashMap<String, Integer>();
        alleleCounts.put(REF_ALLELE, 0);
        Allele refAllele = vc.getReference();
        for (Allele allele : vc.getAlternateAlleles()) {
            if (allele.isNoCall()) continue;
            alleleCounts.put(this.getAlleleRepresentation(allele), 0);
        }
        for (PileupElement p : pileup) {
            String b;
            if (p.isBeforeInsertion()) {
                b = p.getEventBases();
                if (!alleleCounts.containsKey(b)) continue;
                alleleCounts.put(b, (Integer)alleleCounts.get(b) + 1);
                continue;
            }
            if (p.isBeforeDeletionStart()) {
                if (p.getEventLength() != refAllele.length()) continue;
                b = DEL;
                if (!alleleCounts.containsKey(DEL)) continue;
                alleleCounts.put(DEL, (Integer)alleleCounts.get(DEL) + 1);
                continue;
            }
            if (p.getRead().getAlignmentEnd() <= vc.getStart()) continue;
            alleleCounts.put(REF_ALLELE, (Integer)alleleCounts.get(REF_ALLELE) + 1);
        }
        Integer[] counts = new Integer[alleleCounts.size()];
        counts[0] = (Integer)alleleCounts.get(REF_ALLELE);
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            counts[i + 1] = (Integer)alleleCounts.get(this.getAlleleRepresentation(vc.getAlternateAllele(i)));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), counts);
        return map;
    }

    private String getAlleleRepresentation(Allele allele) {
        if (allele.isNull()) {
            return DEL;
        }
        return allele.getBaseString();
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AD");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFFormatHeaderLine(this.getKeyNames().get(0), VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Allelic depths for the ref and alt alleles in the order listed"));
    }
}

