/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.packing;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.broadinstitute.sting.alignment.reference.packing.PackUtils;

public class UnsignedIntPackedInputStream {
    private final FileInputStream targetInputStream;
    private final FileChannel targetInputChannel;
    private final ByteOrder byteOrder;
    private final int bytesPerInteger = PackUtils.bitsInType(Integer.class) / 8;

    public UnsignedIntPackedInputStream(File inputFile, ByteOrder byteOrder) throws IOException {
        this(new FileInputStream(inputFile), byteOrder);
    }

    public UnsignedIntPackedInputStream(FileInputStream inputStream, ByteOrder byteOrder) {
        this.targetInputStream = inputStream;
        this.targetInputChannel = inputStream.getChannel();
        this.byteOrder = byteOrder;
    }

    public long read() throws IOException {
        long[] data = new long[1];
        this.read(data);
        return data[0];
    }

    public void read(long[] data) throws IOException {
        this.read(data, 0, data.length);
    }

    public void read(long[] data, int offset, int length) throws IOException {
        ByteBuffer readBuffer = ByteBuffer.allocate(this.bytesPerInteger * length).order(this.byteOrder);
        this.targetInputChannel.read(readBuffer, this.targetInputChannel.position());
        readBuffer.flip();
        this.targetInputChannel.position(this.targetInputChannel.position() + (long)readBuffer.remaining());
        int i = 0;
        while (i < length) {
            data[offset + i++] = (long)readBuffer.getInt() & 0xFFFFFFFFL;
        }
    }

    public void close() throws IOException {
        this.targetInputStream.close();
    }
}

