/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.gcf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.broadinstitute.sting.utils.gcf.GCF;
import org.broadinstitute.sting.utils.gcf.GCFHeader;
import org.broadinstitute.sting.utils.gcf.GCFHeaderBuilder;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;

public class GCFGenotype {
    private byte gq;
    private int gt;
    private int dp;
    private int[] ad;
    private byte[] pl;

    public GCFGenotype(GCFHeaderBuilder GCFHeaderBuilder2, List<Allele> allAlleles, Genotype genotype) {
        this.gq = GCF.qualToByte(genotype.getPhredScaledQual());
        this.gt = GCFGenotype.encodeAlleles(genotype.getAlleles(), allAlleles);
        this.dp = genotype.getAttributeAsInt("DP", 0);
        int nAlleles = allAlleles.size();
        this.ad = new int[nAlleles];
        int npls = this.nAllelesToNPls(nAlleles);
        this.pl = new byte[npls];
    }

    private int nAllelesToNPls(int nAlleles) {
        return nAlleles * (nAlleles + 1) / 2;
    }

    public GCFGenotype(GCF GCF2, DataInputStream inputStream) throws IOException {
        int gqInt = inputStream.readUnsignedByte();
        this.gq = (byte)gqInt;
        this.gt = inputStream.readInt();
        this.dp = inputStream.readInt();
        this.ad = GCF.readIntArray(inputStream, GCF2.getNAlleles());
        this.pl = GCF.readByteArray(inputStream, this.nAllelesToNPls(GCF2.getNAlleles()));
    }

    protected int sizeInBytes() {
        return 9 + 4 * this.ad.length + 1 * this.pl.length;
    }

    public Genotype decode(String sampleName, GCFHeader header, GCF GCF2, List<Allele> alleleIndex) {
        List<Allele> alleles = GCFGenotype.decodeAlleles(this.gt, alleleIndex);
        double log10PError = (double)this.gq / -10.0;
        Set<String> filters = Collections.emptySet();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("DP", this.dp);
        attributes.put("AD", this.ad);
        attributes.put("PL", this.pl);
        return new Genotype(sampleName, alleles, log10PError, filters, attributes, false);
    }

    private static int encodeAlleles(List<Allele> gtList, List<Allele> allAlleles) {
        int nAlleles = gtList.size();
        if (nAlleles > 4) {
            throw new IllegalArgumentException("encodeAlleles doesn't support more than 4 alt alleles, but I saw " + gtList);
        }
        int gtInt = 0;
        for (int i = 0; i < nAlleles; ++i) {
            int bitOffset = i * 8;
            int allelei = GCFGenotype.getAlleleIndex(gtList.get(i), allAlleles);
            int gti = allelei + 1 << bitOffset;
            gtInt |= gti;
        }
        return gtInt;
    }

    private static int getAlleleIndex(Allele q, List<Allele> allAlleles) {
        if (q.isNoCall()) {
            return 254;
        }
        for (int i = 0; i < allAlleles.size(); ++i) {
            if (!q.equals(allAlleles.get(i))) continue;
            return i;
        }
        throw new IllegalStateException("getAlleleIndex passed allele not in map! allele " + q + " allAlleles " + allAlleles);
    }

    private static List<Allele> decodeAlleles(int gtInt, List<Allele> alleleIndex) {
        int gi;
        ArrayList<Allele> alleles = new ArrayList<Allele>(4);
        for (int i = 0; i < 32 && (gi = (gtInt & 255 << i) >> i) != 0; i += 8) {
            int allelei = gi - 1;
            alleles.add(allelei == 254 ? Allele.NO_CALL : alleleIndex.get(allelei));
        }
        return alleles;
    }

    public int write(DataOutputStream outputStream) throws IOException {
        int startSize = outputStream.size();
        outputStream.writeByte(this.gq);
        outputStream.writeInt(this.gt);
        outputStream.writeInt(this.dp);
        GCF.writeIntArray(this.ad, outputStream, false);
        GCF.writeByteArray(this.pl, outputStream, false);
        return outputStream.size() - startSize;
    }
}

