/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.concurrent.ConcurrentHashMap;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(description="Computes different estimates of theta based on variant sites and genotypes")
public class ThetaVariantEvaluator
extends VariantEvaluator {
    @DataPoint(description="Average heterozygosity at variant sites; note that missing genotypes are ignored when computing this value", format="%.8f")
    public double avgHet = 0.0;
    @DataPoint(description="Average pairwise differences at aligned sequences; averaged over both number of sequeneces and number of variant sites; note that missing genotypes are ignored when computing this value", format="%.8f")
    public double avgAvgDiffs = 0.0;
    @DataPoint(description="Sum of heterozygosity over all variant sites; divide this by total target to get estimate of per base theta", format="%.8f")
    public double totalHet = 0.0;
    @DataPoint(description="Sum of pairwise diffs over all variant sites; divide this by total target to get estimate of per base theta", format="%.8f")
    public double totalAvgDiffs = 0.0;
    @DataPoint(description="Theta for entire region estimated based on number of segregating sites; divide ths by total target to get estimate of per base theta", format="%.8f")
    public double thetaRegionNumSites = 0.0;
    double numSites = 0.0;

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public void update1(VariantContext vc, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (vc == null || !vc.isSNP() || this.getWalker().ignoreAC0Sites() && vc.isMonomorphicInSamples()) {
            return;
        }
        ConcurrentHashMap<String, Integer> alleleCounts = new ConcurrentHashMap<String, Integer>();
        int numHetsHere = 0;
        float numGenosHere = 0.0f;
        int numIndsHere = 0;
        for (Genotype genotype : vc.getGenotypes()) {
            ++numIndsHere;
            if (genotype.isNoCall()) continue;
            if (genotype.isHet()) {
                ++numHetsHere;
            }
            numGenosHere += 1.0f;
            for (Allele allele : genotype.getAlleles()) {
                if (!allele.isNonNull() || !allele.isCalled()) continue;
                String alleleString = allele.toString();
                alleleCounts.putIfAbsent(alleleString, 0);
                alleleCounts.put(alleleString, (Integer)alleleCounts.get(alleleString) + 1);
            }
        }
        if (numGenosHere > 0.0f) {
            this.numSites += 1.0;
            this.totalHet += (double)((float)numHetsHere / numGenosHere);
            float harmonicFactor = 0.0f;
            for (int i = 1; i <= numIndsHere; ++i) {
                harmonicFactor = (float)((double)harmonicFactor + 1.0 / (double)i);
            }
            this.thetaRegionNumSites += 1.0 / (double)harmonicFactor;
            float numPairwise = 0.0f;
            float numDiffs = 0.0f;
            for (String allele1 : alleleCounts.keySet()) {
                int allele1Count = (Integer)alleleCounts.get(allele1);
                for (String allele2 : alleleCounts.keySet()) {
                    if (allele1.compareTo(allele2) < 0) continue;
                    if (allele1.compareTo(allele2) == 0) {
                        numPairwise = (float)((double)numPairwise + (double)(allele1Count * (allele1Count - 1)) * 0.5);
                        continue;
                    }
                    int allele2Count = (Integer)alleleCounts.get(allele2);
                    numPairwise += (float)(allele1Count * allele2Count);
                    numDiffs += (float)(allele1Count * allele2Count);
                }
            }
            if (numPairwise > 0.0f) {
                this.totalAvgDiffs += (double)(numDiffs / numPairwise);
            }
        }
    }

    @Override
    public void finalizeEvaluation() {
        if (this.numSites > 0.0) {
            this.avgHet = this.totalHet / this.numSites;
            this.avgAvgDiffs = this.totalAvgDiffs / this.numSites;
        }
    }
}

