/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Molten;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(name="Genotype Concordance Detailed", description="Determine the genotype concordance between the genotypes in difference tracks, and  concordance statistics")
public class GenotypeConcordance
extends VariantEvaluator {
    protected static final Logger logger = Logger.getLogger(GenotypeConcordance.class);
    @Molten(variableFormat="%s", valueFormat="%s")
    public final Map<Object, Object> map = new TreeMap<Object, Object>();
    private final long[][] truthByCalledGenotypeCounts;

    public GenotypeConcordance() {
        int nGenotypeTypes = Genotype.Type.values().length;
        this.truthByCalledGenotypeCounts = new long[nGenotypeTypes][nGenotypeTypes];
    }

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public void update2(VariantContext eval, VariantContext validation, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (validation != null && !validation.hasGenotypes() || eval == null && !GenotypeConcordance.isValidVC(validation)) {
            return;
        }
        boolean validationIsValidVC = GenotypeConcordance.isValidVC(validation);
        if (eval != null) {
            for (Genotype g : eval.getGenotypes()) {
                String sample = g.getSampleName();
                Genotype.Type called = g.getType();
                Genotype.Type truth = !validationIsValidVC || !validation.hasGenotype(sample) ? Genotype.Type.NO_CALL : validation.getGenotype(sample).getType();
                this.incrValue(truth, called);
            }
        } else {
            Genotype.Type called = Genotype.Type.NO_CALL;
            for (Genotype g : validation.getGenotypes()) {
                Genotype.Type truth = g.getType();
                this.incrValue(truth, called);
            }
        }
    }

    private static boolean isValidVC(VariantContext vc) {
        return vc != null && !vc.isFiltered();
    }

    private void incrValue(Genotype.Type truth, Genotype.Type called) {
        long[] lArray = this.truthByCalledGenotypeCounts[truth.ordinal()];
        int n = called.ordinal();
        lArray[n] = lArray[n] + 1L;
    }

    private long count(Genotype.Type truth, Genotype.Type called) {
        return this.truthByCalledGenotypeCounts[truth.ordinal()][called.ordinal()];
    }

    private long count(EnumSet<Genotype.Type> truth, Genotype.Type called) {
        return this.count(truth, EnumSet.of(called));
    }

    private long count(Genotype.Type truth, EnumSet<Genotype.Type> called) {
        return this.count(EnumSet.of(truth), called);
    }

    private long count(EnumSet<Genotype.Type> truth, EnumSet<Genotype.Type> called) {
        long sum = 0L;
        for (Genotype.Type truth1 : truth) {
            for (Genotype.Type called1 : called) {
                sum += this.count(truth1, called1);
            }
        }
        return sum;
    }

    private long countDiag(EnumSet<Genotype.Type> d1) {
        long sum = 0L;
        for (Genotype.Type e1 : d1) {
            sum += this.truthByCalledGenotypeCounts[e1.ordinal()][e1.ordinal()];
        }
        return sum;
    }

    @Override
    public void finalizeEvaluation() {
        String field;
        EnumSet<Genotype.Type> allVariantGenotypes = EnumSet.of(Genotype.Type.HOM_VAR, Genotype.Type.HET);
        EnumSet<Genotype.Type> allCalledGenotypes = EnumSet.of(Genotype.Type.HOM_VAR, Genotype.Type.HET, Genotype.Type.HOM_REF);
        EnumSet<Genotype.Type> allGenotypes = EnumSet.allOf(Genotype.Type.class);
        for (Genotype.Type truth : Genotype.Type.values()) {
            for (Genotype.Type called : Genotype.Type.values()) {
                String field2 = String.format("n_true_%s_called_%s", new Object[]{truth, called});
                Long value = this.count(truth, called);
                this.map.put(field2, value.toString());
            }
        }
        for (Genotype.Type called : Genotype.Type.values()) {
            field = String.format("total_called_%s", new Object[]{called});
            Long value = this.count(allGenotypes, called);
            this.map.put(field, value.toString());
        }
        for (Genotype.Type truth : Genotype.Type.values()) {
            field = String.format("total_true_%s", new Object[]{truth});
            Long value = this.count(truth, allGenotypes);
            this.map.put(field, value.toString());
        }
        for (Genotype.Type genotype : Genotype.Type.values()) {
            field = String.format("percent_%s_called_%s", new Object[]{genotype, genotype});
            long numer = this.count(genotype, genotype);
            long denom = this.count(EnumSet.of(genotype), allGenotypes);
            this.map.put(field, Utils.formattedPercent(numer, denom));
        }
        String field3 = "percent_non_reference_sensitivity";
        long numer = this.count(allVariantGenotypes, allVariantGenotypes);
        long denom = this.count(allVariantGenotypes, allGenotypes);
        this.map.put("percent_non_reference_sensitivity", Utils.formattedPercent(numer, denom));
        field3 = "percent_overall_genotype_concordance";
        numer = this.countDiag(allCalledGenotypes);
        denom = this.count(allCalledGenotypes, allCalledGenotypes);
        this.map.put("percent_overall_genotype_concordance", Utils.formattedPercent(numer, denom));
        field3 = "percent_non_reference_discrepancy_rate";
        long homrefConcords = this.count(Genotype.Type.HOM_REF, Genotype.Type.HOM_REF);
        long allNoHomRef = this.count(allCalledGenotypes, allCalledGenotypes) - homrefConcords;
        long numer2 = allNoHomRef - this.countDiag(allVariantGenotypes);
        long denom2 = this.count(allCalledGenotypes, allCalledGenotypes) - homrefConcords;
        this.map.put("percent_non_reference_discrepancy_rate", Utils.formattedPercent(numer2, denom2));
    }
}

