/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.tribble.readers.AsciiLineReader;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffElement;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffNode;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffableReader;
import org.broadinstitute.sting.utils.codecs.vcf.AbstractVCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFIDHeaderLine;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFDiffableReader
implements DiffableReader {
    private static Logger logger = Logger.getLogger(VCFDiffableReader.class);

    @Override
    public String getName() {
        return "VCF";
    }

    @Override
    public DiffElement readFromFile(File file, int maxElementsToRead) {
        DiffNode root = DiffNode.rooted(file.getName());
        try {
            AsciiLineReader lineReader = new AsciiLineReader(new FileInputStream(file));
            String version = lineReader.readLine();
            root.add("VERSION", version);
            lineReader.close();
            lineReader = new AsciiLineReader(new FileInputStream(file));
            VCFCodec vcfCodec = new VCFCodec();
            VCFHeader header = (VCFHeader)vcfCodec.readHeader(lineReader);
            for (VCFHeaderLine headerLine : header.getMetaData()) {
                String key = headerLine.getKey();
                if (headerLine instanceof VCFIDHeaderLine) {
                    key = key + "_" + ((VCFIDHeaderLine)((Object)headerLine)).getID();
                }
                if (root.hasElement(key)) {
                    logger.warn("Skipping duplicate header line: file=" + file + " line=" + headerLine.toString());
                    continue;
                }
                root.add(key, headerLine.toString());
            }
            String line = lineReader.readLine();
            int count = 0;
            int nRecordsAtPos = 1;
            String prevName = "";
            while (line != null && (count++ <= maxElementsToRead || maxElementsToRead == -1)) {
                VariantContext vc = (VariantContext)vcfCodec.decode(line);
                String name = vc.getChr() + ":" + vc.getStart();
                if (name.equals(prevName)) {
                    name = name + "_" + ++nRecordsAtPos;
                } else {
                    prevName = name;
                }
                DiffNode vcRoot = DiffNode.empty(name, root);
                vcRoot.add("CHROM", vc.getChr());
                vcRoot.add("POS", vc.getStart());
                vcRoot.add("ID", vc.getID());
                vcRoot.add("REF", vc.getReference());
                vcRoot.add("ALT", vc.getAlternateAlleles());
                vcRoot.add("QUAL", vc.hasLog10PError() ? Double.valueOf(vc.getLog10PError() * -10.0) : ".");
                vcRoot.add("FILTER", vc.getFilters());
                for (Map.Entry<String, Object> attribute : vc.getAttributes().entrySet()) {
                    if (attribute.getKey().startsWith("_")) continue;
                    vcRoot.add(attribute.getKey(), attribute.getValue());
                }
                for (Genotype g : vc.getGenotypes()) {
                    DiffNode gRoot = DiffNode.empty(g.getSampleName(), vcRoot);
                    gRoot.add("GT", g.getGenotypeString());
                    gRoot.add("GQ", g.hasLog10PError() ? Double.valueOf(g.getLog10PError() * -10.0) : ".");
                    for (Map.Entry<String, Object> attribute : g.getAttributes().entrySet()) {
                        if (attribute.getKey().startsWith("_")) continue;
                        gRoot.add(attribute.getKey(), attribute.getValue());
                    }
                    vcRoot.add(gRoot);
                }
                root.add(vcRoot);
                line = lineReader.readLine();
            }
            lineReader.close();
        }
        catch (IOException e) {
            return null;
        }
        return root.getBinding();
    }

    @Override
    public boolean canRead(File file) {
        return AbstractVCFCodec.canDecodeFile(file.getPath(), "##fileformat=VCFv4");
    }
}

