/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.annotation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.picard.annotation.AnnotationException;
import net.sf.picard.annotation.LocusFunction;
import net.sf.picard.util.Interval;
import net.sf.samtools.util.CoordMath;

public class Gene
extends Interval
implements Iterable<Transcript> {
    private final Map<String, Transcript> transcripts = new HashMap<String, Transcript>();

    public Gene(String sequence, int start, int end, boolean negative, String name) {
        super(sequence, start, end, negative, name);
    }

    public Transcript addTranscript(String name, int transcriptionStart, int transcriptionEnd, int codingStart, int codingEnd, int numExons) {
        if (this.transcripts.containsKey(name)) {
            throw new AnnotationException("Transcript " + name + " for gene " + this.getName() + " appears more than once");
        }
        Transcript tx = new Transcript(name, transcriptionStart, transcriptionEnd, codingStart, codingEnd, numExons);
        this.transcripts.put(name, tx);
        return tx;
    }

    @Override
    public Iterator<Transcript> iterator() {
        return this.transcripts.values().iterator();
    }

    public class Transcript {
        public final String name;
        public final int transcriptionStart;
        public final int transcriptionEnd;
        public final int codingStart;
        public final int codingEnd;
        public final Exon[] exons;
        private int length;

        public Transcript(String name, int transcriptionStart, int transcriptionEnd, int codingStart, int codingEnd, int numExons) {
            this.name = name;
            this.transcriptionStart = transcriptionStart;
            this.transcriptionEnd = transcriptionEnd;
            this.codingStart = codingStart;
            this.codingEnd = codingEnd;
            this.exons = new Exon[numExons];
        }

        public Exon addExon(int start, int end) {
            for (int i = 0; i < this.exons.length; ++i) {
                if (this.exons[i] != null) continue;
                this.exons[i] = new Exon(start, end);
                this.length += CoordMath.getLength(start, end);
                return this.exons[i];
            }
            throw new IllegalStateException("Attempting to add more exons that exist for transcript.");
        }

        public int start() {
            return this.exons[0].start;
        }

        public int end() {
            return this.exons[this.exons.length - 1].end;
        }

        public int length() {
            return this.length;
        }

        public boolean isSoloTranscript() {
            return Gene.this.transcripts.size() == 1;
        }

        public Gene getGene() {
            return Gene.this;
        }

        public void assignLocusFunctionForRange(int start, LocusFunction[] locusFunctions) {
            for (int i = Math.max(start, this.transcriptionStart); i <= Math.min(this.transcriptionEnd, CoordMath.getEnd(start, locusFunctions.length)); ++i) {
                if (locusFunctions[i - start].ordinal() > LocusFunction.CODING.ordinal()) continue;
                LocusFunction locusFunction = this.inExon(i) ? (this.utr(i) ? LocusFunction.UTR : LocusFunction.CODING) : LocusFunction.INTRONIC;
                if (locusFunction.ordinal() <= locusFunctions[i - start].ordinal()) continue;
                locusFunctions[i - start] = locusFunction;
            }
        }

        public void addCoverageCounts(int genomeStart, int genomeEnd, int[] coverage) {
            for (int i = genomeStart; i < genomeEnd; ++i) {
                int txBase = this.getTranscriptCoordinate(i);
                if (txBase <= 0) continue;
                int n = txBase - 1;
                coverage[n] = coverage[n] + 1;
            }
        }

        public int getTranscriptCoordinate(int genomeCoordinate) {
            int exonOffset = 0;
            for (Exon e : this.exons) {
                if (genomeCoordinate >= e.start && genomeCoordinate <= e.end) {
                    return genomeCoordinate - e.start + 1 + exonOffset;
                }
                exonOffset += CoordMath.getLength(e.start, e.end);
            }
            return -1;
        }

        private boolean utr(int locus) {
            return locus < this.codingStart || locus > this.codingEnd;
        }

        private boolean inExon(int locus) {
            for (int i = 0; i < this.exons.length; ++i) {
                Exon exon = this.exons[i];
                if (exon.start > locus) {
                    return false;
                }
                if (!this.inRange(exon.start, exon.end, locus)) continue;
                return true;
            }
            return false;
        }

        private boolean inRange(int start, int end, int locus) {
            return locus >= start && locus <= end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Transcript that = (Transcript)o;
            if (this.codingEnd != that.codingEnd) {
                return false;
            }
            if (this.codingStart != that.codingStart) {
                return false;
            }
            if (this.transcriptionEnd != that.transcriptionEnd) {
                return false;
            }
            if (this.transcriptionStart != that.transcriptionStart) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.transcriptionStart;
            result = 31 * result + this.transcriptionEnd;
            result = 31 * result + this.codingStart;
            result = 31 * result + this.codingEnd;
            return result;
        }

        public class Exon {
            public final int start;
            public final int end;

            public Exon(int start, int end) {
                this.start = start;
                this.end = end;
            }
        }
    }
}

