/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.rna.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class FragLengthStats {
    public static void main(String[] args) throws Exception {
        ArrayList<File> frag_flst = new ArrayList<File>();
        File[] fileArray = new File(args[0]).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("frag-len.txt")) {
                frag_flst.add(file);
            }
            ++n2;
        }
        String line = null;
        LinkedHashMap<String, FragStats> frag_map = new LinkedHashMap<String, FragStats>();
        for (File file : frag_flst) {
            FragStats frag = new FragStats();
            frag_map.put(file.getName().split("\\.cutadapt")[0], frag);
            BufferedReader ibuf = new BufferedReader(new FileReader(file));
            while ((line = ibuf.readLine()) != null) {
                if (!line.startsWith("MEDIAN_INSERT_SIZE")) continue;
                String[] arr = ibuf.readLine().split("\t");
                frag.median_len = Double.parseDouble(arr[0]);
                frag.mean_len = Double.parseDouble(arr[4]);
                frag.std_len = Double.parseDouble(arr[5]);
            }
            ibuf.close();
            String align_fanme = file.getPath().replaceFirst("frag-len.txt", "align-summary.txt");
            ibuf = new BufferedReader(new FileReader(align_fanme));
            while ((line = ibuf.readLine()) != null) {
                String[] arr = line.split("\t");
                if (line.startsWith("FIRST_OF_PAIR")) {
                    frag.read1_len = Double.parseDouble(arr[15]);
                    continue;
                }
                if (!line.startsWith("SECOND_OF_PAIR")) continue;
                frag.read2_len = Double.parseDouble(arr[15]);
            }
            ibuf.close();
        }
        BufferedWriter obuf1 = new BufferedWriter(new FileWriter(String.valueOf(args[1]) + "_stats.txt"));
        BufferedWriter obuf2 = new BufferedWriter(new FileWriter(String.valueOf(args[1]) + ".sh"));
        obuf1.write(String.valueOf(FragStats.header()) + "\n");
        for (String samp : frag_map.keySet()) {
            System.out.println(samp);
            FragStats frag = (FragStats)frag_map.get(samp);
            obuf1.write(String.valueOf(samp) + "\t" + ((FragStats)frag_map.get(samp)).getStats() + "\n");
            if (!(frag.read2_len > 0.0)) continue;
            String odir = String.valueOf(samp) + ".cutadapt.filter_len.fastq.tophat2";
            String ifile1 = "$trim_dir/" + samp + ".cutadapt.filter_len.fastq.gz";
            String ifile2 = "$trim_dir/" + samp.replaceFirst("_R1", "_R2") + ".cutadapt.filter_len.fastq.gz";
            String cmd = "cmd=\"$tophat2 --solexa1.3-quals \\\n--read-mismatches 3 --read-gap-length 3 \\\n--read-edit-dist 3 --read-realign-edit-dist 0 \\\n--mate-inner-dist " + (int)(frag.median_len - (frag.read1_len + frag.read2_len)) + " --mate-std-dev " + (int)frag.std_len + " \\\n" + "--no-discordant --no-mixed \\\n" + "--library-type fr-unstranded \\\n" + "--GTF $gtf \\\n" + "--num-threads 5 \\\n" + "--output-dir " + odir + " $bowtie_idx " + ifile1 + " " + ifile2 + "\"";
            obuf2.write(String.valueOf(cmd) + "\n");
            obuf2.write("echo $cmd \necho \"$cmd\" | qsub -cwd -q 4-days -l h_vmem=2G -pe threaded 10 -l h_stack=40M -V\n\n");
        }
        obuf1.close();
        obuf2.close();
    }

    public static class FragStats {
        double median_len = -99999.0;
        double mean_len = -99999.0;
        double std_len = -99999.0;
        double read1_len = -99999.0;
        double read2_len = -99999.0;

        public static String header() {
            return "samp\tfrag_median\tfrag_mean\tfrag_std\tread1_len\tread2_len";
        }

        public String getStats() {
            if (this.median_len < 0.0 || this.mean_len < 0.0 || this.std_len < 0.0 || this.read1_len < 0.0) {
                System.err.println("wrong length *****************************************");
            }
            return String.valueOf(this.median_len) + "\t" + this.mean_len + "\t" + this.std_len + "\t" + this.read1_len + "\t" + this.read2_len;
        }
    }
}

