/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.paper.rrbscaller.simulator;

import java.util.Map;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.rbio.methyl.rrbs.util.Fragment;
import org.rbio.methyl.rrbs.util.MethylTable;
import org.rbio.paper.rrbscaller.simulator.RRBSReadSimulator;

public class RRBSSimulator {
    @Option(name="-ref_fa", usage="Reference fasta file", required=true)
    public String ref_fa;
    @Option(name="-min_frag_len", usage="Minimum fragment length", required=true)
    public int min_frag_len;
    @Option(name="-max_frag_len", usage="Maximum fragment length", required=true)
    public int max_frag_len;
    @Option(name="-mean_frag_len", usage="Mean fragment length", required=true)
    public int mean_frag_len;
    @Option(name="-sd_frag_len", usage="Standard deviation fragment length", required=true)
    public int sd_frag_len;
    @Option(name="-adapter_5", usage="5' adapter. Misner adapter [5']: AGATCGGAAGAGCGTCGTGTAGGGAAAGAGTGTAGATCTCGGTGGTCGCCGTATCATT", required=true)
    public String adapter_5;
    @Option(name="-adapter_3", usage="3' adapter. Misner adapter [3']: AGATCGGAAGAGCGGTTCAGCAGGAATGCCGAGACCGATCTCGTATGCCGTCTTCTGCTTG", required=true)
    public String adapter_3;
    @Option(name="-random_seed", usage="Seed for the random number generator", required=true)
    public int rnd_seed;
    @Option(name="-prob", usage="Probability for a C to be methylated", required=true)
    public double prob;
    @Option(name="-read_len", usage="Read length", required=true)
    public int read_len;
    @Option(name="-num_read", usage="Number of reads to generate", required=true)
    public int num_read;
    @Option(name="-oprefix", usage="Output prefix", required=true)
    public String oprefix;

    public static void main(String[] args) throws Exception {
        RRBSSimulator sim = new RRBSSimulator();
        CmdLineParser parser = new CmdLineParser(sim);
        try {
            parser.parseArgument(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("RRBS read simulator");
            parser.printUsage(System.err);
            return;
        }
        sim.process();
    }

    public void process() throws Exception {
        this.makeRead();
        this.callMethyl();
    }

    public void makeRead() throws Exception {
        Map<String, Fragment> frag_tab = Fragment.build(this.ref_fa, this.min_frag_len, this.max_frag_len);
        RRBSReadSimulator read_sim = new RRBSReadSimulator(this);
        read_sim.makeReads(frag_tab);
        Fragment.write(frag_tab, this.oprefix, this.read_len, this.adapter_3, this.adapter_5);
    }

    public void callMethyl() throws Exception {
        Map<String, Fragment> frag_tab = Fragment.read(String.valueOf(this.oprefix) + ".rrbs.frag.fa");
        Map<String, Map<Character, Map<Integer, MethylTable.CpG>>> cpg_se_tab = MethylTable.build(frag_tab, String.valueOf(this.oprefix) + "_stat_se.txt");
        MethylTable.write(cpg_se_tab, frag_tab, String.valueOf(this.oprefix) + "_meth_se.txt");
        Map<String, Map<Character, Map<Integer, MethylTable.CpG>>> cpg_pe_tab = MethylTable.build(frag_tab, String.valueOf(this.oprefix) + "_stat_pe.txt");
        MethylTable.write(cpg_pe_tab, frag_tab, String.valueOf(this.oprefix) + "_meth_pe.txt");
    }
}

