/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.methyl.rrbs.prep;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class FastqBisulfiteBuilder {
    public static final int FQ = 0;
    public static final int FASTQ = 1;
    public static final int GZ = 2;
    @Option(name="-in_fq", usage="Input fastq", required=true)
    private String in_fq;
    @Option(name="-out_fq", usage="Output fastq", required=true)
    private String out_fq;
    @Option(name="-end_type", usage="1 or 2", required=true)
    private int end_type;

    public static void main(String[] args) throws Exception {
        FastqBisulfiteBuilder fq_builder = new FastqBisulfiteBuilder();
        CmdLineParser parser = new CmdLineParser(fq_builder);
        try {
            parser.parseArgument(args);
            fq_builder.process();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("BS conversion of fastq [C>T for end 1 and G>A for end 2]\ninput and output files can either be .fq, .fastq or .gz");
            parser.printUsage(System.err);
            return;
        }
    }

    public void process() throws Exception {
        if (this.end_type != 1 && this.end_type != 2) {
            System.err.println("Wrong file end type [should be 1 or 2 ] : " + this.end_type);
            return;
        }
        BufferedReader ibuf = FastqBisulfiteBuilder.fqReader(this.in_fq);
        if (ibuf == null) {
            return;
        }
        BufferedWriter obuf = FastqBisulfiteBuilder.fqWriter(this.out_fq);
        if (obuf == null) {
            return;
        }
        String line = null;
        while ((line = ibuf.readLine()) != null) {
            String rheader = line;
            String read = ibuf.readLine();
            String qheader = ibuf.readLine();
            String qual = ibuf.readLine();
            if (this.end_type == 1) {
                read = read.replace('C', 'T');
            } else if (this.end_type == 2) {
                read = read.replace('G', 'A');
            }
            obuf.write(String.valueOf(rheader) + "\n");
            obuf.write(String.valueOf(read) + "\n");
            obuf.write(String.valueOf(qheader) + "\n");
            obuf.write(String.valueOf(qual) + "\n");
        }
        ibuf.close();
        obuf.close();
    }

    public static int fqExt(String fname) {
        int res = -1;
        String[] arr = fname.split("\\.");
        String ext = arr[arr.length - 1];
        if (ext.toLowerCase().compareTo("fq") == 0) {
            res = 0;
        } else if (ext.toLowerCase().compareTo("fastq") == 0) {
            res = 1;
        } else if (ext.toLowerCase().compareTo("gz") == 0) {
            res = 2;
        } else {
            System.err.println("Cannot recognize fastq extension \n should be .fq or .fqstq or .gz");
        }
        return res;
    }

    public static BufferedReader fqReader(String fname) throws Exception {
        BufferedReader ibuf = null;
        int ext_in = FastqBisulfiteBuilder.fqExt(fname);
        if (ext_in == 0 || ext_in == 1) {
            ibuf = new BufferedReader(new FileReader(fname));
        } else if (ext_in == 2) {
            GZIPInputStream igzip = new GZIPInputStream(new FileInputStream(fname));
            ibuf = new BufferedReader(new InputStreamReader(igzip));
        }
        return ibuf;
    }

    public static BufferedWriter fqWriter(String fname) throws Exception {
        BufferedWriter obuf = null;
        int ext_out = FastqBisulfiteBuilder.fqExt(fname);
        if (ext_out == 0 || ext_out == 1) {
            obuf = new BufferedWriter(new FileWriter(fname));
        } else if (ext_out == 2) {
            GZIPOutputStream ogzip = new GZIPOutputStream(new FileOutputStream(fname));
            obuf = new BufferedWriter(new OutputStreamWriter(ogzip));
        }
        return obuf;
    }
}

