/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BitSetUtils {
    private static final int MAX_DNA_CONTEXT = 31;
    private static final byte NBITS_LONG_REPRESENTATION = 64;
    private static final byte NBITS_SHORT_REPRESENTATION = 16;
    static final long[] combinationsPerLength = new long[32];

    public static long longFrom(BitSet bitSet) {
        return BitSetUtils.longFrom(bitSet, 64);
    }

    public static short shortFrom(BitSet bitSet) {
        return (short)BitSetUtils.longFrom(bitSet, 16);
    }

    public static long longFrom(BitSet bitSet, int nBits) {
        long number = 0L;
        int bitIndex = bitSet.nextSetBit(0);
        while (bitIndex >= 0 && bitIndex <= nBits) {
            number |= 1L << bitIndex;
            bitIndex = bitSet.nextSetBit(bitIndex + 1);
        }
        return number;
    }

    public static BitSet bitSetFrom(long number) {
        return BitSetUtils.bitSetFrom(number, 64);
    }

    public static BitSet bitSetFrom(short number) {
        return BitSetUtils.bitSetFrom(number, 16);
    }

    public static BitSet bitSetFrom(long number, int nBits) {
        BitSet bitSet = new BitSet();
        boolean isNegative = number < 0L;
        int bitIndex = 0;
        while (number != 0L) {
            if (number % 2L != 0L) {
                bitSet.set(bitIndex);
            }
            ++bitIndex;
            number /= 2L;
        }
        if (isNegative) {
            boolean foundFirstSetBit = false;
            for (int i = bitSet.nextSetBit(0); i < nBits && i >= 0; ++i) {
                boolean bit = bitSet.get(i);
                if (!foundFirstSetBit && bit) {
                    foundFirstSetBit = true;
                    continue;
                }
                if (!foundFirstSetBit) continue;
                bitSet.flip(i);
            }
        }
        return bitSet;
    }

    public static String dnaFrom(BitSet bitSet) {
        long number = BitSetUtils.longFrom(bitSet);
        if (number < 0L) {
            throw new ReviewedStingException("dna conversion cannot handle negative numbers. Possible overflow?");
        }
        int length = BitSetUtils.contextLengthFor(number);
        number -= BitSetUtils.combinationsFor(length - 1);
        String dna = "";
        while (number > 0L) {
            byte base = (byte)(number % 4L);
            switch (base) {
                case 0: {
                    dna = "A" + dna;
                    break;
                }
                case 1: {
                    dna = "C" + dna;
                    break;
                }
                case 2: {
                    dna = "G" + dna;
                    break;
                }
                case 3: {
                    dna = "T" + dna;
                }
            }
            number /= 4L;
        }
        for (int j = dna.length(); j < length; ++j) {
            dna = "A" + dna;
        }
        return dna;
    }

    public static BitSet bitSetFrom(String dna) {
        if (dna.length() > 31) {
            throw new ReviewedStingException(String.format("DNA Length cannot be bigger than %d. dna: %s (%d)", 31, dna, dna.length()));
        }
        long baseTen = 0L;
        long preContext = BitSetUtils.combinationsFor(dna.length() - 1);
        block6: for (int i = 0; i < dna.length(); ++i) {
            baseTen *= 4L;
            switch (dna.charAt(i)) {
                case 'A': {
                    baseTen += 0L;
                    continue block6;
                }
                case 'C': {
                    ++baseTen;
                    continue block6;
                }
                case 'G': {
                    baseTen += 2L;
                    continue block6;
                }
                case 'T': {
                    baseTen += 3L;
                }
            }
        }
        return BitSetUtils.bitSetFrom(baseTen + preContext);
    }

    public static int numberOfBitsToRepresent(long numberOfElements) {
        if (numberOfElements < 0L) {
            throw new ReviewedStingException("Number of elements must be positive: " + numberOfElements);
        }
        if (numberOfElements == 1L) {
            return 1;
        }
        int n = 0;
        --numberOfElements;
        while (numberOfElements > 0L) {
            numberOfElements >>= 1;
            ++n;
        }
        return n;
    }

    private static int contextLengthFor(long number) {
        int length = 1;
        long combinations = BitSetUtils.combinationsFor(length);
        while (combinations <= number) {
            combinations = BitSetUtils.combinationsFor(++length);
        }
        return length;
    }

    private static long combinationsFor(int length) {
        if (length > 31) {
            throw new ReviewedStingException(String.format("Context cannot be longer than %d bases but requested %d.", 31, length));
        }
        if (length > 0 && combinationsPerLength[length] == 0L) {
            long combinations = 0L;
            for (int i = 1; i <= length; ++i) {
                combinations += 1L << 2 * i;
            }
            BitSetUtils.combinationsPerLength[length] = combinations;
        }
        return combinationsPerLength[length];
    }

    public static byte[] sizeOf(Object obj) throws IOException {
        ByteArrayOutputStream byteObject = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteObject);
        objectOutputStream.writeObject(obj);
        objectOutputStream.flush();
        objectOutputStream.close();
        byteObject.close();
        return byteObject.toByteArray();
    }
}

