/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager.StratificationManager;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.AnalysisModuleScanner;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.EvaluationContext;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;

public class VariantEvalReportWriter {
    private final GATKReport report;
    private final StratificationManager<VariantStratifier, EvaluationContext> stratManager;

    public VariantEvalReportWriter(StratificationManager<VariantStratifier, EvaluationContext> stratManager, Collection<VariantStratifier> stratifiers, Collection<VariantEvaluator> evaluators) {
        this.stratManager = stratManager;
        this.report = this.initializeGATKReport(stratifiers, evaluators);
    }

    public final void writeReport(PrintStream out) {
        for (int key = 0; key < this.stratManager.size(); ++key) {
            String stratStateString = this.stratManager.getStratsAndStatesStringForKey(key);
            List<Pair<VariantStratifier, Object>> stratsAndStates = this.stratManager.getStratsAndStatesForKey(key);
            EvaluationContext nec = this.stratManager.get(key);
            for (VariantEvaluator ve : nec.getVariantEvaluators()) {
                GATKReportTable table = this.report.getTable(ve.getSimpleName());
                AnalysisModuleScanner scanner = new AnalysisModuleScanner(ve);
                Map<Field, DataPoint> datamap = scanner.getData();
                try {
                    if (scanner.hasMoltenField()) {
                        Field field = scanner.getMoltenField();
                        Object fieldValue = field.get(ve);
                        if (fieldValue == null || !(fieldValue instanceof Map)) {
                            throw new ReviewedStingException("BUG field " + field.getName() + " must be a non-null instance of Map in " + scanner.getAnalysis().name());
                        }
                        Map map = (Map)fieldValue;
                        if (map.isEmpty()) {
                            throw new ReviewedStingException("BUG: map is null or empty in analysis " + scanner.getAnalysis());
                        }
                        int counter = 0;
                        for (Map.Entry keyValue : map.entrySet()) {
                            String moltenStratStateString = stratStateString + String.format("%05d", counter++);
                            this.setStratificationColumns(table, moltenStratStateString, stratsAndStates);
                            table.set(moltenStratStateString, scanner.getMoltenAnnotation().variableName(), keyValue.getKey());
                            table.set(moltenStratStateString, scanner.getMoltenAnnotation().valueName(), keyValue.getValue());
                        }
                        continue;
                    }
                    this.setStratificationColumns(table, stratStateString, stratsAndStates);
                    for (Field field : datamap.keySet()) {
                        table.set(stratStateString, field.getName(), field.get(ve));
                    }
                }
                catch (IllegalAccessException e) {
                    throw new ReviewedStingException("BUG: analysis field not public: " + e);
                }
            }
        }
        this.report.print(out);
    }

    private void setStratificationColumns(GATKReportTable table, String primaryKey, List<Pair<VariantStratifier, Object>> stratsAndStates) {
        for (Pair<VariantStratifier, Object> stratAndState : stratsAndStates) {
            VariantStratifier vs = stratAndState.getFirst();
            String columnName = vs.getName();
            Object strat = stratAndState.getSecond();
            if (columnName == null || strat == null) {
                throw new ReviewedStingException("Unexpected null variant stratifier state at " + table + " key = " + primaryKey);
            }
            table.set(primaryKey, columnName, strat);
        }
    }

    private GATKReport initializeGATKReport(Collection<VariantStratifier> stratifiers, Collection<VariantEvaluator> evaluators) {
        GATKReport report = new GATKReport();
        for (VariantEvaluator ve : evaluators) {
            String tableName = ve.getSimpleName();
            String tableDesc = ve.getClass().getAnnotation(Analysis.class).description();
            report.addTable(tableName, tableDesc, true);
            GATKReportTable table = report.getTable(tableName);
            table.addPrimaryKey("entry", false);
            table.addColumn(tableName, tableName);
            for (VariantStratifier vs : stratifiers) {
                String columnName = vs.getName();
                table.addColumn(columnName, null, vs.getFormat());
            }
            AnalysisModuleScanner scanner = new AnalysisModuleScanner(ve);
            Map<Field, DataPoint> datamap = scanner.getData();
            if (scanner.hasMoltenField()) {
                table.addColumn(scanner.getMoltenAnnotation().variableName(), true, scanner.getMoltenAnnotation().variableFormat());
                table.addColumn(scanner.getMoltenAnnotation().valueName(), true, scanner.getMoltenAnnotation().valueFormat());
                continue;
            }
            if (datamap.isEmpty()) {
                throw new ReviewedStingException("Datamap is empty for analysis " + scanner.getAnalysis());
            }
            for (Field field : datamap.keySet()) {
                try {
                    field.setAccessible(true);
                    String format = datamap.get(field).format();
                    table.addColumn(field.getName(), true, format);
                }
                catch (SecurityException e) {
                    throw new StingException("SecurityException: " + e);
                }
            }
        }
        return report;
    }
}

