/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordCoordinateComparator;

public class SAMRecordCoordinateComparatorWithUnmappedReads
extends SAMRecordCoordinateComparator {
    @Override
    public int compare(SAMRecord samRecord1, SAMRecord samRecord2) {
        int cmp = this.fileOrderCompare(samRecord1, samRecord2);
        if (cmp != 0) {
            return cmp;
        }
        if (samRecord1.getReadUnmappedFlag() != samRecord2.getReadUnmappedFlag()) {
            return samRecord1.getReadUnmappedFlag() ? 1 : -1;
        }
        if (samRecord1.getReadNegativeStrandFlag() != samRecord2.getReadNegativeStrandFlag()) {
            return samRecord1.getReadNegativeStrandFlag() ? 1 : -1;
        }
        cmp = samRecord1.getReadName().compareTo(samRecord2.getReadName());
        if (cmp != 0) {
            return cmp;
        }
        if (samRecord1.getDuplicateReadFlag() != samRecord2.getDuplicateReadFlag()) {
            return samRecord1.getDuplicateReadFlag() ? -1 : 1;
        }
        if (samRecord1.getReadPairedFlag() && samRecord2.getReadPairedFlag() && samRecord1.getFirstOfPairFlag() != samRecord2.getFirstOfPairFlag()) {
            return samRecord1.getFirstOfPairFlag() ? -1 : 1;
        }
        return samRecord1.getMappingQuality() - samRecord2.getMappingQuality();
    }
}

