/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.CallableStatus;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.LocusStatistics;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

class SampleStatistics {
    private final GenomeLoc interval;
    private final ArrayList<LocusStatistics> loci;
    private final int minimumCoverageThreshold;
    private final int maximumCoverageThreshold;
    private final int minimumMappingQuality;
    private final int minimumBaseQuality;
    private int preComputedTotalCoverage = -1;

    private SampleStatistics(GenomeLoc interval, ArrayList<LocusStatistics> loci, int minimumCoverageThreshold, int maximumCoverageThreshold, int minimumMappingQuality, int minimumBaseQuality) {
        this.interval = interval;
        this.loci = loci;
        this.minimumCoverageThreshold = minimumCoverageThreshold;
        this.maximumCoverageThreshold = maximumCoverageThreshold;
        this.minimumMappingQuality = minimumMappingQuality;
        this.minimumBaseQuality = minimumBaseQuality;
    }

    public SampleStatistics(GenomeLoc interval, int minimumCoverageThreshold, int maximumCoverageThreshold, int minimumMappingQuality, int minimumBaseQuality) {
        this(interval, new ArrayList<LocusStatistics>(interval.size()), minimumCoverageThreshold, maximumCoverageThreshold, minimumMappingQuality, minimumBaseQuality);
        for (int i = 0; i < interval.size(); ++i) {
            this.loci.add(i, new LocusStatistics());
        }
    }

    public long totalCoverage() {
        if (this.preComputedTotalCoverage < 0) {
            this.calculateTotalCoverage();
        }
        return this.preComputedTotalCoverage;
    }

    public double averageCoverage() {
        if (this.preComputedTotalCoverage < 0) {
            this.calculateTotalCoverage();
        }
        return (double)this.preComputedTotalCoverage / (double)this.loci.size();
    }

    public Set<CallableStatus> getCallableStatuses() {
        HashMap<CallableStatus, Integer> totals = new HashMap<CallableStatus, Integer>(CallableStatus.values().length);
        for (CallableStatus status : CallableStatus.values()) {
            totals.put(status, 0);
        }
        for (int i = 0; i < this.interval.size(); ++i) {
            for (CallableStatus status : this.callableStatus(i)) {
                int count = (Integer)totals.get((Object)status);
                totals.put(status, count + 1);
            }
        }
        HashSet<CallableStatus> output = new HashSet<CallableStatus>();
        double intervalSize = this.interval.size();
        double coverageStatusThreshold = 0.2;
        if ((double)((Integer)totals.get((Object)CallableStatus.NO_COVERAGE)).intValue() / intervalSize > coverageStatusThreshold) {
            output.add(CallableStatus.NO_COVERAGE);
        }
        if ((double)((Integer)totals.get((Object)CallableStatus.LOW_COVERAGE)).intValue() / intervalSize > coverageStatusThreshold) {
            output.add(CallableStatus.LOW_COVERAGE);
        }
        double excessiveCoverageThreshold = 0.2;
        if ((double)((Integer)totals.get((Object)CallableStatus.EXCESSIVE_COVERAGE)).intValue() / intervalSize > excessiveCoverageThreshold) {
            output.add(CallableStatus.EXCESSIVE_COVERAGE);
        }
        double qualityStatusThreshold = 0.5;
        if ((double)((Integer)totals.get((Object)CallableStatus.POOR_QUALITY)).intValue() / intervalSize > qualityStatusThreshold) {
            output.add(CallableStatus.POOR_QUALITY);
        }
        if ((Integer)totals.get((Object)CallableStatus.REF_N) > 0) {
            output.add(CallableStatus.REF_N);
        }
        if (output.isEmpty()) {
            output.add(CallableStatus.PASS);
        }
        return output;
    }

    public void addLocus(GenomeLoc locus, ReadBackedPileup pileup) {
        if (!this.interval.containsP(locus)) {
            throw new ReviewedStingException(String.format("Locus %s is not part of the Interval", locus));
        }
        if (pileup != null) {
            int locusIndex = locus.getStart() - this.interval.getStart();
            int rawCoverage = pileup.depthOfCoverage();
            int coverage = pileup.getBaseAndMappingFilteredPileup(this.minimumBaseQuality, this.minimumMappingQuality).depthOfCoverage();
            LocusStatistics locusData = new LocusStatistics(coverage, rawCoverage);
            this.loci.add(locusIndex, locusData);
        }
    }

    private Set<CallableStatus> callableStatus(int locusIndex) {
        LocusStatistics locus = this.loci.get(locusIndex);
        return locus.callableStatuses(this.minimumCoverageThreshold, this.maximumCoverageThreshold);
    }

    private void calculateTotalCoverage() {
        this.preComputedTotalCoverage = 0;
        for (LocusStatistics locus : this.loci) {
            this.preComputedTotalCoverage += locus.getCoverage();
        }
    }
}

