/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import org.broadinstitute.sting.alignment.reference.bwt.Counts;
import org.broadinstitute.sting.alignment.reference.bwt.SequenceBlock;
import org.broadinstitute.sting.alignment.reference.bwt.SuffixArray;
import org.broadinstitute.sting.alignment.reference.packing.PackUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BWT {
    public static final int SEQUENCE_BLOCK_SIZE = 128;
    protected final long inverseSA0;
    protected final Counts counts;
    protected final SequenceBlock[] sequenceBlocks;

    public BWT(long inverseSA0, Counts counts, SequenceBlock[] sequenceBlocks) {
        this.inverseSA0 = inverseSA0;
        this.counts = counts;
        this.sequenceBlocks = sequenceBlocks;
    }

    public BWT(long inverseSA0, Counts counts, byte[] sequence) {
        this(inverseSA0, counts, BWT.generateSequenceBlocks(sequence));
    }

    public byte[] getSequence() {
        byte[] sequence = new byte[(int)this.counts.getTotal()];
        for (SequenceBlock block : this.sequenceBlocks) {
            System.arraycopy(block.sequence, 0, sequence, block.sequenceStart, block.sequenceLength);
        }
        return sequence;
    }

    public long counts(byte base) {
        return this.counts.getCumulative(base);
    }

    public long occurrences(byte base, long index) {
        SequenceBlock block = this.getSequenceBlock(index);
        int position = this.getSequencePosition(index);
        long accumulator = block.occurrences.get(base);
        for (int i = 0; i <= position; ++i) {
            if (base != block.sequence[i]) continue;
            ++accumulator;
        }
        return accumulator;
    }

    public long length() {
        return this.counts.getTotal();
    }

    public static BWT createFromReferenceSequence(byte[] referenceSequence) {
        SuffixArray suffixArray = SuffixArray.createFromReferenceSequence(referenceSequence);
        byte[] bwt = new byte[(int)suffixArray.length() - 1];
        int bwtIndex = 0;
        for (long suffixArrayIndex = 0L; suffixArrayIndex < suffixArray.length(); ++suffixArrayIndex) {
            if (suffixArray.get(suffixArrayIndex) == 0L) continue;
            bwt[bwtIndex++] = referenceSequence[(int)suffixArray.get(suffixArrayIndex) - 1];
        }
        return new BWT(suffixArray.inverseSA0, suffixArray.occurrences, bwt);
    }

    protected byte getBase(long index) {
        if (index == this.inverseSA0) {
            throw new ReviewedStingException(String.format("Base at index %d does not have a text representation", index));
        }
        SequenceBlock block = this.getSequenceBlock(index);
        int position = this.getSequencePosition(index);
        return block.sequence[position];
    }

    private SequenceBlock getSequenceBlock(long index) {
        if (index > this.inverseSA0) {
            --index;
        }
        return this.sequenceBlocks[(int)(index / 128L)];
    }

    private int getSequencePosition(long index) {
        if (index > this.inverseSA0) {
            --index;
        }
        return (int)(index % 128L);
    }

    private static SequenceBlock[] generateSequenceBlocks(byte[] sequence) {
        Counts occurrences = new Counts();
        int numSequenceBlocks = PackUtils.numberOfPartitions(sequence.length, 128L);
        SequenceBlock[] sequenceBlocks = new SequenceBlock[numSequenceBlocks];
        for (int block = 0; block < numSequenceBlocks; ++block) {
            int blockStart = block * 128;
            int blockLength = Math.min(128, sequence.length - blockStart);
            byte[] subsequence = new byte[blockLength];
            System.arraycopy(sequence, blockStart, subsequence, 0, blockLength);
            sequenceBlocks[block] = new SequenceBlock(blockStart, blockLength, occurrences.clone(), subsequence);
            for (byte base : subsequence) {
                occurrences.increment(base);
            }
        }
        return sequenceBlocks;
    }
}

