/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.util.vcf;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.SAMSequenceDictionary;
import org.broad.tribble.Tribble;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.iterators.CloseableTribbleIterator;
import org.broad.tribble.source.BasicFeatureSource;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.broadinstitute.sting.utils.codecs.vcf.StandardVCFWriter;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFUtil {
    public static BasicFeatureSource<VariantContext> getFeatureSource(String fname) throws Exception {
        File vcfFile = new File(fname);
        VCFCodec codec = new VCFCodec();
        File indexFile = Tribble.indexFile(vcfFile);
        Index index = null;
        if (indexFile.canRead()) {
            index = IndexFactory.loadIndex(indexFile.getAbsolutePath());
        } else {
            index = IndexFactory.createLinearIndex(vcfFile, codec);
            LittleEndianOutputStream stream = new LittleEndianOutputStream(new FileOutputStream(indexFile));
            index.write(stream);
            stream.close();
        }
        BasicFeatureSource fsource = BasicFeatureSource.getFeatureSource(fname, codec, false);
        return fsource;
    }

    public static void write(String fname, String fa, VCFHeader header, List<VariantContext> var_lst) {
        SAMSequenceDictionary dict = ReferenceSequenceFileFactory.getReferenceSequenceFile(new File(fa)).getSequenceDictionary();
        StandardVCFWriter writer = new StandardVCFWriter(new File(fname), dict);
        writer.writeHeader(header);
        for (VariantContext var : var_lst) {
            writer.add(var);
        }
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("start");
        String fname = "/Users/namratatomer/work/ss.vcf";
        BasicFeatureSource<VariantContext> fsource = VCFUtil.getFeatureSource(fname);
        CloseableTribbleIterator<VariantContext> itr = fsource.iterator();
        VCFHeader header = (VCFHeader)fsource.getHeader();
        System.out.println(header.getHeaderFields());
        System.out.println();
        while (itr.hasNext()) {
            VariantContext var = (VariantContext)itr.next();
            Genotype gt = var.getGenotype("TUMOR");
            System.out.println(gt.getAttributeAsInt("SS", -99999));
            System.out.println(String.valueOf(var.isSNP()) + "\t" + var.getChr() + "\t" + var.getReference() + "\t" + var.getGenotype("NORMAL") + "\t" + var.getGenotype("TUMOR"));
        }
        System.out.println("hello");
    }
}

