/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.methyl.rrbs.prep;

import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.rbio.methyl.rrbs.util.Fragment;

public class RRBSFragmentBuilder {
    @Option(name="-ref_fa", usage="Reference fasta file", required=true)
    private String ref_fa;
    @Option(name="-min_frag_len", usage="Minimum fragment length", required=true)
    private int min_frag_len;
    @Option(name="-max_frag_len", usage="Maximum fragment length", required=true)
    private int max_frag_len;
    @Option(name="-adapter_5", usage="5' adapter. Misner adapter [3']: AGATCGGAAGAGCGGTTCAGCAGGAATGCCGAGACCGATCTCGTATGCCGTCTTCTGCTTG", required=true)
    private String adapter_5;
    @Option(name="-adapter_3", usage="3' adapter. Misner adapter [5']: AGATCGGAAGAGCGTCGTGTAGGGAAAGAGTGTAGATCTCGGTGGTCGCCGTATCATT", required=true)
    private String adapter_3;
    @Option(name="-read_len", usage="Read length", required=true)
    private int read_len;
    @Option(name="-out_prefix", usage="Output prefix for fasta file", required=true)
    private String out_prefix;

    public static void main(String[] args) throws Exception {
        RRBSFragmentBuilder frag_builder = new RRBSFragmentBuilder();
        CmdLineParser parser = new CmdLineParser(frag_builder);
        try {
            parser.parseArgument(args);
            frag_builder.process();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("RRBS fragment maker");
            parser.printUsage(System.err);
            return;
        }
    }

    public void process() throws Exception {
        Fragment.write(Fragment.build(this.ref_fa, this.min_frag_len, this.max_frag_len), this.out_prefix, this.read_len, this.adapter_3, this.adapter_5);
    }
}

