/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval;

import com.google.java.contract.Requires;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.util.IntervalTree;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.DbsnpArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalReportWriter;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.IntervalStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager.StratificationManager;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.EvaluationContext;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.SortableJexlVCMatchExp;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.VariantEvalUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Reference(window=@Window(start=-50, stop=50))
public class VariantEvalWalker
extends RodWalker<Integer, Integer>
implements TreeReducible<Integer> {
    public static final String IS_SINGLETON_KEY = "ISSINGLETON";
    @Output
    protected PrintStream out;
    @Input(fullName="eval", shortName="eval", doc="Input evaluation file(s)", required=true)
    public List<RodBinding<VariantContext>> evals;
    @Input(fullName="comp", shortName="comp", doc="Input comparison file(s)", required=false)
    public List<RodBinding<VariantContext>> compsProvided = Collections.emptyList();
    private List<RodBinding<VariantContext>> comps = new ArrayList<RodBinding<VariantContext>>();
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Input(fullName="goldStandard", shortName="gold", doc="Evaluations that count calls at sites of true variation (e.g., indel calls) will use this argument as their gold standard for comparison", required=false)
    public RodBinding<VariantContext> goldStandard = null;
    @Argument(fullName="list", shortName="ls", doc="List the available eval modules and exit", required=false)
    protected Boolean LIST = false;
    @Argument(shortName="select", doc="One or more stratifications to use when evaluating the data", required=false)
    protected ArrayList<String> SELECT_EXPS = new ArrayList();
    @Argument(shortName="selectName", doc="Names to use for the list of stratifications (must be a 1-to-1 mapping)", required=false)
    protected ArrayList<String> SELECT_NAMES = new ArrayList();
    @Argument(fullName="sample", shortName="sn", doc="Derive eval and comp contexts using only these sample genotypes, when genotypes are available in the original context", required=false)
    protected Set<String> SAMPLE_EXPRESSIONS;
    @Argument(shortName="knownName", doc="Name of ROD bindings containing variant sites that should be treated as known when splitting eval rods into known and novel subsets", required=false)
    protected HashSet<String> KNOWN_NAMES = new HashSet();
    List<RodBinding<VariantContext>> knowns = new ArrayList<RodBinding<VariantContext>>();
    @Argument(fullName="stratificationModule", shortName="ST", doc="One or more specific stratification modules to apply to the eval track(s) (in addition to the standard stratifications, unless -noS is specified)", required=false)
    protected String[] STRATIFICATIONS_TO_USE = new String[0];
    @Argument(fullName="doNotUseAllStandardStratifications", shortName="noST", doc="Do not use the standard stratification modules by default (instead, only those that are specified with the -S option)", required=false)
    protected Boolean NO_STANDARD_STRATIFICATIONS = false;
    @Argument(fullName="evalModule", shortName="EV", doc="One or more specific eval modules to apply to the eval track(s) (in addition to the standard modules, unless -noEV is specified)", required=false)
    protected String[] MODULES_TO_USE = new String[0];
    @Argument(fullName="doNotUseAllStandardModules", shortName="noEV", doc="Do not use the standard modules by default (instead, only those that are specified with the -EV option)", required=false)
    protected Boolean NO_STANDARD_MODULES = false;
    @Argument(fullName="minPhaseQuality", shortName="mpq", doc="Minimum phasing quality", required=false)
    protected double MIN_PHASE_QUALITY = 10.0;
    @Argument(shortName="mvq", fullName="mendelianViolationQualThreshold", doc="Minimum genotype QUAL score for each trio member required to accept a site as a violation. Default is 50.", required=false)
    protected double MENDELIAN_VIOLATION_QUAL_THRESHOLD = 50.0;
    @Argument(fullName="ancestralAlignments", shortName="aa", doc="Fasta file with ancestral alleles", required=false)
    private File ancestralAlignmentsFile = null;
    @Argument(fullName="requireStrictAlleleMatch", shortName="strict", doc="If provided only comp and eval tracks with exactly matching reference and alternate alleles will be counted as overlapping", required=false)
    private boolean requireStrictAlleleMatch = false;
    @Argument(fullName="keepAC0", shortName="keepAC0", doc="If provided, modules that track polymorphic sites will not require that a site have AC > 0 when the input eval has genotypes", required=false)
    private boolean keepSitesWithAC0 = false;
    @Argument(fullName="mergeEvals", shortName="mergeEvals", doc="If provided, all -eval tracks will be merged into a single eval track", required=false)
    public boolean mergeEvals = false;
    @Input(fullName="stratIntervals", shortName="stratIntervals", doc="File containing tribble-readable features for the IntervalStratificiation", required=false)
    public IntervalBinding<Feature> intervalsFile = null;
    @Input(fullName="knownCNVs", shortName="knownCNVs", doc="File containing tribble-readable features describing a known list of copy number variants", required=false)
    public IntervalBinding<Feature> knownCNVsFile = null;
    Map<String, IntervalTree<GenomeLoc>> knownCNVsByContig = Collections.emptyMap();
    private Set<SortableJexlVCMatchExp> jexlExpressions = new TreeSet<SortableJexlVCMatchExp>();
    private Set<String> sampleNamesForEvaluation = new TreeSet<String>();
    private Set<String> sampleNamesForStratification = new TreeSet<String>();
    private boolean byFilterIsEnabled = false;
    private boolean perSampleIsEnabled = false;
    private static String ALL_SAMPLE_NAME = "all";
    long nProcessedLoci = 0L;
    private final VariantEvalUtils variantEvalUtils = new VariantEvalUtils(this);
    private IndexedFastaSequenceFile ancestralAlignments = null;
    StratificationManager<VariantStratifier, EvaluationContext> stratManager;

    @Override
    public void initialize() {
        if (this.LIST.booleanValue()) {
            this.variantEvalUtils.listModulesAndExit();
        }
        this.comps.addAll(this.compsProvided);
        if (this.dbsnp.dbsnp.isBound()) {
            this.comps.add(this.dbsnp.dbsnp);
            this.knowns.add(this.dbsnp.dbsnp);
        }
        if (this.comps.size() == 0) {
            this.comps.add(new RodBinding<VariantContext>(VariantContext.class, "none", "UNBOUND", "", new Tags()));
        }
        for (RodBinding<VariantContext> compRod : this.comps) {
            if (!this.KNOWN_NAMES.contains(compRod.getName())) continue;
            this.knowns.add(compRod);
        }
        Map<String, VCFHeader> vcfRods = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), this.evals);
        Set<String> vcfSamples = SampleUtils.getSampleList(vcfRods, VariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
        this.sampleNamesForEvaluation.addAll(SampleUtils.getSamplesFromCommandLineInput(vcfSamples, this.SAMPLE_EXPRESSIONS));
        if (Arrays.asList(this.STRATIFICATIONS_TO_USE).contains("Sample")) {
            this.sampleNamesForStratification.addAll(this.sampleNamesForEvaluation);
        }
        this.sampleNamesForStratification.add(ALL_SAMPLE_NAME);
        for (VariantContextUtils.JexlVCMatchExp jexl : VariantContextUtils.initializeMatchExps(this.SELECT_NAMES, this.SELECT_EXPS)) {
            SortableJexlVCMatchExp sjexl = new SortableJexlVCMatchExp(jexl.name, jexl.exp);
            this.jexlExpressions.add(sjexl);
        }
        List<VariantStratifier> stratificationObjects = this.variantEvalUtils.initializeStratificationObjects(this.NO_STANDARD_STRATIFICATIONS, this.STRATIFICATIONS_TO_USE);
        Set<Class<? extends VariantEvaluator>> evaluationClasses = this.variantEvalUtils.initializeEvaluationObjects(this.NO_STANDARD_MODULES, this.MODULES_TO_USE);
        this.checkForIncompatibleEvaluatorsAndStratifiers(stratificationObjects, evaluationClasses);
        for (VariantStratifier vs : stratificationObjects) {
            if (vs.getName().equals("Filter")) {
                this.byFilterIsEnabled = true;
                continue;
            }
            if (!vs.getName().equals("Sample")) continue;
            this.perSampleIsEnabled = true;
        }
        if (this.intervalsFile != null) {
            boolean fail = true;
            for (VariantStratifier vs : stratificationObjects) {
                if (!vs.getClass().equals(IntervalStratification.class)) continue;
                fail = false;
            }
            if (fail) {
                throw new UserException.BadArgumentValue("ST", "stratIntervals argument provided but -ST IntervalStratification not provided");
            }
        }
        this.createStratificationStates(stratificationObjects, evaluationClasses);
        if (this.ancestralAlignmentsFile != null) {
            try {
                this.ancestralAlignments = new IndexedFastaSequenceFile(this.ancestralAlignmentsFile);
            }
            catch (FileNotFoundException e) {
                throw new ReviewedStingException(String.format("The ancestral alignments file, '%s', could not be found", this.ancestralAlignmentsFile.getAbsolutePath()));
            }
        }
        if (this.knownCNVsFile != null) {
            this.knownCNVsByContig = this.createIntervalTreeByContig(this.knownCNVsFile);
        }
    }

    final void checkForIncompatibleEvaluatorsAndStratifiers(List<VariantStratifier> stratificationObjects, Set<Class<? extends VariantEvaluator>> evaluationClasses) {
        for (VariantStratifier vs : stratificationObjects) {
            for (Class<? extends VariantEvaluator> ec : evaluationClasses) {
                if (!vs.getIncompatibleEvaluators().contains(ec)) continue;
                throw new UserException.BadArgumentValue("ST and ET", "The selected stratification " + vs.getName() + " and evaluator " + ec.getSimpleName() + " are incompatible due to combinatorial memory requirements." + " Please disable one");
            }
        }
    }

    final void createStratificationStates(List<VariantStratifier> stratificationObjects, Set<Class<? extends VariantEvaluator>> evaluationObjects) {
        ArrayList<VariantStratifier> strats = new ArrayList<VariantStratifier>(stratificationObjects);
        this.stratManager = new StratificationManager(strats);
        logger.info("Creating " + this.stratManager.size() + " combinatorial stratification states");
        for (int i = 0; i < this.stratManager.size(); ++i) {
            EvaluationContext ec = new EvaluationContext(this, evaluationObjects);
            this.stratManager.set(i, ec);
        }
    }

    public final Map<String, IntervalTree<GenomeLoc>> createIntervalTreeByContig(IntervalBinding<Feature> intervals) {
        HashMap<String, IntervalTree<GenomeLoc>> byContig = new HashMap<String, IntervalTree<GenomeLoc>>();
        List<GenomeLoc> locs = intervals.getIntervals(this.getToolkit());
        for (String contig : this.getContigNames()) {
            byContig.put(contig, new IntervalTree());
        }
        for (GenomeLoc loc : locs) {
            ((IntervalTree)byContig.get(loc.getContig())).put(loc.getStart(), loc.getStop(), loc);
        }
        return byContig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        VariantEvalWalker variantEvalWalker = this;
        synchronized (variantEvalWalker) {
            this.nProcessedLoci += context.getSkippedBases() + (long)(ref == null ? 0 : 1);
        }
        if (tracker != null) {
            String aastr = this.ancestralAlignments == null ? null : new String(this.ancestralAlignments.getSubsequenceAt(ref.getLocus().getContig(), ref.getLocus().getStart(), ref.getLocus().getStop()).getBases());
            HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>> evalVCs = this.variantEvalUtils.bindVariantContexts(tracker, ref, this.evals, this.byFilterIsEnabled, true, this.perSampleIsEnabled, this.mergeEvals);
            HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>> compVCs = this.variantEvalUtils.bindVariantContexts(tracker, ref, this.comps, this.byFilterIsEnabled, false, false, false);
            for (RodBinding<VariantContext> evalRod : this.evals) {
                Map emptyEvalMap = Collections.emptyMap();
                Map evalSet = evalVCs.containsKey(evalRod) ? (Map)evalVCs.get(evalRod) : emptyEvalMap;
                for (String sampleName : this.sampleNamesForStratification) {
                    HashSet<VariantContext> evalSetBySample = (HashSet<VariantContext>)evalSet.get(sampleName);
                    if (evalSetBySample == null) {
                        evalSetBySample = new HashSet<VariantContext>(1);
                        evalSetBySample.add(null);
                    }
                    for (VariantContext eval : evalSetBySample) {
                        if (eval != null && aastr != null) {
                            eval = new VariantContextBuilder(eval).attribute("ANCESTRALALLELE", aastr).make();
                        }
                        for (RodBinding<VariantContext> compRod : this.comps) {
                            HashMap<String, Collection<VariantContext>> compSetHash = compVCs.get(compRod);
                            List<VariantContext> compSet = compSetHash == null || compSetHash.size() == 0 ? Collections.emptyList() : compVCs.get(compRod).values().iterator().next();
                            VariantContext comp = this.findMatchingComp(eval, compSet);
                            Iterator<EvaluationContext> i$ = this.getEvaluationContexts(tracker, ref, eval, evalRod.getName(), comp, compRod.getName(), sampleName).iterator();
                            while (i$.hasNext()) {
                                EvaluationContext nec;
                                EvaluationContext evaluationContext = nec = i$.next();
                                synchronized (evaluationContext) {
                                    nec.apply(tracker, ref, context, comp, eval);
                                }
                                for (VariantContext otherComp : compSet) {
                                    if (otherComp == comp || this.compHasMatchingEval(otherComp, evalSetBySample)) continue;
                                    EvaluationContext evaluationContext2 = nec;
                                    synchronized (evaluationContext2) {
                                        nec.apply(tracker, ref, context, otherComp, null);
                                    }
                                }
                            }
                        }
                    }
                }
                if (!this.mergeEvals) continue;
                break;
            }
        }
        return null;
    }

    protected Collection<EvaluationContext> getEvaluationContexts(RefMetaDataTracker tracker, ReferenceContext ref, VariantContext eval, String evalName, VariantContext comp, String compName, String sampleName) {
        LinkedList<List<Object>> states = new LinkedList<List<Object>>();
        for (VariantStratifier vs : this.stratManager.getStratifiers()) {
            states.add(vs.getRelevantStates(ref, tracker, comp, compName, eval, evalName, sampleName));
        }
        return this.stratManager.values(states);
    }

    @Requires(value={"comp != null", "evals != null"})
    private boolean compHasMatchingEval(VariantContext comp, Collection<VariantContext> evals) {
        for (VariantContext eval : evals) {
            if (eval == null || this.doEvalAndCompMatch(comp, eval, this.requireStrictAlleleMatch) == EvalCompMatchType.NO_MATCH) continue;
            return true;
        }
        return false;
    }

    @Requires(value={"eval != null", "comp != null"})
    private EvalCompMatchType doEvalAndCompMatch(VariantContext eval, VariantContext comp, boolean requireStrictAlleleMatch) {
        Allele altComp;
        if (comp.getType() != eval.getType()) {
            return EvalCompMatchType.NO_MATCH;
        }
        Allele altEval = eval.getAlternateAlleles().size() == 0 ? null : eval.getAlternateAllele(0);
        Allele allele = altComp = comp.getAlternateAlleles().size() == 0 ? null : comp.getAlternateAllele(0);
        if (altEval == null && altComp == null || altEval != null && altEval.equals(altComp) && eval.getReference().equals(comp.getReference())) {
            return EvalCompMatchType.STRICT;
        }
        return requireStrictAlleleMatch ? EvalCompMatchType.NO_MATCH : EvalCompMatchType.LENIENT;
    }

    private VariantContext findMatchingComp(VariantContext eval, Collection<VariantContext> comps) {
        if (comps == null || comps.isEmpty()) {
            return null;
        }
        if (eval == null) {
            return comps.iterator().next();
        }
        VariantContext lenientMatch = null;
        for (VariantContext comp : comps) {
            switch (this.doEvalAndCompMatch(comp, eval, this.requireStrictAlleleMatch)) {
                case STRICT: {
                    return comp;
                }
                case LENIENT: {
                    if (lenientMatch != null) break;
                    lenientMatch = comp;
                    break;
                }
            }
        }
        return lenientMatch;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return null;
    }

    @Override
    public Integer reduceInit() {
        return null;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return null;
    }

    @Override
    public void onTraversalDone(Integer result) {
        logger.info("Finalizing variant report");
        for (EvaluationContext nec : this.stratManager.values()) {
            for (VariantEvaluator ve : nec.getVariantEvaluators()) {
                ve.finalizeEvaluation();
            }
        }
        VariantEvalReportWriter writer = new VariantEvalReportWriter(this.stratManager, this.stratManager.getStratifiers(), this.stratManager.get(0).getVariantEvaluators());
        writer.writeReport(this.out);
    }

    public Logger getLogger() {
        return logger;
    }

    public double getMinPhaseQuality() {
        return this.MIN_PHASE_QUALITY;
    }

    public double getMendelianViolationQualThreshold() {
        return this.MENDELIAN_VIOLATION_QUAL_THRESHOLD;
    }

    public static String getAllSampleName() {
        return ALL_SAMPLE_NAME;
    }

    public List<RodBinding<VariantContext>> getKnowns() {
        return this.knowns;
    }

    public List<RodBinding<VariantContext>> getEvals() {
        return this.evals;
    }

    public Set<String> getSampleNamesForEvaluation() {
        return this.sampleNamesForEvaluation;
    }

    public Set<String> getSampleNamesForStratification() {
        return this.sampleNamesForStratification;
    }

    public List<RodBinding<VariantContext>> getComps() {
        return this.comps;
    }

    public Set<SortableJexlVCMatchExp> getJexlExpressions() {
        return this.jexlExpressions;
    }

    public long getnProcessedLoci() {
        return this.nProcessedLoci;
    }

    public Set<String> getContigNames() {
        TreeSet<String> contigs = new TreeSet<String>();
        for (SAMSequenceRecord r : this.getToolkit().getReferenceDataSource().getReference().getSequenceDictionary().getSequences()) {
            contigs.add(r.getSequenceName());
        }
        return contigs;
    }

    @Override
    public GenomeAnalysisEngine getToolkit() {
        return super.getToolkit();
    }

    public boolean ignoreAC0Sites() {
        return !this.keepSitesWithAC0;
    }

    private static enum EvalCompMatchType {
        NO_MATCH,
        STRICT,
        LENIENT;

    }
}

