/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import com.google.java.contract.Requires;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class UnifiedGenotyperEngine {
    public static final String LOW_QUAL_FILTER_NAME = "LowQual";
    public static final String NUMBER_OF_DISCOVERED_ALLELES_KEY = "NDA";
    public static final double HUMAN_SNP_HETEROZYGOSITY = 0.001;
    public static final double HUMAN_INDEL_HETEROZYGOSITY = 1.0E-4;
    private final UnifiedArgumentCollection UAC;
    private final VariantAnnotatorEngine annotationEngine;
    private ThreadLocal<Map<String, GenotypeLikelihoodsCalculationModel>> glcm = new ThreadLocal();
    private ThreadLocal<AlleleFrequencyCalculationModel> afcm = new ThreadLocal();
    private ThreadLocal<AlleleFrequencyCalculationResult> alleleFrequencyCalculationResult = new ThreadLocal();
    private ThreadLocal<double[]> posteriorsArray = new ThreadLocal();
    private final double[] log10AlleleFrequencyPriorsSNPs;
    private final double[] log10AlleleFrequencyPriorsIndels;
    private final Set<String> samples;
    private final Logger logger;
    private final PrintStream verboseWriter;
    private final int ploidy;
    private final int N;
    private static final Set<String> filter = new HashSet<String>(1);
    private final GenomeLocParser genomeLocParser;
    private final boolean BAQEnabledOnCMDLine;
    protected static final double SUM_GL_THRESH_NOCALL = -0.1;
    private static final double[] binomialProbabilityDepthCache = new double[10000];

    public UnifiedArgumentCollection getUAC() {
        return this.UAC;
    }

    @Requires(value={"toolkit != null", "UAC != null"})
    public UnifiedGenotyperEngine(GenomeAnalysisEngine toolkit, UnifiedArgumentCollection UAC) {
        this(toolkit, UAC, Logger.getLogger(UnifiedGenotyperEngine.class), null, null, SampleUtils.getSAMFileSamples(toolkit.getSAMFileHeader()), 2 * SampleUtils.getSAMFileSamples(toolkit.getSAMFileHeader()).size());
    }

    @Requires(value={"toolkit != null", "UAC != null", "logger != null", "samples != null && samples.size() > 0", "ploidy>0"})
    public UnifiedGenotyperEngine(GenomeAnalysisEngine toolkit, UnifiedArgumentCollection UAC, Logger logger, PrintStream verboseWriter, VariantAnnotatorEngine engine, Set<String> samples, int ploidy) {
        this.BAQEnabledOnCMDLine = toolkit.getArguments().BAQMode != BAQ.CalculationMode.OFF;
        this.genomeLocParser = toolkit.getGenomeLocParser();
        this.samples = new TreeSet<String>(samples);
        this.UAC = UAC;
        this.logger = logger;
        this.verboseWriter = verboseWriter;
        this.annotationEngine = engine;
        this.ploidy = ploidy;
        this.N = samples.size() * ploidy;
        this.log10AlleleFrequencyPriorsSNPs = new double[this.N + 1];
        this.log10AlleleFrequencyPriorsIndels = new double[this.N + 1];
        UnifiedGenotyperEngine.computeAlleleFrequencyPriors(this.N, this.log10AlleleFrequencyPriorsSNPs, UAC.heterozygosity);
        UnifiedGenotyperEngine.computeAlleleFrequencyPriors(this.N, this.log10AlleleFrequencyPriorsIndels, UAC.INDEL_HETEROZYGOSITY);
        filter.add(LOW_QUAL_FILTER_NAME);
    }

    public List<VariantCallContext> calculateLikelihoodsAndGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        ArrayList<VariantCallContext> results = new ArrayList<VariantCallContext>(2);
        List<GenotypeLikelihoodsCalculationModel.Model> models = this.getGLModelsToUse(tracker, refContext, rawContext);
        if (models.isEmpty()) {
            results.add(this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_SITES && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? this.generateEmptyContext(tracker, refContext, null, rawContext) : null);
        } else {
            for (GenotypeLikelihoodsCalculationModel.Model model : models) {
                Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
                if (stratifiedContexts == null) {
                    results.add(this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_SITES && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? this.generateEmptyContext(tracker, refContext, stratifiedContexts, rawContext) : null);
                    continue;
                }
                VariantContext vc = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.COMPLETE, null, true, model);
                if (vc == null) continue;
                results.add(this.calculateGenotypes(tracker, refContext, rawContext, stratifiedContexts, vc, model));
            }
        }
        return results;
    }

    public VariantContext calculateLikelihoods(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        List<GenotypeLikelihoodsCalculationModel.Model> models = this.getGLModelsToUse(tracker, refContext, rawContext);
        if (models.isEmpty()) {
            return null;
        }
        for (GenotypeLikelihoodsCalculationModel.Model model : models) {
            Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
            if (stratifiedContexts == null) continue;
            return this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.COMPLETE, null, true, model);
        }
        return null;
    }

    public VariantCallContext calculateGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, VariantContext vc) {
        List<GenotypeLikelihoodsCalculationModel.Model> models = this.getGLModelsToUse(tracker, refContext, rawContext);
        if (models.isEmpty()) {
            return null;
        }
        GenotypeLikelihoodsCalculationModel.Model model = models.get(0);
        Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
        return this.calculateGenotypes(tracker, refContext, rawContext, stratifiedContexts, vc, model);
    }

    private VariantContext calculateLikelihoods(RefMetaDataTracker tracker, ReferenceContext refContext, Map<String, AlignmentContext> stratifiedContexts, AlignmentContextUtils.ReadOrientation type, List<Allele> alternateAllelesToUse, boolean useBAQedPileup, GenotypeLikelihoodsCalculationModel.Model model) {
        if (this.glcm.get() == null) {
            this.glcm.set(UnifiedGenotyperEngine.getGenotypeLikelihoodsCalculationObject(this.logger, this.UAC));
        }
        return this.glcm.get().get(model.name()).getLikelihoods(tracker, refContext, stratifiedContexts, type, alternateAllelesToUse, useBAQedPileup && this.BAQEnabledOnCMDLine, this.genomeLocParser);
    }

    private VariantCallContext generateEmptyContext(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, AlignmentContext rawContext) {
        VariantContext vc;
        if (this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            VariantContext vcInput = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, ref, rawContext.getLocation(), false, this.logger, this.UAC.alleles);
            if (vcInput == null) {
                return null;
            }
            vc = new VariantContextBuilder("UG_call", ref.getLocus().getContig(), vcInput.getStart(), vcInput.getEnd(), vcInput.getAlleles()).referenceBaseForIndel(vcInput.getReferenceBaseForIndel()).make();
        } else {
            if (!Allele.acceptableAlleleBases(new byte[]{ref.getBase()})) {
                return null;
            }
            HashSet<Allele> alleles = new HashSet<Allele>();
            alleles.add(Allele.create(ref.getBase(), true));
            vc = new VariantContextBuilder("UG_call", ref.getLocus().getContig(), ref.getLocus().getStart(), ref.getLocus().getStart(), alleles).make();
        }
        if (this.annotationEngine != null && rawContext.hasBasePileup()) {
            ReadBackedPileup pileup = rawContext.getBasePileup();
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
            vc = this.annotationEngine.annotateContext(tracker, ref, stratifiedContexts, vc);
        }
        return new VariantCallContext(vc, false);
    }

    public VariantCallContext calculateGenotypes(VariantContext vc, GenotypeLikelihoodsCalculationModel.Model model) {
        return this.calculateGenotypes(null, null, null, null, vc, model);
    }

    public VariantCallContext calculateGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, GenotypeLikelihoodsCalculationModel.Model model) {
        double phredScaledConfidence;
        boolean limitedContext;
        boolean bl = limitedContext = tracker == null || refContext == null || rawContext == null || stratifiedContexts == null;
        if (this.afcm.get() == null) {
            this.afcm.set(UnifiedGenotyperEngine.getAlleleFrequencyCalculationObject(this.N, this.logger, this.verboseWriter, this.UAC));
            this.alleleFrequencyCalculationResult.set(new AlleleFrequencyCalculationResult(this.UAC.MAX_ALTERNATE_ALLELES));
            this.posteriorsArray.set(new double[2]);
        }
        AlleleFrequencyCalculationResult AFresult = this.alleleFrequencyCalculationResult.get();
        if (vc.getNSamples() == 0) {
            if (limitedContext) {
                return null;
            }
            return this.UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES ? this.estimateReferenceConfidence(vc, stratifiedContexts, this.getTheta(model), false, 1.0) : this.generateEmptyContext(tracker, refContext, stratifiedContexts, rawContext);
        }
        AFresult.reset();
        List<Allele> allelesUsedInGenotyping = this.afcm.get().getLog10PNonRef(vc, this.getAlleleFrequencyPriors(model), AFresult);
        boolean bestGuessIsRef = true;
        ArrayList<Allele> myAlleles = new ArrayList<Allele>(vc.getAlleles().size());
        myAlleles.add(vc.getReference());
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            Allele alternateAllele = vc.getAlternateAllele(i);
            int indexOfAllele = allelesUsedInGenotyping.indexOf(alternateAllele);
            if (indexOfAllele == -1) continue;
            int indexOfBestAC = AFresult.getAlleleCountsOfMAP()[indexOfAllele - 1];
            if (indexOfBestAC != 0) {
                myAlleles.add(alternateAllele);
                bestGuessIsRef = false;
                continue;
            }
            if (this.UAC.GenotypingMode != GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) continue;
            myAlleles.add(alternateAllele);
        }
        double[] normalizedPosteriors = UnifiedGenotyperEngine.generateNormalizedPosteriors(AFresult, this.posteriorsArray.get());
        double PofF = 1.0 - normalizedPosteriors[0];
        if (!bestGuessIsRef || this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            phredScaledConfidence = QualityUtils.phredScaleErrorRate(normalizedPosteriors[0]);
            if (Double.isInfinite(phredScaledConfidence)) {
                phredScaledConfidence = -10.0 * AFresult.getLog10PosteriorOfAFzero();
            }
        } else {
            phredScaledConfidence = QualityUtils.phredScaleErrorRate(PofF);
            if (Double.isInfinite(phredScaledConfidence)) {
                double sum = AFresult.getLog10PosteriorsMatrixSumWithoutAFzero();
                double d = phredScaledConfidence = MathUtils.compareDoubles(sum, 0.0) == 0 ? 0.0 : -10.0 * sum;
            }
        }
        if (this.UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES && !this.passesEmitThreshold(phredScaledConfidence, bestGuessIsRef)) {
            return limitedContext ? null : this.estimateReferenceConfidence(vc, stratifiedContexts, this.getTheta(model), true, 1.0 - PofF);
        }
        GenomeLoc loc = this.genomeLocParser.createGenomeLoc(vc);
        VariantContextBuilder builder = new VariantContextBuilder("UG_call", loc.getContig(), loc.getStart(), loc.getStop(), myAlleles);
        builder.log10PError(phredScaledConfidence / -10.0);
        if (!this.passesCallThreshold(phredScaledConfidence)) {
            builder.filters(filter);
        }
        if (limitedContext) {
            builder.referenceBaseForIndel(vc.getReferenceBaseForIndel());
        } else {
            builder.referenceBaseForIndel(refContext.getBase());
        }
        GenotypesContext genotypes = this.afcm.get().subsetAlleles(vc, myAlleles, true, this.ploidy);
        if (this.verboseWriter != null && !limitedContext) {
            this.printVerboseData(refContext.getLocus().toString(), vc, PofF, phredScaledConfidence, model);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (!limitedContext && rawContext.hasPileupBeenDownsampled()) {
            attributes.put("DS", true);
        }
        if (this.UAC.ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED) {
            attributes.put(NUMBER_OF_DISCOVERED_ALLELES_KEY, vc.getAlternateAlleles().size());
        }
        if (!(this.UAC.NO_SLOD || limitedContext || bestGuessIsRef)) {
            double overallLog10PofF = AFresult.getLog10PosteriorsMatrixSumWithoutAFzero();
            List<Allele> alternateAllelesToUse = builder.make().getAlternateAlleles();
            VariantContext vcForward = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.FORWARD, alternateAllelesToUse, false, model);
            AFresult.reset();
            this.afcm.get().getLog10PNonRef(vcForward, this.getAlleleFrequencyPriors(model), AFresult);
            double forwardLog10PofNull = AFresult.getLog10PosteriorOfAFzero();
            double forwardLog10PofF = AFresult.getLog10PosteriorsMatrixSumWithoutAFzero();
            VariantContext vcReverse = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.REVERSE, alternateAllelesToUse, false, model);
            AFresult.reset();
            this.afcm.get().getLog10PNonRef(vcReverse, this.getAlleleFrequencyPriors(model), AFresult);
            double reverseLog10PofNull = AFresult.getLog10PosteriorOfAFzero();
            double reverseLog10PofF = AFresult.getLog10PosteriorsMatrixSumWithoutAFzero();
            double forwardLod = forwardLog10PofF + reverseLog10PofNull - overallLog10PofF;
            double reverseLod = reverseLog10PofF + forwardLog10PofNull - overallLog10PofF;
            double strandScore = Math.max(forwardLod, reverseLod);
            if (!Double.isNaN(strandScore *= 10.0)) {
                attributes.put("SB", strandScore);
            }
        }
        builder.genotypes(genotypes);
        builder.attributes(attributes);
        VariantContext vcCall = builder.make();
        if (myAlleles.size() != vc.getAlleles().size()) {
            vcCall = VariantContextUtils.reverseTrimAlleles(vcCall);
        }
        if (this.annotationEngine != null && !limitedContext && rawContext.hasBasePileup()) {
            ReadBackedPileup pileup = rawContext.getBasePileup();
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
            vcCall = this.annotationEngine.annotateContext(tracker, refContext, stratifiedContexts, vcCall);
        }
        return new VariantCallContext(vcCall, this.confidentlyCalled(phredScaledConfidence, PofF));
    }

    public static double[] generateNormalizedPosteriors(AlleleFrequencyCalculationResult AFresult, double[] normalizedPosteriors) {
        normalizedPosteriors[0] = AFresult.getLog10PosteriorOfAFzero();
        normalizedPosteriors[1] = AFresult.getLog10PosteriorsMatrixSumWithoutAFzero();
        return MathUtils.normalizeFromLog10(normalizedPosteriors);
    }

    private Map<String, AlignmentContext> getFilteredAndStratifiedContexts(UnifiedArgumentCollection UAC, ReferenceContext refContext, AlignmentContext rawContext, GenotypeLikelihoodsCalculationModel.Model model) {
        if (!BaseUtils.isRegularBase(refContext.getBase()) || !rawContext.hasBasePileup()) {
            return null;
        }
        Map<String, AlignmentContext> stratifiedContexts = null;
        if (model.name().contains("INDEL")) {
            ReadBackedPileup pileup = rawContext.getBasePileup().getMappingFilteredPileup(UAC.MIN_BASE_QUALTY_SCORE);
            if (pileup.getNumberOfElements() == 0 && UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES) {
                return null;
            }
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
        } else if (model.name().contains("SNP")) {
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(rawContext.getBasePileup());
            if (UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES || UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
                int numDeletions = 0;
                for (PileupElement p : rawContext.getBasePileup()) {
                    if (!p.isDeletion()) continue;
                    ++numDeletions;
                }
                if ((double)numDeletions / (double)rawContext.getBasePileup().getNumberOfElements() > UAC.MAX_DELETION_FRACTION) {
                    return null;
                }
            }
        }
        return stratifiedContexts;
    }

    private final double getRefBinomialProb(int depth) {
        if (depth < binomialProbabilityDepthCache.length) {
            return binomialProbabilityDepthCache[depth];
        }
        return MathUtils.binomialProbability(0, depth, 0.5);
    }

    private VariantCallContext estimateReferenceConfidence(VariantContext vc, Map<String, AlignmentContext> contexts, double theta, boolean ignoreCoveredSamples, double initialPofRef) {
        if (contexts == null) {
            return null;
        }
        double P_of_ref = initialPofRef;
        for (String sample : this.samples) {
            AlignmentContext context;
            boolean isCovered = contexts.containsKey(sample);
            if (ignoreCoveredSamples && isCovered) continue;
            int depth = 0;
            if (isCovered && (context = contexts.get(sample)).hasBasePileup()) {
                depth = context.getBasePileup().depthOfCoverage();
            }
            P_of_ref *= 1.0 - theta / 2.0 * this.getRefBinomialProb(depth);
        }
        return new VariantCallContext(vc, QualityUtils.phredScaleErrorRate(1.0 - P_of_ref) >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING, false);
    }

    protected void printVerboseData(String pos, VariantContext vc, double PofF, double phredScaledConfidence, GenotypeLikelihoodsCalculationModel.Model model) {
        Allele refAllele = null;
        Allele altAllele = null;
        for (Allele allele : vc.getAlleles()) {
            if (allele.isReference()) {
                refAllele = allele;
                continue;
            }
            altAllele = allele;
        }
        for (int i = 0; i <= this.N; ++i) {
            StringBuilder AFline = new StringBuilder("AFINFO\t");
            AFline.append(pos);
            AFline.append("\t");
            AFline.append(refAllele);
            AFline.append("\t");
            if (altAllele != null) {
                AFline.append(altAllele);
            } else {
                AFline.append("N/A");
            }
            AFline.append("\t");
            AFline.append(i + "/" + this.N + "\t");
            AFline.append(String.format("%.2f\t", Float.valueOf((float)i / (float)this.N)));
            AFline.append(String.format("%.8f\t", this.getAlleleFrequencyPriors(model)[i]));
            AFline.append(String.format("%.8f\t", this.alleleFrequencyCalculationResult.get().getLog10MLE()));
            AFline.append(String.format("%.8f\t", this.alleleFrequencyCalculationResult.get().getLog10MAP()));
            this.verboseWriter.println(AFline.toString());
        }
        this.verboseWriter.println("P(f>0) = " + PofF);
        this.verboseWriter.println("Qscore = " + phredScaledConfidence);
        this.verboseWriter.println();
    }

    protected boolean passesEmitThreshold(double conf, boolean bestGuessIsRef) {
        return (this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_CONFIDENT_SITES || !bestGuessIsRef) && conf >= Math.min(this.UAC.STANDARD_CONFIDENCE_FOR_CALLING, this.UAC.STANDARD_CONFIDENCE_FOR_EMITTING);
    }

    protected boolean passesCallThreshold(double conf) {
        return conf >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    protected boolean confidentlyCalled(double conf, double PofF) {
        return conf >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING || this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES && QualityUtils.phredScaleErrorRate(PofF) >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    private List<GenotypeLikelihoodsCalculationModel.Model> getGLModelsToUse(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        ArrayList<GenotypeLikelihoodsCalculationModel.Model> models = new ArrayList<GenotypeLikelihoodsCalculationModel.Model>(2);
        if (rawContext.hasBasePileup()) {
            if (this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
                VariantContext vcInput = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, refContext, rawContext.getLocation(), false, this.logger, this.UAC.alleles);
                if (vcInput == null) {
                    return models;
                }
                if (vcInput.isSNP()) {
                    if (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH) {
                        models.add(GenotypeLikelihoodsCalculationModel.Model.SNP);
                    } else if (this.UAC.GLmodel.name().toUpperCase().contains("SNP")) {
                        models.add(this.UAC.GLmodel);
                    }
                } else if (vcInput.isIndel() || vcInput.isMixed()) {
                    if (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH) {
                        models.add(GenotypeLikelihoodsCalculationModel.Model.INDEL);
                    } else if (this.UAC.GLmodel.name().toUpperCase().contains("INDEL")) {
                        models.add(this.UAC.GLmodel);
                    }
                }
            } else if (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH) {
                models.add(GenotypeLikelihoodsCalculationModel.Model.SNP);
                models.add(GenotypeLikelihoodsCalculationModel.Model.INDEL);
            } else {
                models.add(this.UAC.GLmodel);
            }
        }
        return models;
    }

    protected static void computeAlleleFrequencyPriors(int N, double[] priors, double theta) {
        double sum = 0.0;
        for (int i = 1; i <= N; ++i) {
            double value = theta / (double)i;
            priors[i] = Math.log10(value);
            sum += value;
        }
        priors[0] = Math.log10(1.0 - sum);
    }

    protected double[] getAlleleFrequencyPriors(GenotypeLikelihoodsCalculationModel.Model model) {
        if (model.name().toUpperCase().contains("SNP")) {
            return this.log10AlleleFrequencyPriorsSNPs;
        }
        if (model.name().toUpperCase().contains("INDEL")) {
            return this.log10AlleleFrequencyPriorsIndels;
        }
        throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
    }

    protected double getTheta(GenotypeLikelihoodsCalculationModel.Model model) {
        if (model.name().contains("SNP")) {
            return 0.001;
        }
        if (model.name().contains("INDEL")) {
            return 1.0E-4;
        }
        throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
    }

    private static Map<String, GenotypeLikelihoodsCalculationModel> getGenotypeLikelihoodsCalculationObject(Logger logger, UnifiedArgumentCollection UAC) {
        HashMap<String, GenotypeLikelihoodsCalculationModel> glcm = new HashMap<String, GenotypeLikelihoodsCalculationModel>();
        List<Class<GenotypeLikelihoodsCalculationModel>> glmClasses = new PluginManager<GenotypeLikelihoodsCalculationModel>(GenotypeLikelihoodsCalculationModel.class).getPlugins();
        for (int i = 0; i < glmClasses.size(); ++i) {
            Class<GenotypeLikelihoodsCalculationModel> glmClass = glmClasses.get(i);
            String key = glmClass.getSimpleName().replaceAll("GenotypeLikelihoodsCalculationModel", "").toUpperCase();
            try {
                Object[] args = new Object[]{UAC, logger};
                Constructor<GenotypeLikelihoodsCalculationModel> c = glmClass.getDeclaredConstructor(UnifiedArgumentCollection.class, Logger.class);
                glcm.put(key, c.newInstance(args));
                continue;
            }
            catch (Exception e) {
                throw new UserException("The likelihoods model provided for the -glm argument (" + (Object)((Object)UAC.GLmodel) + ") is not a valid option: " + e.getMessage());
            }
        }
        return glcm;
    }

    private static AlleleFrequencyCalculationModel getAlleleFrequencyCalculationObject(int N, Logger logger, PrintStream verboseWriter, UnifiedArgumentCollection UAC) {
        List<Class<AlleleFrequencyCalculationModel>> afClasses = new PluginManager<AlleleFrequencyCalculationModel>(AlleleFrequencyCalculationModel.class).getPlugins();
        for (int i = 0; i < afClasses.size(); ++i) {
            Class<AlleleFrequencyCalculationModel> afClass = afClasses.get(i);
            String key = afClass.getSimpleName().replace("AFCalculationModel", "").toUpperCase();
            if (!UAC.AFmodel.name().equalsIgnoreCase(key)) continue;
            try {
                Object[] args = new Object[]{UAC, N, logger, verboseWriter};
                Constructor<AlleleFrequencyCalculationModel> c = afClass.getDeclaredConstructor(UnifiedArgumentCollection.class, Integer.TYPE, Logger.class, PrintStream.class);
                return c.newInstance(args);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unexpected AlleleFrequencyCalculationModel " + (Object)((Object)UAC.AFmodel));
            }
        }
        throw new IllegalArgumentException("Unexpected AlleleFrequencyCalculationModel " + (Object)((Object)UAC.AFmodel));
    }

    public static VariantContext getVCFromAllelesRod(RefMetaDataTracker tracker, ReferenceContext ref, GenomeLoc loc, boolean requireSNP, Logger logger, RodBinding<VariantContext> allelesBinding) {
        if (tracker == null || ref == null || logger == null) {
            throw new ReviewedStingException("Bad arguments: tracker=" + tracker + " ref=" + ref + " logger=" + logger);
        }
        VariantContext vc = null;
        for (VariantContext vc_input : tracker.getValues(allelesBinding, loc)) {
            if (vc_input == null || vc_input.isFiltered() || requireSNP && !vc_input.isSNP()) continue;
            if (vc == null) {
                vc = vc_input;
                continue;
            }
            logger.warn("Multiple valid VCF records detected in the alleles input file at site " + ref.getLocus() + ", only considering the first record");
        }
        return vc;
    }

    static {
        for (int i = 1; i < binomialProbabilityDepthCache.length; ++i) {
            UnifiedGenotyperEngine.binomialProbabilityDepthCache[i] = MathUtils.binomialProbability(0, i, 0.5);
        }
    }

    public static enum OUTPUT_MODE {
        EMIT_VARIANTS_ONLY,
        EMIT_ALL_CONFIDENT_SITES,
        EMIT_ALL_SITES;

    }
}

