/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.fasta;

import java.io.PrintStream;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class FastaSequence {
    private PrintStream out;
    private StringBuffer sb = new StringBuffer();
    private long sequenceCounter = 1L;
    private boolean printedHeader = false;
    private String name = null;
    private int lineWidth = -1;
    private boolean noHeader = false;

    public FastaSequence(PrintStream out, int lineWidth, boolean noHeader) {
        this.out = out;
        this.lineWidth = lineWidth;
        this.noHeader = noHeader;
    }

    public void setName(String name) {
        if (this.printedHeader) {
            throw new ReviewedStingException("Can not set name for FASTA record: header is already printed.");
        }
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getCurrentID();
    }

    public void append(String s) {
        this.sb.append(s);
        this.printFasta(false);
    }

    public void flush() {
        this.printFasta(true);
        this.printedHeader = false;
        this.name = null;
        ++this.sequenceCounter;
    }

    public long getCurrentCount() {
        return this.sequenceCounter;
    }

    public String getCurrentID() {
        return String.valueOf(this.sequenceCounter);
    }

    private void printFasta(boolean printAll) {
        if (this.sb.length() == 0 || !printAll && this.sb.length() < this.lineWidth) {
            return;
        }
        if (!this.printedHeader && !this.noHeader) {
            if (this.name == null) {
                this.out.println(">" + this.sequenceCounter);
            } else {
                this.out.println(">" + this.name);
            }
            this.printedHeader = true;
        }
        int lines = this.sb.length() / this.lineWidth;
        int currentStart = 0;
        for (int i = 0; i < lines; ++i) {
            this.out.println(this.sb.substring(currentStart, currentStart + this.lineWidth));
            currentStart += this.lineWidth;
        }
        if (printAll) {
            this.out.println(this.sb.substring(currentStart));
            this.sb.setLength(0);
        } else {
            this.sb.delete(0, currentStart);
        }
    }
}

