/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.broadinstitute.sting.gatk.datasources.reads.BAMSchedule;
import org.broadinstitute.sting.gatk.datasources.reads.BAMScheduleEntry;
import org.broadinstitute.sting.gatk.datasources.reads.FilePointer;
import org.broadinstitute.sting.gatk.datasources.reads.GATKBAMIndex;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class BAMScheduler
implements Iterator<FilePointer> {
    private final SAMDataSource dataSource;
    private final Map<SAMReaderID, GATKBAMIndex> indexFiles = new HashMap<SAMReaderID, GATKBAMIndex>();
    private FilePointer nextFilePointer = null;
    private GenomeLocSortedSet loci;
    private PeekableIterator<GenomeLoc> locusIterator;
    private GenomeLoc currentLocus;
    private Integer lastReferenceSequenceLoaded = null;
    private PeekableIterator<BAMScheduleEntry> bamScheduleIterator = null;

    public static BAMScheduler createOverMappedReads(SAMDataSource dataSource, SAMSequenceDictionary referenceSequenceDictionary, GenomeLocParser parser) {
        BAMScheduler scheduler = new BAMScheduler(dataSource);
        GenomeLocSortedSet intervals = new GenomeLocSortedSet(parser);
        for (SAMSequenceRecord sequence : referenceSequenceDictionary.getSequences()) {
            if (dataSource.getHeader().getSequenceDictionary().getSequence(sequence.getSequenceName()) == null) continue;
            intervals.add(parser.createOverEntireContig(sequence.getSequenceName()));
        }
        scheduler.populateFilteredIntervalList(intervals);
        return scheduler;
    }

    public static BAMScheduler createOverAllReads(SAMDataSource dataSource, GenomeLocParser parser) {
        BAMScheduler scheduler = new BAMScheduler(dataSource);
        scheduler.populateUnfilteredIntervalList(parser);
        return scheduler;
    }

    public static BAMScheduler createOverIntervals(SAMDataSource dataSource, GenomeLocSortedSet loci) {
        BAMScheduler scheduler = new BAMScheduler(dataSource);
        scheduler.populateFilteredIntervalList(loci);
        return scheduler;
    }

    private BAMScheduler(SAMDataSource dataSource) {
        this.dataSource = dataSource;
        for (SAMReaderID reader : dataSource.getReaderIDs()) {
            GATKBAMIndex index = dataSource.getIndex(reader);
            if (index == null) continue;
            this.indexFiles.put(reader, dataSource.getIndex(reader));
        }
    }

    private void populateFilteredIntervalList(GenomeLocSortedSet loci) {
        this.loci = loci;
        if (!this.indexFiles.isEmpty()) {
            this.locusIterator = new PeekableIterator<GenomeLoc>(loci.iterator());
            if (this.locusIterator.hasNext()) {
                this.currentLocus = this.locusIterator.next();
            }
            this.advance();
        } else {
            this.nextFilePointer = this.generatePointerOverEntireFileset();
            for (GenomeLoc locus : loci) {
                this.nextFilePointer.addLocation(locus);
            }
            this.locusIterator = new PeekableIterator(Collections.emptyList().iterator());
        }
    }

    private void populateUnfilteredIntervalList(GenomeLocParser parser) {
        this.loci = new GenomeLocSortedSet(parser);
        this.locusIterator = new PeekableIterator(Collections.emptyList().iterator());
        this.nextFilePointer = this.generatePointerOverEntireFileset();
    }

    private FilePointer generatePointerOverEntireFileset() {
        FilePointer filePointer = new FilePointer(new GenomeLoc[0]);
        Map<SAMReaderID, GATKBAMFileSpan> currentPosition = this.dataSource.getCurrentPosition();
        for (SAMReaderID reader : this.dataSource.getReaderIDs()) {
            filePointer.addFileSpans(reader, this.createSpanToEndOfFile(currentPosition.get(reader).getGATKChunks().get(0).getChunkStart()));
        }
        return filePointer;
    }

    @Override
    public boolean hasNext() {
        return this.nextFilePointer != null;
    }

    @Override
    public FilePointer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element available in interval sharder");
        }
        FilePointer currentFilePointer = this.nextFilePointer;
        this.nextFilePointer = null;
        this.advance();
        return currentFilePointer;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unable to remove FilePointers from an IntervalSharder");
    }

    private void advance() {
        if (this.loci.isEmpty()) {
            return;
        }
        while (this.nextFilePointer == null && this.currentLocus != null) {
            if (this.currentLocus == GenomeLoc.UNMAPPED) {
                this.nextFilePointer = new FilePointer(GenomeLoc.UNMAPPED);
                for (SAMReaderID id : this.dataSource.getReaderIDs()) {
                    this.nextFilePointer.addFileSpans(id, this.createSpanToEndOfFile(this.indexFiles.get(id).getStartOfLastLinearBin()));
                }
                this.currentLocus = null;
                continue;
            }
            this.nextFilePointer = new FilePointer(new GenomeLoc[0]);
            int coveredRegionStart = 1;
            int coveredRegionStop = Integer.MAX_VALUE;
            GenomeLoc coveredRegion = null;
            BAMScheduleEntry scheduleEntry = this.getNextOverlappingBAMScheduleEntry(this.currentLocus);
            if (scheduleEntry != null) {
                coveredRegionStart = Math.max(coveredRegionStart, scheduleEntry.start);
                coveredRegionStop = Math.min(coveredRegionStop, scheduleEntry.stop);
                coveredRegion = this.loci.getGenomeLocParser().createGenomeLoc(this.currentLocus.getContig(), coveredRegionStart, coveredRegionStop);
                this.nextFilePointer.addFileSpans(scheduleEntry.fileSpans);
            } else {
                for (SAMReaderID reader : this.indexFiles.keySet()) {
                    this.nextFilePointer.addFileSpans(reader, new GATKBAMFileSpan());
                }
            }
            if (coveredRegion == null) {
                this.nextFilePointer.addLocation(this.currentLocus);
                this.currentLocus = this.locusIterator.hasNext() ? this.locusIterator.next() : null;
                continue;
            }
            if (this.currentLocus.startsBefore(coveredRegion)) {
                int splitPoint = Math.min(coveredRegion.getStart() - this.currentLocus.getStart(), 16384) + this.currentLocus.getStart();
                GenomeLoc[] splitContigs = this.currentLocus.split(splitPoint);
                this.nextFilePointer.addLocation(splitContigs[0]);
                this.currentLocus = splitContigs[1];
                continue;
            }
            GenomeLoc initialLocation = this.currentLocus.intersect(coveredRegion);
            this.nextFilePointer.addLocation(initialLocation);
            if (this.nextFilePointer.locations.isEmpty()) continue;
            while (this.locusIterator.hasNext() && this.locusIterator.peek().overlapsP(coveredRegion)) {
                this.currentLocus = this.locusIterator.next();
                this.nextFilePointer.addLocation(this.currentLocus.intersect(coveredRegion));
            }
            if (coveredRegionStop < this.currentLocus.getStop()) {
                this.currentLocus = this.loci.getGenomeLocParser().createGenomeLoc(this.currentLocus.getContig(), coveredRegionStop + 1, this.currentLocus.getStop());
                continue;
            }
            if (this.locusIterator.hasNext()) {
                this.currentLocus = this.locusIterator.next();
                continue;
            }
            this.currentLocus = null;
        }
    }

    private BAMScheduleEntry getNextOverlappingBAMScheduleEntry(GenomeLoc currentLocus) {
        SAMSequenceRecord currentContigSequenceRecord = this.dataSource.getHeader().getSequence(currentLocus.getContig());
        if (currentContigSequenceRecord == null) {
            throw new UserException(String.format("Contig %s not present in sequence dictionary for merged BAM header: %s", currentLocus.getContig(), ReadUtils.prettyPrintSequenceRecords(this.dataSource.getHeader().getSequenceDictionary())));
        }
        int currentContigIndex = currentContigSequenceRecord.getSequenceIndex();
        if (this.lastReferenceSequenceLoaded == null || this.lastReferenceSequenceLoaded != currentContigIndex) {
            if (this.bamScheduleIterator != null) {
                this.bamScheduleIterator.close();
            }
            this.lastReferenceSequenceLoaded = currentContigIndex;
            LinkedList<GenomeLoc> lociInContig = new LinkedList<GenomeLoc>();
            for (GenomeLoc locus : this.loci) {
                if (GenomeLoc.isUnmapped(locus) || this.dataSource.getHeader().getSequence(locus.getContig()).getSequenceIndex() != this.lastReferenceSequenceLoaded.intValue()) continue;
                lociInContig.add(locus);
            }
            this.bamScheduleIterator = new PeekableIterator<BAMScheduleEntry>(new BAMSchedule(this.dataSource, lociInContig));
        }
        if (!this.bamScheduleIterator.hasNext()) {
            return null;
        }
        BAMScheduleEntry bamScheduleEntry = this.bamScheduleIterator.peek();
        while (bamScheduleEntry != null && bamScheduleEntry.isBefore(currentLocus)) {
            this.bamScheduleIterator.next();
            bamScheduleEntry = this.bamScheduleIterator.hasNext() ? this.bamScheduleIterator.peek() : null;
        }
        return bamScheduleEntry != null && bamScheduleEntry.overlaps(currentLocus) ? bamScheduleEntry : null;
    }

    private GATKBAMFileSpan createSpanToEndOfFile(long startOfRegion) {
        return new GATKBAMFileSpan(new GATKChunk(startOfRegion, Long.MAX_VALUE));
    }
}

