/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.filter;

import java.util.Iterator;
import java.util.List;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;

public class IntervalFilter
implements SamRecordFilter {
    private final Iterator<Interval> intervals;
    private final SAMFileHeader samHeader;
    private Interval currentInterval;
    private int currentSequenceIndex;

    public IntervalFilter(List<Interval> intervals, SAMFileHeader samHeader) {
        this.samHeader = samHeader;
        IntervalUtil.assertOrderedNonOverlapping(intervals.iterator(), samHeader.getSequenceDictionary());
        this.intervals = intervals.iterator();
        this.advanceInterval();
    }

    @Override
    public boolean filterOut(SAMRecord record) {
        while (this.currentInterval != null && (this.currentSequenceIndex < record.getReferenceIndex() || this.currentSequenceIndex == record.getReferenceIndex() && this.currentInterval.getEnd() < record.getAlignmentStart())) {
            this.advanceInterval();
        }
        return this.currentInterval == null || this.currentSequenceIndex != record.getReferenceIndex() || this.currentInterval.getStart() > record.getAlignmentEnd();
    }

    private void advanceInterval() {
        if (this.intervals.hasNext()) {
            this.currentInterval = this.intervals.next();
            this.currentSequenceIndex = this.samHeader.getSequenceIndex(this.currentInterval.getSequence());
        } else {
            this.currentInterval = null;
        }
    }

    public boolean filterOut(SAMRecord first, SAMRecord second) {
        throw new UnsupportedOperationException("Paired IntervalFilter filter not implemented!");
    }
}

