/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.Loader;
import java.net.URL;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";

    public static void configureByResource(LoggerContext loggerContext, URL url) throws JoranException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(loggerContext);
        configurator.doConfigure(url);
    }

    public static void autoConfig(LoggerContext loggerContext, ClassLoader classLoader) throws JoranException {
        URL url = Loader.getResource(TEST_AUTOCONFIG_FILE, classLoader);
        if (url == null) {
            url = Loader.getResource(AUTOCONFIG_FILE, classLoader);
        }
        if (url != null) {
            ContextInitializer.configureByResource(loggerContext, url);
        } else {
            BasicConfigurator.configure(loggerContext);
        }
    }

    public static void autoConfig(LoggerContext loggerContext) throws JoranException {
        ClassLoader tccl = Loader.getTCL();
        ContextInitializer.autoConfig(loggerContext, tccl);
    }
}

