/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.analysis;

public enum AminoAcid {
    Alanine("Alanine", "Ala", "A", new String[]{"GCA", "GCC", "GCG", "GCT"}),
    Arganine("Arganine", "Arg", "R", new String[]{"AGA", "AGG", "CGA", "CGC", "CGG", "CGT"}),
    Asparagine("Asparagine", "Asn", "N", new String[]{"AAC", "AAT"}),
    Aspartic_acid("Aspartic acid", "Asp", "D", new String[]{"GAT", "GAC"}),
    Cysteine("Cysteine", "Cys", "C", new String[]{"TGC", "TGC"}),
    Glutamic_acid("Glutamic acid", "Glu", "E", new String[]{"GAA", "GAG"}),
    Glutamine("Glutamine", "Gln", "Q", new String[]{"CAA", "CAG"}),
    Glycine("Glycine", "Gly", "G", new String[]{"GGA", "GGC", "GGG", "GGT"}),
    Histidine("Histidine", "His", "H", new String[]{"CAC", "CAT"}),
    Isoleucine("Isoleucine", "Ile", "I", new String[]{"ATA", "ATC", "ATT"}),
    Leucine("Leucine", "Leu", "L", new String[]{"CTA", "CTC", "CTG", "CTT", "TTA", "TTG"}),
    Lysine("Lysine", "Lys", "K", new String[]{"AAA", "AAG"}),
    Methionine("Methionine", "Met", "M", new String[]{"ATG"}),
    Phenylalanine("Phenylalanine", "Phe", "F", new String[]{"TTC", "TTT"}),
    Proline("Proline", "Pro", "P", new String[]{"CCA", "CCC", "CCG", "CCT"}),
    Serine("Serine", "Ser", "S", new String[]{"AGC", "AGT", "TCA", "TCC", "TCG", "TCT"}),
    Stop_codon("Stop codon", "Stop", "*", new String[]{"TAA", "TAG", "TGA"}),
    Threonine("Threonine", "Thr", "T", new String[]{"ACA", "ACC", "ACG", "ACT"}),
    Tryptophan("Tryptophan", "Trp", "W", new String[]{"TGG"}),
    Tyrosine("Tyrosine", "Tyr", "Y", new String[]{"TAC", "TAT"}),
    Valine("Valine", "Val", "V", new String[]{"GTA", "GTC", "GTG", "GTT"});

    String[] codons;
    String fullName;
    String code;
    String letter;

    private AminoAcid(String name, String shortName, String abbrev, String[] myCodons) {
        this.codons = myCodons;
        this.fullName = name;
        this.code = shortName;
        this.letter = abbrev;
    }

    public String getName() {
        return this.fullName;
    }

    public String getLetter() {
        return this.letter;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isStop() {
        return this == Stop_codon;
    }

    public String toString() {
        return this.getName();
    }
}

