/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.util;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager.StratificationManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public final class EvaluationContext {
    final VariantEvalWalker walker;
    private final ArrayList<VariantEvaluator> evaluationInstances;
    private final Set<Class<? extends VariantEvaluator>> evaluationClasses;
    public static final EvaluationContextCombiner COMBINER = new EvaluationContextCombiner();

    public EvaluationContext(VariantEvalWalker walker, Set<Class<? extends VariantEvaluator>> evaluationClasses) {
        this(walker, evaluationClasses, true);
    }

    private EvaluationContext(VariantEvalWalker walker, Set<Class<? extends VariantEvaluator>> evaluationClasses, boolean doInitialize) {
        this.walker = walker;
        this.evaluationClasses = evaluationClasses;
        this.evaluationInstances = new ArrayList(evaluationClasses.size());
        for (Class<? extends VariantEvaluator> c : evaluationClasses) {
            try {
                VariantEvaluator eval = c.newInstance();
                if (doInitialize) {
                    eval.initialize(walker);
                }
                this.evaluationInstances.add(eval);
            }
            catch (InstantiationException e) {
                throw new ReviewedStingException("Unable to instantiate eval module '" + c.getSimpleName() + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new ReviewedStingException("Illegal access error when trying to instantiate eval module '" + c.getSimpleName() + "'", e);
            }
        }
    }

    public final TreeSet<VariantEvaluator> getVariantEvaluators() {
        return new TreeSet<VariantEvaluator>(this.evaluationInstances);
    }

    public final void apply(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context, VariantContext comp, VariantContext eval) {
        block4: for (VariantEvaluator evaluation : this.evaluationInstances) {
            if (tracker == null) continue;
            switch (evaluation.getComparisonOrder()) {
                case 1: {
                    if (eval == null) continue block4;
                    evaluation.update1(eval, tracker, ref, context);
                    continue block4;
                }
                case 2: {
                    evaluation.update2(eval, comp, tracker, ref, context);
                    continue block4;
                }
            }
            throw new ReviewedStingException("BUG: Unexpected evaluation order " + evaluation);
        }
    }

    public void combine(EvaluationContext rhs) {
        for (int i = 0; i < this.evaluationInstances.size(); ++i) {
            this.evaluationInstances.get(i).combine(rhs.evaluationInstances.get(i));
        }
    }

    private static class EvaluationContextCombiner
    implements StratificationManager.Combiner<EvaluationContext> {
        private EvaluationContextCombiner() {
        }

        @Override
        public EvaluationContext combine(EvaluationContext lhs, EvaluationContext rhs) {
            if (lhs == null) {
                lhs = new EvaluationContext(rhs.walker, rhs.evaluationClasses, false);
            }
            lhs.combine(rhs);
            return lhs;
        }
    }
}

