/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.validation;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.alignment.Alignment;
import org.broadinstitute.sting.alignment.bwa.BWAConfiguration;
import org.broadinstitute.sting.alignment.bwa.BWTFiles;
import org.broadinstitute.sting.alignment.bwa.c.BWACAligner;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.table.TableFeature;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Requires(value={DataSource.REFERENCE})
public class ValidationAmplicons
extends RodWalker<Integer, Integer> {
    @Input(fullName="ProbeIntervals", doc="A collection of intervals in table format with optional names that represent the intervals surrounding the probe sites amplicons should be designed for", required=true)
    RodBinding<TableFeature> probeIntervals;
    @Input(fullName="ValidateAlleles", doc="A VCF containing the sites and alleles you want to validate. Restricted to *BI-Allelic* sites", required=true)
    RodBinding<VariantContext> validateAlleles;
    @Input(fullName="MaskAlleles", doc="A VCF containing the sites you want to MASK from the designed amplicon (e.g. by Ns or lower-cased bases)", required=true)
    RodBinding<VariantContext> maskAlleles;
    @Argument(doc="Lower case SNPs rather than replacing with 'N'", fullName="lowerCaseSNPs", required=false)
    boolean lowerCaseSNPs = false;
    @Argument(doc="Only output valid sequences.", fullName="onlyOutputValidAmplicons", required=false)
    boolean onlyOutputValidAmplicons = false;
    @Argument(doc="Ignore complex genomic records.", fullName="ignoreComplexEvents", required=false)
    boolean ignoreComplexEvents = false;
    @Argument(doc="Size of the virtual primer to use for lower-casing regions with low specificity", fullName="virtualPrimerSize", required=false)
    int virtualPrimerSize = 20;
    @Argument(doc="Monomorphic sites in the mask file will be treated as filtered", fullName="filterMonomorphic", required=false)
    boolean filterMonomorphic = false;
    @Argument(doc="Do not use BWA, lower-case repeats only", fullName="doNotUseBWA", required=false)
    boolean doNotUseBWA = false;
    @Hidden
    @Argument(doc="Use Sequenom output format instead of regular FASTA", fullName="sqnm", required=false)
    boolean sequenomOutput = false;
    @Hidden
    @Argument(doc="Use ILMN output format instead of regular FASTA", fullName="ilmn", required=false)
    boolean ilmnOutput = false;
    GenomeLoc prevInterval;
    GenomeLoc allelePos;
    String probeName;
    StringBuilder sequence;
    StringBuilder rawSequence;
    boolean sequenceInvalid;
    boolean isSiteSNP;
    boolean isSiteIndel;
    List<String> invReason;
    int indelCounter;
    @Argument(fullName="target_reference", shortName="target_ref", doc="The reference to which reads in the source file should be aligned.  Alongside this reference should sit index files generated by bwa index -d bwtsw.  If unspecified, will default to the reference specified via the -R argument.", required=false)
    private File targetReferenceFile = null;
    @Output
    PrintStream out;
    BWACAligner aligner = null;
    private SAMFileHeader header = null;

    @Override
    public void initialize() {
        if (!this.doNotUseBWA) {
            if (this.targetReferenceFile == null) {
                this.targetReferenceFile = this.getToolkit().getArguments().referenceFile;
            }
            BWTFiles bwtFiles = new BWTFiles(this.targetReferenceFile.getAbsolutePath());
            BWAConfiguration configuration = new BWAConfiguration();
            this.aligner = new BWACAligner(bwtFiles, configuration);
            this.header = new SAMFileHeader();
            SAMSequenceDictionary referenceDictionary = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.targetReferenceFile).getSequenceDictionary();
            this.header.setSequenceDictionary(referenceDictionary);
            this.header.setSortOrder(SAMFileHeader.SortOrder.unsorted);
        }
        if (this.ilmnOutput) {
            this.out.println("Locus_Name,Target_Type,Sequence,Chromosome,Coordinate,Genome_Build_Version,Source,Source_Version,Sequence_Orientation,Plus_Minus,Force_Infinium_I");
        }
    }

    @Override
    public Integer reduceInit() {
        this.prevInterval = null;
        this.sequence = null;
        this.rawSequence = null;
        this.sequenceInvalid = false;
        this.probeName = null;
        this.invReason = null;
        this.indelCounter = 0;
        return 0;
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null || !tracker.hasValues(this.probeIntervals)) {
            return null;
        }
        TableFeature feature = tracker.getFirstValue(this.probeIntervals);
        GenomeLoc interval = feature.getLocation();
        if (this.prevInterval == null || !interval.equals(this.prevInterval)) {
            if (this.prevInterval != null) {
                this.validateSequence();
                if (this.doNotUseBWA) {
                    this.lowerRepeats();
                } else {
                    this.lowerNonUniqueSegments();
                }
                this.print();
            }
            this.prevInterval = interval;
            this.allelePos = null;
            this.sequence = new StringBuilder();
            this.rawSequence = new StringBuilder();
            this.sequenceInvalid = false;
            this.invReason = new LinkedList<String>();
            logger.debug(Utils.join("\t", feature.getAllValues()));
            this.probeName = feature.getValue(1);
            this.indelCounter = 0;
        }
        VariantContext mask = tracker.getFirstValue(this.maskAlleles, ref.getLocus());
        VariantContext validate = tracker.getFirstValue(this.validateAlleles, ref.getLocus());
        if (mask == null && validate == null) {
            if (this.indelCounter > 0) {
                this.sequence.append('N');
                --this.indelCounter;
            } else {
                this.sequence.append(Character.toUpperCase((char)ref.getBase()));
            }
            this.rawSequence.append(Character.toUpperCase((char)ref.getBase()));
        } else if (validate != null) {
            this.isSiteSNP = validate.isSNP();
            this.isSiteIndel = validate.isIndel();
            if (validate.isFiltered()) {
                logger.warn("You are attempting to validate a filtered site. Why are you attempting to validate a filtered site? You should not be attempting to validate a filtered site.");
                this.sequenceInvalid = true;
                this.invReason.add("SITE_IS_FILTERED");
            }
            if (validate.isIndel()) {
                this.sequence.append(Character.toUpperCase((char)ref.getBase()));
                this.rawSequence.append(Character.toUpperCase((char)ref.getBase()));
            }
            this.sequence.append('[');
            this.sequence.append(validate.getAlternateAllele(0).toString());
            this.sequence.append('/');
            this.sequence.append(validate.getReference().toString());
            this.sequence.append(']');
            this.rawSequence.append('[');
            this.rawSequence.append(validate.getAlternateAllele(0).getBaseString());
            this.rawSequence.append('/');
            this.rawSequence.append(validate.getReference().getBaseString());
            this.rawSequence.append(']');
            this.allelePos = ref.getLocus();
            if (this.indelCounter > 0) {
                logger.warn("An indel event overlaps the event to be validated. This completely invalidates the probe.");
                this.sequenceInvalid = true;
                this.invReason.add("INDEL_OVERLAPS_VALIDATION_SITE");
                this.indelCounter = validate.isSNP() ? --this.indelCounter : (this.indelCounter -= validate.getEnd() - validate.getStart());
            }
        } else if (!(mask.isSNP() || mask.isFiltered() || this.filterMonomorphic && mask.isMonomorphicInSamples())) {
            int indelCounterNew;
            logger.warn("Mask Variant Context on the following warning line is not a SNP. Currently we can only mask out SNPs. This probe will not be designed.");
            logger.warn(String.format("%s:%d-%d\t%s\t%s", mask.getChr(), mask.getStart(), mask.getEnd(), mask.isSimpleInsertion() ? "INS" : "DEL", Utils.join(",", mask.getAlleles())));
            this.sequenceInvalid = true;
            this.invReason.add(mask.isSimpleInsertion() ? "INSERTION" : "DELETION");
            int n = indelCounterNew = mask.isSimpleInsertion() ? 2 : mask.getEnd() - mask.getStart();
            if (indelCounterNew > this.indelCounter) {
                this.indelCounter = indelCounterNew;
            }
            this.sequence.append("N");
            --this.indelCounter;
            this.rawSequence.append(Character.toUpperCase((char)ref.getBase()));
        } else if (this.indelCounter > 0) {
            this.sequence.append('N');
            --this.indelCounter;
            this.rawSequence.append(Character.toUpperCase((char)ref.getBase()));
        } else if (!(mask.isFiltered() || this.filterMonomorphic && mask.isMonomorphicInSamples())) {
            logger.debug("SNP in mask found at " + ref.getLocus().toString());
            if (this.lowerCaseSNPs) {
                this.sequence.append(Character.toLowerCase((char)ref.getBase()));
            } else {
                this.sequence.append('N');
            }
            this.rawSequence.append(Character.toUpperCase((char)ref.getBase()));
        } else if (mask.isSNP()) {
            logger.debug("SNP in mask found at " + ref.getLocus().toString() + " but was either filtered or monomorphic");
            this.sequence.append(Character.toUpperCase((char)ref.getBase()));
            this.rawSequence.append(Character.toUpperCase((char)ref.getBase()));
        }
        return 1;
    }

    @Override
    public Integer reduce(Integer i, Integer j) {
        return 0;
    }

    @Override
    public void onTraversalDone(Integer fin) {
        this.validateSequence();
        if (this.doNotUseBWA) {
            this.lowerRepeats();
        } else {
            this.lowerNonUniqueSegments();
            this.aligner.close();
        }
        this.print();
    }

    public void validateSequence() {
        String seq = this.sequence.toString();
        int start = seq.indexOf(91) - 4;
        int end = seq.indexOf(93) + 5;
        if (start < 50) {
            logger.warn("There is not enough sequence before the start position of the probed allele for adequate probe design. This site will not be designed.");
            this.sequenceInvalid = true;
            this.invReason.add("START_TOO_CLOSE");
        } else if (end > seq.length() - 50) {
            logger.warn("There is not enough sequence after the end position of the probed allele fore adequate probe design. This site will not be desinged. ");
            this.sequenceInvalid = true;
            this.invReason.add("END_TOO_CLOSE");
        } else {
            boolean maskNearVariantSite = false;
            for (int i = start; i < end; ++i) {
                maskNearVariantSite |= seq.charAt(i) == 'N' || Character.isLowerCase(seq.charAt(i));
            }
            if (maskNearVariantSite) {
                logger.warn("There is one (or more) mask variants within 4 basepair of the variant given for validation. This site will not be designed.");
                this.sequenceInvalid = true;
                this.invReason.add("VARIANT_TOO_NEAR_PROBE");
            }
        }
        if (seq.indexOf("[") != seq.lastIndexOf("[")) {
            logger.warn("Multiple probe variants were found within this interval. Please fix the definitions of the intervals so they do not overlap.");
            this.sequenceInvalid = true;
            this.invReason.add("MULTIPLE_PROBES");
        }
        if (seq.indexOf("[") < 0) {
            logger.warn("No variants in region were found. This site will not be designed.");
            this.sequenceInvalid = true;
            this.invReason.add("NO_VARIANTS_FOUND");
        }
    }

    public void lowerNonUniqueSegments() {
        if (!this.invReason.contains("MULTIPLE_PROBES") && !this.invReason.contains("NO_VARIANTS_FOUND")) {
            String leftFlank = this.rawSequence.toString().split("\\[")[0];
            String rightFlank = this.rawSequence.toString().split("\\]")[1];
            List<Integer> badLeft = this.getBadIndeces(leftFlank);
            List<Integer> badRight = this.getBadIndeces(rightFlank);
            for (int idx = 0; idx < leftFlank.length(); ++idx) {
                while (badLeft.size() > 0 && idx > badLeft.get(0) + this.virtualPrimerSize) {
                    badLeft.remove(0);
                }
                if (badLeft.size() <= 0 || badLeft.get(0) > idx || idx > badLeft.get(0) + this.virtualPrimerSize) continue;
                this.sequence.setCharAt(idx, Character.toLowerCase(this.sequence.charAt(idx)));
            }
            int offset = 1 + this.rawSequence.indexOf("]");
            for (int i = 0; i < rightFlank.length(); ++i) {
                int idx = i + offset;
                while (badRight.size() > 0 && i > badRight.get(0) + this.virtualPrimerSize) {
                    badRight.remove(0);
                }
                if (badRight.size() <= 0 || badRight.get(0) > i || i > badRight.get(0) + this.virtualPrimerSize) continue;
                this.sequence.setCharAt(idx, Character.toLowerCase(this.sequence.charAt(idx)));
            }
        }
    }

    private List<Integer> getBadIndeces(String sequence) {
        ArrayList<Integer> badLeftIndeces = new ArrayList<Integer>(sequence.length() - this.virtualPrimerSize);
        for (int i = 0; i < sequence.length() - this.virtualPrimerSize; ++i) {
            String toAlign = sequence.substring(i, i + this.virtualPrimerSize);
            Iterable<Alignment[]> allAlignments = this.aligner.getAllAlignments(toAlign.getBytes());
            for (Alignment[] alignments : allAlignments) {
                if (alignments.length <= 1 || alignments[0].getMappingQuality() != 0) continue;
                badLeftIndeces.add(i);
            }
        }
        return badLeftIndeces;
    }

    public void lowerRepeats() {
        int K_LIM = 8;
        String seq = this.sequence.toString();
        StringBuilder newSequence = new StringBuilder();
        int start_pos = 0;
        while (start_pos < seq.length()) {
            boolean broke = false;
            for (int length = 8; length > 1; --length) {
                if (start_pos + 2 * length > seq.length() || !this.equalsIgnoreNs(seq.substring(start_pos, start_pos + length), seq.substring(start_pos + length, start_pos + 2 * length))) continue;
                newSequence.append(seq.substring(start_pos, start_pos + length).toLowerCase());
                newSequence.append(seq.substring(start_pos + length, start_pos + 2 * length).toLowerCase());
                start_pos += 2 * length;
                broke = true;
                break;
            }
            if (broke) continue;
            newSequence.append(seq.substring(start_pos, start_pos + 1));
            ++start_pos;
        }
        if (seq.indexOf("[") != seq.lastIndexOf("[")) {
            return;
        }
        this.sequence = newSequence;
    }

    public boolean equalsIgnoreNs(String one, String two) {
        if (one.length() != two.length()) {
            return false;
        }
        for (int idx = 0; idx < one.length(); ++idx) {
            if (Character.toUpperCase(one.charAt(idx)) == Character.toUpperCase(two.charAt(idx)) || Character.toUpperCase(one.charAt(idx)) == 'N' || Character.toUpperCase(two.charAt(idx)) == 'N') continue;
            return false;
        }
        return true;
    }

    public void print() {
        String valid;
        if (this.sequenceInvalid) {
            valid = "";
            while (this.invReason.size() > 0) {
                String reason = this.invReason.get(0);
                this.invReason.remove(reason);
                int num = 1;
                while (this.invReason.contains(reason)) {
                    ++num;
                    this.invReason.remove(reason);
                }
                valid = valid + String.format("%s=%d,", reason, num);
            }
        } else {
            valid = "Valid";
        }
        if (this.ignoreComplexEvents && !this.isSiteIndel && !this.isSiteSNP) {
            return;
        }
        if (!this.onlyOutputValidAmplicons || !this.sequenceInvalid) {
            String seqIdentity = this.sequence.toString().replace('n', 'N').replace('i', 'I').replace('d', 'D');
            if (this.sequenomOutput) {
                seqIdentity = seqIdentity.replace("*", "");
                this.probeName = this.probeName.replace("amplicon_", "a");
                this.out.printf("%s_%s %s%n", this.allelePos != null ? this.allelePos.toString() : "multiple", this.probeName, seqIdentity);
            } else if (this.ilmnOutput) {
                String type = this.isSiteSNP ? "SNP" : (this.isSiteIndel ? "INDEL" : "OTHER");
                seqIdentity = seqIdentity.replace("*", "");
                this.out.printf("%s,%s,%s,%s,%d,37,1000G,ExomePhase1,Forward,Plus,FALSE%n", this.probeName, type, seqIdentity, this.allelePos.getContig(), this.allelePos.getStart());
            } else {
                this.out.printf(">%s %s %s%n%s%n", this.allelePos != null ? this.allelePos.toString() : "multiple", valid, this.probeName, seqIdentity);
            }
        }
    }
}

