/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.methyl.rrbs.caller;

import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMRecord;
import org.rbio.methyl.rrbs.util.Fragment;

public class UniqueFilter {
    /*
     * WARNING - void declaration
     */
    public static UniqueRecord getUniqueSERecord(List<SAMRecord> rec_lst, Map<String, Fragment> frag_tab) {
        void var3_7;
        SAMRecord uniq_rec = null;
        for (SAMRecord sAMRecord : rec_lst) {
            if (sAMRecord.getReadUnmappedFlag()) continue;
            Fragment frag = frag_tab.get(sAMRecord.getReferenceName());
            int adapter_len = frag.adapterLength(sAMRecord.getReadLength());
            if (sAMRecord.getAlignmentStart() != adapter_len + 1) continue;
            if (uniq_rec == null) {
                uniq_rec = sAMRecord;
                continue;
            }
            uniq_rec = null;
            break;
        }
        Object var3_5 = null;
        if (uniq_rec != null) {
            UniqueRecord uniqueRecord = new UniqueRecord(uniq_rec, null);
        }
        return var3_7;
    }

    public static UniqueRecord getUniquePERecord(List<SAMRecord> rec1_lst, List<SAMRecord> rec2_lst, Map<String, Fragment> frag_tab) {
        SAMRecord uniq_rec1 = null;
        SAMRecord uniq_rec2 = null;
        int paired_align_cntr = 0;
        for (SAMRecord rec1 : rec1_lst) {
            if (rec1.getReadUnmappedFlag()) continue;
            for (SAMRecord rec2 : rec2_lst) {
                if (rec2.getReadUnmappedFlag() || rec1.getReferenceName().compareTo(rec2.getReferenceName()) != 0) continue;
                Fragment frag = frag_tab.get(rec1.getReferenceName());
                int adapter_len = frag.adapterLength(rec1.getReadLength());
                if (rec1.getAlignmentStart() != adapter_len + 1 || rec2.getAlignmentEnd() != frag.length() + adapter_len) continue;
                uniq_rec1 = rec1;
                uniq_rec2 = rec2;
                ++paired_align_cntr;
            }
            if (paired_align_cntr > 1) break;
        }
        UniqueRecord rec = null;
        if (paired_align_cntr == 1) {
            rec = new UniqueRecord(uniq_rec1, uniq_rec2);
        }
        return rec;
    }

    public static class UniqueRecord {
        public SAMRecord rec1 = null;
        public SAMRecord rec2 = null;

        public UniqueRecord(SAMRecord rec1, SAMRecord rec2) {
            this.rec1 = rec1;
            this.rec2 = rec2;
        }
    }
}

