/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.CommonInfo;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class VariantContext
implements Feature {
    protected CommonInfo commonInfo = null;
    public static final double NO_LOG10_PERROR = 1.0;
    @Deprecated
    private static final String ID_KEY = "ID";
    private final Byte REFERENCE_BASE_FOR_INDEL;
    public static final Set<String> PASSES_FILTERS = Collections.unmodifiableSet(new LinkedHashSet());
    protected final String contig;
    protected final long start;
    protected final long stop;
    private final String ID;
    protected Type type = null;
    protected final List<Allele> alleles;
    protected GenotypesContext genotypes = null;
    protected int[] genotypeCounts = null;
    public static final GenotypesContext NO_GENOTYPES = GenotypesContext.NO_GENOTYPES;
    private Allele REF = null;
    private Allele ALT = null;
    private Boolean monomorphic = null;
    private static final EnumSet<Validation> ALL_VALIDATION = EnumSet.allOf(Validation.class);
    private static final EnumSet<Validation> NO_VALIDATION = EnumSet.noneOf(Validation.class);

    protected VariantContext(VariantContext other) {
        this(other.getSource(), other.getID(), other.getChr(), other.getStart(), other.getEnd(), other.getAlleles(), other.getGenotypes(), other.getLog10PError(), other.getFiltersMaybeNull(), other.getAttributes(), other.REFERENCE_BASE_FOR_INDEL, NO_VALIDATION);
    }

    protected VariantContext(String source, String ID, String contig, long start, long stop, Collection<Allele> alleles, GenotypesContext genotypes, double log10PError, Set<String> filters, Map<String, Object> attributes, Byte referenceBaseForIndel, EnumSet<Validation> validationToPerform) {
        if (contig == null) {
            throw new IllegalArgumentException("Contig cannot be null");
        }
        this.contig = contig;
        this.start = start;
        this.stop = stop;
        if (ID == null || ID.equals("")) {
            throw new IllegalArgumentException("ID field cannot be the null or the empty string");
        }
        this.ID = ID.equals(".") ? "." : ID;
        this.commonInfo = new CommonInfo(source, log10PError, filters, attributes);
        this.REFERENCE_BASE_FOR_INDEL = referenceBaseForIndel;
        if (this.commonInfo.hasAttribute(ID_KEY)) {
            throw new IllegalArgumentException("Trying to create a VariantContext with a ID key.  Please use provided constructor argument ID");
        }
        if (alleles == null) {
            throw new IllegalArgumentException("Alleles cannot be null");
        }
        this.alleles = VariantContext.makeAlleles(alleles);
        this.genotypes = genotypes == null || genotypes == NO_GENOTYPES ? NO_GENOTYPES : genotypes.immutable();
        int nAlleles = alleles.size();
        for (Allele a : alleles) {
            if (a.isReference()) {
                this.REF = a;
                continue;
            }
            if (nAlleles != 2) continue;
            this.ALT = a;
        }
        if (!validationToPerform.isEmpty()) {
            this.validate(validationToPerform);
        }
    }

    public VariantContext subContextFromSamples(Set<String> sampleNames, Collection<Allele> alleles) {
        VariantContextBuilder builder = new VariantContextBuilder(this);
        return builder.genotypes(this.genotypes.subsetToSamples(sampleNames)).alleles(alleles).make();
    }

    public VariantContext subContextFromSamples(Set<String> sampleNames) {
        VariantContextBuilder builder = new VariantContextBuilder(this);
        GenotypesContext newGenotypes = this.genotypes.subsetToSamples(sampleNames);
        return builder.genotypes(newGenotypes).alleles(this.allelesOfGenotypes(newGenotypes)).make();
    }

    public VariantContext subContextFromSample(String sampleName) {
        return this.subContextFromSamples(Collections.singleton(sampleName));
    }

    private final Set<Allele> allelesOfGenotypes(Collection<Genotype> genotypes) {
        HashSet<Allele> alleles = new HashSet<Allele>();
        boolean addedref = false;
        for (Genotype g : genotypes) {
            for (Allele a : g.getAlleles()) {
                boolean bl = addedref = addedref || a.isReference();
                if (!a.isCalled()) continue;
                alleles.add(a);
            }
        }
        if (!addedref) {
            alleles.add(this.getReference());
        }
        return alleles;
    }

    public Type getType() {
        if (this.type == null) {
            this.determineType();
        }
        return this.type;
    }

    public boolean isSNP() {
        return this.getType() == Type.SNP;
    }

    public boolean isVariant() {
        return this.getType() != Type.NO_VARIATION;
    }

    public boolean isPointEvent() {
        return this.isSNP() || !this.isVariant();
    }

    public boolean isIndel() {
        return this.getType() == Type.INDEL;
    }

    public boolean isSimpleInsertion() {
        return this.getType() == Type.INDEL && this.getReference().isNull() && this.isBiallelic();
    }

    public boolean isSimpleDeletion() {
        return this.getType() == Type.INDEL && this.getAlternateAllele(0).isNull() && this.isBiallelic();
    }

    public boolean isComplexIndel() {
        return this.isIndel() && !this.isSimpleDeletion() && !this.isSimpleInsertion();
    }

    public boolean isSymbolic() {
        return this.getType() == Type.SYMBOLIC;
    }

    public boolean isMNP() {
        return this.getType() == Type.MNP;
    }

    public boolean isMixed() {
        return this.getType() == Type.MIXED;
    }

    public boolean hasID() {
        return this.getID() != ".";
    }

    public boolean emptyID() {
        return !this.hasID();
    }

    public String getID() {
        return this.ID;
    }

    public boolean hasReferenceBaseForIndel() {
        return this.REFERENCE_BASE_FOR_INDEL != null;
    }

    public Byte getReferenceBaseForIndel() {
        return this.REFERENCE_BASE_FOR_INDEL;
    }

    public String getSource() {
        return this.commonInfo.getName();
    }

    public Set<String> getFiltersMaybeNull() {
        return this.commonInfo.getFiltersMaybeNull();
    }

    public Set<String> getFilters() {
        return this.commonInfo.getFilters();
    }

    public boolean isFiltered() {
        return this.commonInfo.isFiltered();
    }

    public boolean isNotFiltered() {
        return this.commonInfo.isNotFiltered();
    }

    public boolean filtersWereApplied() {
        return this.commonInfo.filtersWereApplied();
    }

    public boolean hasLog10PError() {
        return this.commonInfo.hasLog10PError();
    }

    public double getLog10PError() {
        return this.commonInfo.getLog10PError();
    }

    public double getPhredScaledQual() {
        return this.commonInfo.getPhredScaledQual();
    }

    public Map<String, Object> getAttributes() {
        return this.commonInfo.getAttributes();
    }

    public boolean hasAttribute(String key) {
        return this.commonInfo.hasAttribute(key);
    }

    public Object getAttribute(String key) {
        return this.commonInfo.getAttribute(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        return this.commonInfo.getAttribute(key, defaultValue);
    }

    public String getAttributeAsString(String key, String defaultValue) {
        return this.commonInfo.getAttributeAsString(key, defaultValue);
    }

    public int getAttributeAsInt(String key, int defaultValue) {
        return this.commonInfo.getAttributeAsInt(key, defaultValue);
    }

    public double getAttributeAsDouble(String key, double defaultValue) {
        return this.commonInfo.getAttributeAsDouble(key, defaultValue);
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        return this.commonInfo.getAttributeAsBoolean(key, defaultValue);
    }

    public Allele getReference() {
        Allele ref = this.REF;
        if (ref == null) {
            throw new IllegalStateException("BUG: no reference allele found at " + this);
        }
        return ref;
    }

    public boolean isBiallelic() {
        return this.getNAlleles() == 2;
    }

    public int getNAlleles() {
        return this.alleles.size();
    }

    public Allele getAllele(String allele) {
        return this.getAllele(allele.getBytes());
    }

    public Allele getAllele(byte[] allele) {
        return Allele.getMatchingAllele(this.getAlleles(), allele);
    }

    public boolean hasAllele(Allele allele) {
        return this.hasAllele(allele, false, true);
    }

    public boolean hasAllele(Allele allele, boolean ignoreRefState) {
        return this.hasAllele(allele, ignoreRefState, true);
    }

    public boolean hasAlternateAllele(Allele allele) {
        return this.hasAllele(allele, false, false);
    }

    public boolean hasAlternateAllele(Allele allele, boolean ignoreRefState) {
        return this.hasAllele(allele, ignoreRefState, false);
    }

    private boolean hasAllele(Allele allele, boolean ignoreRefState, boolean considerRefAllele) {
        if (considerRefAllele && allele == this.REF || allele == this.ALT) {
            return true;
        }
        List<Allele> allelesToConsider = considerRefAllele ? this.getAlleles() : this.getAlternateAlleles();
        for (Allele a : allelesToConsider) {
            if (!a.equals(allele, ignoreRefState)) continue;
            return true;
        }
        return false;
    }

    public List<Allele> getAlleles() {
        return this.alleles;
    }

    public List<Allele> getAlternateAlleles() {
        return this.alleles.subList(1, this.alleles.size());
    }

    public List<Integer> getIndelLengths() {
        if (this.getType() != Type.INDEL && this.getType() != Type.MIXED) {
            return null;
        }
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (Allele a : this.getAlternateAlleles()) {
            lengths.add(a.length() - this.getReference().length());
        }
        return lengths;
    }

    public Allele getAlternateAllele(int i) {
        return this.alleles.get(i + 1);
    }

    public boolean hasSameAllelesAs(VariantContext other) {
        return this.hasSameAlternateAllelesAs(other) && other.getReference().equals(this.getReference(), false);
    }

    public boolean hasSameAlternateAllelesAs(VariantContext other) {
        List<Allele> thisAlternateAlleles = this.getAlternateAlleles();
        List<Allele> otherAlternateAlleles = other.getAlternateAlleles();
        if (thisAlternateAlleles.size() != otherAlternateAlleles.size()) {
            return false;
        }
        for (Allele allele : thisAlternateAlleles) {
            if (otherAlternateAlleles.contains(allele)) continue;
            return false;
        }
        return true;
    }

    public int getNSamples() {
        return this.genotypes.size();
    }

    public boolean hasGenotypes() {
        return !this.genotypes.isEmpty();
    }

    public boolean hasGenotypes(Collection<String> sampleNames) {
        return this.genotypes.containsSamples(sampleNames);
    }

    public GenotypesContext getGenotypes() {
        return this.genotypes;
    }

    public Iterable<Genotype> getGenotypesOrderedByName() {
        return this.genotypes.iterateInSampleNameOrder();
    }

    public Iterable<Genotype> getGenotypesOrderedBy(Iterable<String> sampleOrdering) {
        return this.genotypes.iterateInSampleNameOrder(sampleOrdering);
    }

    public GenotypesContext getGenotypes(String sampleName) {
        return this.getGenotypes(Collections.singleton(sampleName));
    }

    protected GenotypesContext getGenotypes(Collection<String> sampleNames) {
        return this.getGenotypes().subsetToSamples(new HashSet<String>(sampleNames));
    }

    public GenotypesContext getGenotypes(Set<String> sampleNames) {
        return this.getGenotypes().subsetToSamples(sampleNames);
    }

    public Set<String> getSampleNames() {
        return this.getGenotypes().getSampleNames();
    }

    public List<String> getSampleNamesOrderedByName() {
        return this.getGenotypes().getSampleNamesOrderedByName();
    }

    public Genotype getGenotype(String sample) {
        return this.getGenotypes().get(sample);
    }

    public boolean hasGenotype(String sample) {
        return this.getGenotypes().containsSample(sample);
    }

    public Genotype getGenotype(int ith) {
        return this.genotypes.get(ith);
    }

    public int getCalledChrCount() {
        return this.getCalledChrCount(new HashSet<String>(0));
    }

    public int getCalledChrCount(Set<String> sampleIds) {
        int n = 0;
        GenotypesContext genotypes = sampleIds.isEmpty() ? this.getGenotypes() : this.getGenotypes(sampleIds);
        for (Genotype g : genotypes) {
            for (Allele a : g.getAlleles()) {
                n += a.isNoCall() ? 0 : 1;
            }
        }
        return n;
    }

    public int getCalledChrCount(Allele a) {
        return this.getCalledChrCount(a, new HashSet<String>(0));
    }

    public int getCalledChrCount(Allele a, Set<String> sampleIds) {
        int n = 0;
        GenotypesContext genotypes = sampleIds.isEmpty() ? this.getGenotypes() : this.getGenotypes(sampleIds);
        for (Genotype g : genotypes) {
            n += g.getAlleles(a).size();
        }
        return n;
    }

    public boolean isMonomorphicInSamples() {
        if (this.monomorphic == null) {
            this.monomorphic = !this.isVariant() || this.hasGenotypes() && this.getCalledChrCount(this.getReference()) == this.getCalledChrCount();
        }
        return this.monomorphic;
    }

    public boolean isPolymorphicInSamples() {
        return !this.isMonomorphicInSamples();
    }

    private void calculateGenotypeCounts() {
        if (this.genotypeCounts == null) {
            this.genotypeCounts = new int[Genotype.Type.values().length];
            for (Genotype g : this.getGenotypes()) {
                int n = g.getType().ordinal();
                this.genotypeCounts[n] = this.genotypeCounts[n] + 1;
            }
        }
    }

    public int getNoCallCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[Genotype.Type.NO_CALL.ordinal()];
    }

    public int getHomRefCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[Genotype.Type.HOM_REF.ordinal()];
    }

    public int getHetCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[Genotype.Type.HET.ordinal()];
    }

    public int getHomVarCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[Genotype.Type.HOM_VAR.ordinal()];
    }

    public int getMixedCount() {
        this.calculateGenotypeCounts();
        return this.genotypeCounts[Genotype.Type.MIXED.ordinal()];
    }

    public void extraStrictValidation(Allele reference, Byte paddedRefBase, Set<String> rsIDs) {
        this.validateReferenceBases(reference, paddedRefBase);
        this.validateRSIDs(rsIDs);
        this.validateAlternateAlleles();
        this.validateChromosomeCounts();
    }

    public void validateReferenceBases(Allele reference, Byte paddedRefBase) {
        if (reference == null) {
            return;
        }
        if (!(this.isComplexIndel() || reference.isNull() || reference.basesMatch(this.getReference()))) {
            throw new TribbleException.InternalCodecException(String.format("the REF allele is incorrect for the record at position %s:%d, fasta says %s vs. VCF says %s", this.getChr(), this.getStart(), reference.getBaseString(), this.getReference().getBaseString()));
        }
        if (this.hasReferenceBaseForIndel() && !this.getReferenceBaseForIndel().equals(paddedRefBase)) {
            throw new TribbleException.InternalCodecException(String.format("the padded REF base is incorrect for the record at position %s:%d, fasta says %s vs. VCF says %s", this.getChr(), this.getStart(), Character.valueOf((char)paddedRefBase.byteValue()), Character.valueOf((char)this.getReferenceBaseForIndel().byteValue())));
        }
    }

    public void validateRSIDs(Set<String> rsIDs) {
        if (rsIDs != null && this.hasID()) {
            for (String id : this.getID().split(";")) {
                if (!id.startsWith("rs") || rsIDs.contains(id)) continue;
                throw new TribbleException.InternalCodecException(String.format("the rsID %s for the record at position %s:%d is not in dbSNP", id, this.getChr(), this.getStart()));
            }
        }
    }

    public void validateAlternateAlleles() {
        if (!this.hasGenotypes()) {
            return;
        }
        List<Allele> reportedAlleles = this.getAlleles();
        HashSet<Allele> observedAlleles = new HashSet<Allele>();
        observedAlleles.add(this.getReference());
        for (Genotype g : this.getGenotypes()) {
            if (!g.isCalled()) continue;
            observedAlleles.addAll(g.getAlleles());
        }
        if (reportedAlleles.size() != observedAlleles.size()) {
            throw new TribbleException.InternalCodecException(String.format("the ALT allele(s) for the record at position %s:%d do not match what is observed in the per-sample genotypes", this.getChr(), this.getStart()));
        }
        int originalSize = reportedAlleles.size();
        observedAlleles.retainAll(reportedAlleles);
        if (observedAlleles.size() != originalSize) {
            throw new TribbleException.InternalCodecException(String.format("the ALT allele(s) for the record at position %s:%d do not match what is observed in the per-sample genotypes", this.getChr(), this.getStart()));
        }
    }

    public void validateChromosomeCounts() {
        int observedAN;
        int reportedAN;
        if (!this.hasGenotypes()) {
            return;
        }
        if (this.hasAttribute("AN") && (reportedAN = Integer.valueOf(this.getAttribute("AN").toString()).intValue()) != (observedAN = this.getCalledChrCount())) {
            throw new TribbleException.InternalCodecException(String.format("the Allele Number (AN) tag is incorrect for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedAN, observedAN));
        }
        if (this.hasAttribute("AC")) {
            ArrayList<Integer> observedACs = new ArrayList<Integer>();
            if (this.getAlternateAlleles().size() > 0) {
                for (Allele allele : this.getAlternateAlleles()) {
                    observedACs.add(this.getCalledChrCount(allele));
                }
            } else {
                observedACs.add(0);
            }
            if (this.getAttribute("AC") instanceof List) {
                Collections.sort(observedACs);
                List reportedACs = (List)this.getAttribute("AC");
                Collections.sort(reportedACs);
                if (observedACs.size() != reportedACs.size()) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag doesn't have the correct number of values for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedACs.size(), observedACs.size()));
                }
                for (int i = 0; i < observedACs.size(); ++i) {
                    if (Integer.valueOf(reportedACs.get(i).toString()) == observedACs.get(i)) continue;
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag is incorrect for the record at position %s:%d, %s vs. %d", this.getChr(), this.getStart(), reportedACs.get(i), observedACs.get(i)));
                }
            } else {
                if (observedACs.size() != 1) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag doesn't have enough values for the record at position %s:%d", this.getChr(), this.getStart()));
                }
                int reportedAC = Integer.valueOf(this.getAttribute("AC").toString());
                if (reportedAC != (Integer)observedACs.get(0)) {
                    throw new TribbleException.InternalCodecException(String.format("the Allele Count (AC) tag is incorrect for the record at position %s:%d, %d vs. %d", this.getChr(), this.getStart(), reportedAC, observedACs.get(0)));
                }
            }
        }
    }

    private boolean validate(EnumSet<Validation> validationToPerform) {
        block5: for (Validation val : validationToPerform) {
            switch (val) {
                case ALLELES: {
                    this.validateAlleles();
                    continue block5;
                }
                case REF_PADDING: {
                    this.validateReferencePadding();
                    continue block5;
                }
                case GENOTYPES: {
                    this.validateGenotypes();
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unexpected validation mode " + (Object)((Object)val));
        }
        return true;
    }

    private void validateReferencePadding() {
        boolean needsPadding;
        if (this.hasSymbolicAlleles()) {
            return;
        }
        boolean bl = needsPadding = this.getReference().length() == this.getEnd() - this.getStart();
        if (needsPadding && !this.hasReferenceBaseForIndel()) {
            throw new ReviewedStingException("Badly formed variant context at location " + this.getChr() + ":" + this.getStart() + "; no padded reference base was provided.");
        }
    }

    private void validateAlleles() {
        boolean alreadySeenRef = false;
        boolean alreadySeenNull = false;
        for (Allele allele : this.alleles) {
            if (allele.isReference()) {
                if (alreadySeenRef) {
                    throw new IllegalArgumentException("BUG: Received two reference tagged alleles in VariantContext " + this.alleles + " this=" + this);
                }
                alreadySeenRef = true;
            }
            if (allele.isNoCall()) {
                throw new IllegalArgumentException("BUG: Cannot add a no call allele to a variant context " + this.alleles + " this=" + this);
            }
            if (!allele.isNull()) continue;
            if (alreadySeenNull) {
                throw new IllegalArgumentException("BUG: Received two null alleles in VariantContext " + this.alleles + " this=" + this);
            }
            alreadySeenNull = true;
        }
        if (!alreadySeenRef) {
            throw new IllegalArgumentException("No reference allele found in VariantContext");
        }
        long length = this.stop - this.start + 1L;
        if (this.getReference().isNull() && length != 1L || !this.isSymbolic() && this.getReference().isNonNull() && length - (long)this.getReference().length() > 1L) {
            throw new IllegalStateException("BUG: GenomeLoc " + this.contig + ":" + this.start + "-" + this.stop + " has a size == " + length + " but the variation reference allele has length " + this.getReference().length() + " this = " + this);
        }
    }

    private void validateGenotypes() {
        if (this.genotypes == null) {
            throw new IllegalStateException("Genotypes is null");
        }
        for (Genotype g : this.genotypes) {
            if (!g.isAvailable()) continue;
            for (Allele gAllele : g.getAlleles()) {
                if (this.hasAllele(gAllele) || !gAllele.isCalled()) continue;
                throw new IllegalStateException("Allele in genotype " + gAllele + " not in the variant context " + this.alleles);
            }
        }
    }

    private void determineType() {
        if (this.type == null) {
            switch (this.getNAlleles()) {
                case 0: {
                    throw new IllegalStateException("Unexpected error: requested type of VariantContext with no alleles!" + this);
                }
                case 1: {
                    this.type = Type.NO_VARIATION;
                    break;
                }
                default: {
                    this.determinePolymorphicType();
                }
            }
        }
    }

    private void determinePolymorphicType() {
        this.type = null;
        for (Allele allele : this.alleles) {
            if (allele == this.REF) continue;
            Type biallelicType = VariantContext.typeOfBiallelicVariant(this.REF, allele);
            if (this.type == null) {
                this.type = biallelicType;
                continue;
            }
            if (biallelicType == this.type) continue;
            this.type = Type.MIXED;
            return;
        }
    }

    private static Type typeOfBiallelicVariant(Allele ref, Allele allele) {
        if (ref.isSymbolic()) {
            throw new IllegalStateException("Unexpected error: encountered a record with a symbolic reference allele");
        }
        if (allele.isSymbolic()) {
            return Type.SYMBOLIC;
        }
        if (ref.length() == allele.length()) {
            if (allele.length() == 1) {
                return Type.SNP;
            }
            return Type.MNP;
        }
        return Type.INDEL;
    }

    public String toString() {
        return String.format("[VC %s @ %s of type=%s alleles=%s attr=%s GT=%s", new Object[]{this.getSource(), this.contig + ":" + (this.start - this.stop == 0L ? Long.valueOf(this.start) : this.start + "-" + this.stop), this.getType(), ParsingUtils.sortList(this.getAlleles()), ParsingUtils.sortedString(this.getAttributes()), this.getGenotypes()});
    }

    private static List<Allele> makeAlleles(Collection<Allele> alleles) {
        ArrayList<Allele> alleleList = new ArrayList<Allele>(alleles.size());
        boolean sawRef = false;
        for (Allele a : alleles) {
            for (Allele b : alleleList) {
                if (!a.equals(b, true)) continue;
                throw new IllegalArgumentException("Duplicate allele added to VariantContext: " + a);
            }
            if (a.isReference()) {
                if (sawRef) {
                    throw new IllegalArgumentException("Alleles for a VariantContext must contain at most one reference allele: " + alleles);
                }
                alleleList.add(0, a);
                sawRef = true;
                continue;
            }
            alleleList.add(a);
        }
        if (alleleList.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a VariantContext with an empty allele list");
        }
        if (((Allele)alleleList.get(0)).isNonReference()) {
            throw new IllegalArgumentException("Alleles for a VariantContext must contain at least one reference allele: " + alleles);
        }
        return alleleList;
    }

    @Override
    public String getChr() {
        return this.contig;
    }

    @Override
    public int getStart() {
        return (int)this.start;
    }

    @Override
    public int getEnd() {
        return (int)this.stop;
    }

    public boolean hasSymbolicAlleles() {
        for (Allele a : this.getAlleles()) {
            if (!a.isSymbolic()) continue;
            return true;
        }
        return false;
    }

    public Allele getAltAlleleWithHighestAlleleCount() {
        if (this.isBiallelic()) {
            return this.getAlternateAllele(0);
        }
        Allele best = null;
        int maxAC1 = 0;
        for (Allele a : this.getAlternateAlleles()) {
            int ac = this.getCalledChrCount(a);
            if (ac < maxAC1) continue;
            maxAC1 = ac;
            best = a;
        }
        return best;
    }

    public int[] getGLIndecesOfAlternateAllele(Allele targetAllele) {
        int index = 1;
        for (Allele allele : this.getAlternateAlleles()) {
            if (allele.equals(targetAllele)) break;
            ++index;
        }
        return GenotypeLikelihoods.getPLIndecesOfAlleles(0, index);
    }

    public static enum Type {
        NO_VARIATION,
        SNP,
        MNP,
        INDEL,
        SYMBOLIC,
        MIXED;

    }

    public static enum Validation {
        REF_PADDING,
        ALLELES,
        GENOTYPES;

    }
}

