/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class RMSMappingQuality
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        int totalSize = 0;
        for (AlignmentContext context : stratifiedContexts.values()) {
            totalSize += context.size();
        }
        int[] qualities = new int[totalSize];
        int index = 0;
        for (Map.Entry<String, AlignmentContext> sample : stratifiedContexts.entrySet()) {
            AlignmentContext context = sample.getValue();
            if (!context.hasBasePileup()) continue;
            ReadBackedPileup pileup = context.getBasePileup();
            for (PileupElement p : pileup) {
                if (p.getMappingQual() == 255) continue;
                qualities[index++] = p.getMappingQual();
            }
        }
        double rms = MathUtils.rms(qualities);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.2f", rms));
        return map;
    }

    @Override
    public Map<String, Object> annotate(Map<String, Map<Allele, List<GATKSAMRecord>>> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        int depth = 0;
        for (Map<Allele, List<GATKSAMRecord>> alleleBins : stratifiedContexts.values()) {
            for (Map.Entry entry : alleleBins.entrySet()) {
                depth += ((List)entry.getValue()).size();
            }
        }
        int[] qualities = new int[depth];
        int index = 0;
        for (Map map : stratifiedContexts.values()) {
            for (List reads : map.values()) {
                for (GATKSAMRecord read : reads) {
                    if (read.getMappingQuality() == 255) continue;
                    qualities[index++] = read.getMappingQuality();
                }
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.2f", MathUtils.rms(qualities)));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("MQ");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Float, "RMS Mapping Quality"));
    }
}

