/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.reflections.ReflectionsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Utils {
    public static final List<String> primitiveNames = Lists.newArrayList("boolean", "char", "byte", "short", "int", "long", "float", "double", "void");
    public static final List<Class> primitiveTypes = Lists.newArrayList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE);
    public static final List<String> primitiveDescriptors = Lists.newArrayList("Z", "C", "B", "S", "I", "J", "F", "D", "V");

    public static Class<?> forName(String typeName) {
        String type;
        if (primitiveNames.contains(typeName)) {
            return primitiveTypes.get(primitiveNames.indexOf(typeName));
        }
        if (typeName.contains("[")) {
            int i = typeName.indexOf("[");
            type = typeName.substring(0, i);
            String array = typeName.substring(i).replace("]", "");
            type = primitiveNames.contains(type) ? primitiveDescriptors.get(primitiveNames.indexOf(type)) : "L" + type + ";";
            type = array + type;
        } else {
            type = typeName;
        }
        try {
            return Class.forName(type, false, Utils.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<Class<? extends T>> forNames(Iterable<String> classes) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (String className : classes) {
            result.add(Utils.forName(className));
        }
        return result;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static String repeat(String string, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static File prepareFile(String filename) {
        File file = new File(filename);
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return file;
    }

    public static Method getMethodFromDescriptor(String descriptor) throws ReflectionsException {
        int p0 = descriptor.indexOf(40);
        String methodKey = descriptor.substring(0, p0);
        String methodParameters = descriptor.substring(p0 + 1, descriptor.length() - 1);
        int p1 = methodKey.lastIndexOf(46);
        String className = methodKey.substring(methodKey.lastIndexOf(32) + 1, p1);
        String methodName = methodKey.substring(p1 + 1);
        Class[] parameterTypes = null;
        if (!Utils.isEmpty(methodParameters)) {
            String[] parameterNames = methodParameters.split(", ");
            ArrayList result = new ArrayList(parameterNames.length);
            for (String className1 : parameterNames) {
                result.add(Utils.forName(className1));
            }
            ArrayList types = result;
            parameterTypes = types.toArray(new Class[types.size()]);
        }
        Class<?> aClass = Utils.forName(className);
        try {
            if (descriptor.contains("<init>")) {
                return null;
            }
            return aClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionsException("Can't resolve method named " + methodName, e);
        }
    }

    public static Field getFieldFromString(String field) {
        String className = field.substring(0, field.lastIndexOf(46));
        String fieldName = field.substring(field.lastIndexOf(46) + 1);
        try {
            return Utils.forName(className).getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionsException("Can't resolve field named " + fieldName, e);
        }
    }
}

